/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.workflow;

import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Run;
import java.util.Collections;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SetGerritReviewStep
extends Step {
    private String customUrl;
    private String unsuccessfulMessage;

    @DataBoundConstructor
    public SetGerritReviewStep() {
    }

    @CheckForNull
    public String getCustomUrl() {
        return this.customUrl;
    }

    @DataBoundSetter
    public void setCustomUrl(String customUrl) {
        this.customUrl = Util.fixEmptyAndTrim((String)customUrl);
    }

    @CheckForNull
    public String getUnsuccessfulMessage() {
        return this.unsuccessfulMessage;
    }

    @DataBoundSetter
    public void setUnsuccessfulMessage(String unsuccessfulMessage) {
        this.unsuccessfulMessage = Util.fixEmptyAndTrim((String)unsuccessfulMessage);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }

        public String getFunctionName() {
            return "setGerritReview";
        }

        public String getDisplayName() {
            return "Set Gerrit review";
        }
    }

    public static class Execution
    extends SynchronousStepExecution<Void> {
        private final transient SetGerritReviewStep step;
        private static final long serialVersionUID = 1L;

        protected Execution(SetGerritReviewStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            String unsuccessfulMessage;
            ToGerritRunListener listener = ToGerritRunListener.getInstance();
            String customUrl = this.step.getCustomUrl();
            if (customUrl != null) {
                listener.setBuildCustomUrl((Run)this.getContext().get(Run.class), customUrl);
            }
            if ((unsuccessfulMessage = this.step.getUnsuccessfulMessage()) != null) {
                listener.setBuildUnsuccessfulMessage((Run)this.getContext().get(Run.class), unsuccessfulMessage);
            }
            return null;
        }
    }
}

