/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.replication;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefReplicated;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationCache {
    public static final int DEFAULT_EXPIRATION_IN_MINUTES = (int)TimeUnit.HOURS.toMinutes(6L);
    private static final Logger logger = LoggerFactory.getLogger(ReplicationCache.class);
    private final long expiration;
    private final TimeUnit unit;
    private long creationTime;
    private Cache<RefReplicatedId, RefReplicated> events = null;

    public ReplicationCache() {
        this(DEFAULT_EXPIRATION_IN_MINUTES, TimeUnit.MINUTES);
    }

    public ReplicationCache(long expiration, TimeUnit unit) {
        this.expiration = expiration >= 0L ? expiration : (long)DEFAULT_EXPIRATION_IN_MINUTES;
        this.unit = unit != null ? unit : TimeUnit.MINUTES;
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
    }

    public boolean initialize() {
        if (this.events == null) {
            try {
                this.events = Caffeine.newBuilder().expireAfterWrite(this.expiration, this.unit).build();
                logger.info("initialized replication cache with expiration in {}: {}", (Object)this.unit, (Object)this.expiration);
            }
            catch (Exception ex) {
                logger.warn("initialize failure in {}: {}", (Object)this.unit, (Object)this.expiration);
                return false;
            }
        }
        return true;
    }

    public void put(RefReplicated refReplicated) {
        if (this.events != null) {
            this.events.put((Object)RefReplicatedId.fromRefReplicated(refReplicated), (Object)refReplicated);
        }
    }

    public boolean isExpired(long timestamp) {
        return System.currentTimeMillis() - timestamp > this.unit.toMillis(this.expiration) || timestamp < this.creationTime;
    }

    public RefReplicated getIfPresent(String gerritServer, String gerritProject, String ref, String slaveHost) {
        if (this.events != null) {
            RefReplicatedId refReplicatedId = new RefReplicatedId(gerritServer, gerritProject, ref, slaveHost);
            return (RefReplicated)this.events.getIfPresent((Object)refReplicatedId);
        }
        return null;
    }

    private static class RefReplicatedId {
        private String gerritServer;
        private String project;
        private String ref;
        private String targetNode;

        public RefReplicatedId(String gerritServer, String project, String ref, String targetNode) {
            this.gerritServer = gerritServer;
            this.project = project;
            this.ref = ref;
            this.targetNode = targetNode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.gerritServer == null ? 0 : this.gerritServer.hashCode());
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
            result = 31 * result + (this.targetNode == null ? 0 : this.targetNode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RefReplicatedId other = (RefReplicatedId)obj;
            if (this.gerritServer == null ? other.gerritServer != null : !this.gerritServer.equals(other.gerritServer)) {
                return false;
            }
            if (this.project == null ? other.project != null : !this.project.equals(other.project)) {
                return false;
            }
            if (this.ref == null ? other.ref != null : !this.ref.equals(other.ref)) {
                return false;
            }
            return !(this.targetNode == null ? other.targetNode != null : !this.targetNode.equals(other.targetNode));
        }

        private static RefReplicatedId fromRefReplicated(RefReplicated refReplicated) {
            String gerritServer = null;
            if (refReplicated.getProvider() != null) {
                gerritServer = refReplicated.getProvider().getName();
            }
            return new RefReplicatedId(gerritServer, refReplicated.getProject(), refReplicated.getRef(), refReplicated.getTargetNode());
        }
    }

    public static final class Factory {
        private static final Logger logger = LoggerFactory.getLogger(Factory.class);

        private Factory() {
        }

        public static ReplicationCache createCache() {
            ReplicationCache cache = new ReplicationCache();
            cache.initialize();
            return cache;
        }

        public static ReplicationCache createCache(long expiration, TimeUnit unit) {
            ReplicationCache cache = new ReplicationCache(expiration, unit);
            if (!cache.initialize()) {
                logger.info("Initialized replication cache with default settings.");
                cache = new ReplicationCache();
                cache.initialize();
            }
            return cache;
        }
    }
}

