/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.playback;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GerritMissedEventsPlaybackEnabledChecker
extends AsyncPeriodicWork {
    private static final long DEFAULTCHECKPERIOD = 86400L;
    private final Long recurrencePeriod = Long.getLong("com.sonyericsson.hudson.plugins.gerrit.trigger.playback.checkEnabledPeriod", TimeUnit.SECONDS.toMillis(86400L));
    private static final Logger logger = LoggerFactory.getLogger(GerritMissedEventsPlaybackEnabledChecker.class);

    protected Level getNormalLoggingLevel() {
        return Level.FINEST;
    }

    public GerritMissedEventsPlaybackEnabledChecker() {
        super("GerritMissedEventsPlaybackEnabledChecker");
        logger.debug("checkIfEventsLogPluginSupported check period is {0}ms", (Object)this.recurrencePeriod);
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        List<GerritServer> servers = PluginImpl.getServers_();
        for (GerritServer gs : servers) {
            if (gs != null && gs.getMissedEventsPlaybackManager() != null) {
                logger.debug("Performing plugin check for server: {0}", (Object)gs.getName());
                gs.getMissedEventsPlaybackManager().performCheck();
                continue;
            }
            logger.debug("Skip plugin check, because server is not completely initialised");
        }
    }

    public long getRecurrencePeriod() {
        return this.recurrencePeriod;
    }
}

