/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import com.sonymobile.tools.gerrit.gerritevents.dto.GerritChangeStatus;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Change;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class TopicAssociation
extends AbstractDescribableImpl<TopicAssociation> {
    private boolean ignoreNewChangeStatus;
    private boolean ignoreMergedChangeStatus;
    private boolean ignoreAbandonedChangeStatus;

    @DataBoundConstructor
    public TopicAssociation(boolean ignoreNewChangeStatus, boolean ignoreMergedChangeStatus, boolean ignoreAbandonedChangeStatus) {
        this.ignoreNewChangeStatus = ignoreNewChangeStatus;
        this.ignoreMergedChangeStatus = ignoreMergedChangeStatus;
        this.ignoreAbandonedChangeStatus = ignoreAbandonedChangeStatus;
    }

    public TopicAssociation() {
        this.ignoreNewChangeStatus = false;
        this.ignoreMergedChangeStatus = false;
        this.ignoreAbandonedChangeStatus = false;
    }

    public boolean isIgnoreNewChangeStatus() {
        return this.ignoreNewChangeStatus;
    }

    public void setIgnoreNewChangeStatus(boolean ignoreNewChangeStatus) {
        this.ignoreNewChangeStatus = ignoreNewChangeStatus;
    }

    public boolean isIgnoreMergedChangeStatus() {
        return this.ignoreMergedChangeStatus;
    }

    public void setIgnoreMergedChangeStatus(boolean ignoreMergedChangeStatus) {
        this.ignoreMergedChangeStatus = ignoreMergedChangeStatus;
    }

    public boolean isIgnoreAbandonedChangeStatus() {
        return this.ignoreAbandonedChangeStatus;
    }

    public void setIgnoreAbandonedChangeStatus(boolean ignoreAbandonedChangeStatus) {
        this.ignoreAbandonedChangeStatus = ignoreAbandonedChangeStatus;
    }

    public boolean isInterestingChangeStatus(Change c) {
        boolean isNewChange = c.getStatus().equals((Object)GerritChangeStatus.NEW);
        boolean isMergedChange = c.getStatus().equals((Object)GerritChangeStatus.MERGED);
        boolean isAbandonedChange = c.getStatus().equals((Object)GerritChangeStatus.ABANDONED);
        if (isNewChange && this.ignoreNewChangeStatus) {
            return false;
        }
        if (isMergedChange && this.ignoreMergedChangeStatus) {
            return false;
        }
        return !isAbandonedChange || !this.ignoreAbandonedChangeStatus;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TopicAssociation> {
        public String getDisplayName() {
            return "Topic Association";
        }
    }
}

