/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggeredItemEntity;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import hudson.model.Action;
import hudson.model.Job;
import java.io.IOException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class RetriggerAllAction
implements Action {
    private TriggerContext context;

    public RetriggerAllAction(TriggerContext context) {
        this.context = context;
    }

    public RetriggerAllAction() {
    }

    public String getIconFileName() {
        if (!this.hasPermission() || this.isBuilding() || !this.hasOthers()) {
            return null;
        }
        return StringUtil.getPluginImageUrl("icon_retrigger24.png");
    }

    public String getDisplayName() {
        if (!this.hasPermission() || this.isBuilding() || !this.hasOthers()) {
            return null;
        }
        return Messages.RetriggerAll();
    }

    public String getUrlName() {
        if (!this.hasPermission() || this.isBuilding() || !this.hasOthers()) {
            return null;
        }
        return "gerrit-trigger-retrigger-all";
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasOthers() {
        if (this.context != null) {
            return this.context.hasOthers();
        }
        return false;
    }

    private boolean isBuilding() {
        if (this.context != null) {
            ToGerritRunListener listener = ToGerritRunListener.getInstance();
            if (listener == null) {
                return this.context.getThisBuild().getBuild().isBuilding();
            }
            return this.context.getThisBuild().getBuild().isBuilding() || listener.isBuilding(this.context.getEvent());
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasPermission() {
        if (this.context == null || this.context.getThisBuild() == null || this.context.getThisBuild().getProject() == null) {
            return false;
        }
        if (this.context.getThisBuild().getProject().hasPermission(PluginImpl.RETRIGGER)) {
            for (Job project : this.context.getOtherProjects()) {
                if (project.hasPermission(PluginImpl.RETRIGGER)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @POST
    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.context == null || this.context.getThisBuild() == null) {
            return;
        }
        if (!this.hasPermission()) {
            return;
        }
        if (this.isBuilding()) {
            return;
        }
        if (!this.context.hasOthers()) {
            return;
        }
        TriggeredItemEntity entity = this.context.getThisBuild();
        GerritTrigger trigger = GerritTrigger.getTrigger(entity.getProject());
        if (trigger == null) {
            return;
        }
        trigger.retriggerAllBuilds(this.context);
        response.sendRedirect2(entity.getProject().getAbsoluteUrl());
    }
}

