/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.NewPatchSetInterruption;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.BuildCancellationPolicy;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningJobs {
    private final GerritTrigger trigger;
    private Item job;
    private final Set<GerritTriggeredEvent> runningJobs = Collections.synchronizedSet(new HashSet());
    private static final Logger logger = LoggerFactory.getLogger(RunningJobs.class);

    public RunningJobs(GerritTrigger trigger, Item job) {
        this.trigger = trigger;
        this.job = job;
    }

    public Item getJob() {
        return this.job;
    }

    public void setJob(Item job) {
        this.job = job;
    }

    public void cancelTriggeredJob(ChangeBasedEvent event, String jobName, BuildCancellationPolicy policy) {
        if (policy == null || !policy.isEnabled() && event instanceof ManualPatchsetCreated && !policy.isAbortManualPatchsets()) {
            return;
        }
        this.cancelOutDatedEvents(event, policy, jobName);
    }

    public void scheduled(ChangeBasedEvent event) {
        IGerritHudsonTriggerConfig serverConfig = PluginImpl.getServerConfig((GerritTriggeredEvent)event);
        if (serverConfig == null) {
            this.runningJobs.add((GerritTriggeredEvent)event);
            return;
        }
        BuildCancellationPolicy serverBuildCurrentPatchesOnly = serverConfig.getBuildCurrentPatchesOnly();
        if (!serverBuildCurrentPatchesOnly.isEnabled() || event instanceof ManualPatchsetCreated && !serverBuildCurrentPatchesOnly.isAbortManualPatchsets()) {
            this.runningJobs.add((GerritTriggeredEvent)event);
            return;
        }
        this.cancelOutDatedEvents(event, serverBuildCurrentPatchesOnly, this.getJob().getFullName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelOutDatedEvents(ChangeBasedEvent event, BuildCancellationPolicy policy, String jobName) {
        ArrayList<ChangeBasedEvent> outdatedEvents = new ArrayList<ChangeBasedEvent>();
        Set<GerritTriggeredEvent> set = this.runningJobs;
        synchronized (set) {
            Iterator<GerritTriggeredEvent> it = this.runningJobs.iterator();
            while (it.hasNext()) {
                ChangeBasedEvent runningChangeBasedEvent;
                GerritTriggeredEvent runningEvent = it.next();
                if (!(runningEvent instanceof ChangeBasedEvent) || this.shouldIgnoreEvent(event, policy, runningChangeBasedEvent = (ChangeBasedEvent)runningEvent)) continue;
                outdatedEvents.add(runningChangeBasedEvent);
                it.remove();
            }
            if (!outdatedEvents.contains(event)) {
                this.runningJobs.add((GerritTriggeredEvent)event);
            }
        }
        for (ChangeBasedEvent outdatedEvent : outdatedEvents) {
            logger.debug("Cancelling build for " + outdatedEvent);
            try {
                this.cancelMatchingJobs((GerritTriggeredEvent)outdatedEvent, jobName);
            }
            catch (Exception e) {
                logger.error("Error canceling job", (Throwable)e);
            }
        }
    }

    private boolean shouldIgnoreEvent(ChangeBasedEvent event, BuildCancellationPolicy policy, ChangeBasedEvent runningChangeBasedEvent) {
        boolean shouldCancelPatchsetNumber;
        boolean shouldCancelManual;
        boolean abortBecauseOfTopic = this.trigger.abortBecauseOfTopic(event, policy, runningChangeBasedEvent);
        if (!abortBecauseOfTopic && !runningChangeBasedEvent.getChange().equals((Object)event.getChange())) {
            return true;
        }
        boolean bl = shouldCancelManual = runningChangeBasedEvent instanceof ManualPatchsetCreated && policy.isAbortManualPatchsets() || !(runningChangeBasedEvent instanceof ManualPatchsetCreated);
        if (!abortBecauseOfTopic && !shouldCancelManual) {
            return true;
        }
        boolean bl2 = shouldCancelPatchsetNumber = policy.isAbortNewPatchsets() || Integer.parseInt(runningChangeBasedEvent.getPatchSet().getNumber()) < Integer.parseInt(event.getPatchSet().getNumber());
        return !abortBecauseOfTopic && !shouldCancelPatchsetNumber;
    }

    private void cancelMatchingJobs(GerritTriggeredEvent event, String jobName) {
        try {
            if (!(this.job instanceof Queue.Task)) {
                logger.error("Error canceling job. The job is not of type Task. Job name: " + this.getJob().getName());
                return;
            }
            List itemsInQueue = Queue.getInstance().getItems((Queue.Task)this.getJob());
            for (Queue.Item item : itemsInQueue) {
                if (!this.checkCausedByGerrit(event, item.getCauses()) || !jobName.equals(item.task.getName())) continue;
                Queue.getInstance().cancel(item);
            }
            Jenkins jenkins = Jenkins.get();
            for (Computer c : jenkins.getComputers()) {
                for (Executor e : c.getAllExecutors()) {
                    String runningJobName;
                    Run run;
                    Queue.Executable currentExecutable = e.getCurrentExecutable();
                    if (!(currentExecutable instanceof Run) || !this.checkCausedByGerrit(event, (run = (Run)currentExecutable).getCauses()) || !jobName.equals(runningJobName = run.getParent().getFullName())) continue;
                    e.interrupt(Result.ABORTED, new CauseOfInterruption[]{new NewPatchSetInterruption()});
                }
            }
        }
        catch (Exception e) {
            logger.error("Error canceling job", (Throwable)e);
        }
    }

    private boolean checkCausedByGerrit(GerritTriggeredEvent event, Collection<Cause> causes) {
        for (Cause c : causes) {
            GerritCause gc;
            if (!(c instanceof GerritCause) || (gc = (GerritCause)c).getEvent() != event) continue;
            return true;
        }
        return false;
    }

    public boolean remove(ChangeBasedEvent event) {
        logger.debug("Removing future job " + event.getPatchSet().getNumber());
        return this.runningJobs.remove(event);
    }
}

