/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;

public class GerritUserCause
extends GerritCause {
    private final String authenticationName;

    public GerritUserCause() {
        this.authenticationName = null;
    }

    public GerritUserCause(GerritTriggeredEvent event, boolean silentMode, TriggerContext context) {
        super(event, silentMode, context);
        this.authenticationName = Jenkins.getAuthentication().getName();
    }

    public GerritUserCause(GerritTriggeredEvent event, boolean silentMode, TriggerContext context, String authenticationName) {
        super(event, silentMode, context);
        this.authenticationName = authenticationName;
    }

    public GerritUserCause(GerritTriggeredEvent event, boolean silentMode, String authenticationName) {
        super(event, silentMode);
        this.authenticationName = authenticationName;
    }

    public GerritUserCause(GerritTriggeredEvent event, boolean silentMode) {
        super(event, silentMode);
        this.authenticationName = Jenkins.getAuthentication().getName();
    }

    @Exported(visibility=3)
    public String getUserName() {
        return this.authenticationName;
    }

    @Override
    protected String getShortGerritDescription() {
        return Messages.ReTriggeredShortDescription(this.getUrl(), this.getUserName());
    }

    @Override
    protected String getShortGerritDescriptionSilentMode() {
        return Messages.ReTriggeredShortDescriptionInSilentMode(this.getUrl(), this.getUserName());
    }
}

