/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.notification;

import java.util.ArrayList;
import java.util.List;

public class NotificationCommands {
    private String command;
    private List<String> commandsTopicChange;

    public NotificationCommands(String command) {
        this.command = command;
        this.commandsTopicChange = new ArrayList<String>();
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getCommandsTopicChanges() {
        return this.commandsTopicChange;
    }

    public void addTopicChangeCommand(String gerritCommand) {
        this.commandsTopicChange.add(gerritCommand);
    }

    public boolean hasTopicChanges() {
        return this.commandsTopicChange.size() > 0;
    }

    private boolean isValidCommand(String gerritCommand) {
        if (gerritCommand == null) {
            return false;
        }
        return !gerritCommand.isEmpty();
    }

    public boolean isTopicChangeListCommandsValid() {
        for (String changeCommand : this.commandsTopicChange) {
            if (this.isValidCommand(changeCommand)) continue;
            return false;
        }
        return true;
    }

    public boolean isMainCommandValid() {
        return this.isValidCommand(this.command);
    }

    public boolean isValid() {
        return this.isMainCommandValid() && this.isTopicChangeListCommandsValid();
    }
}

