/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.notification;

import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ParameterExpander;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.notification.Notification;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.notification.NotificationCommands;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritChangeStatus;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Change;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.PatchSet;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Topic;
import hudson.model.TaskListener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationBuildCompleted
extends Notification {
    private static final Logger logger = LoggerFactory.getLogger(NotificationBuildCompleted.class);
    private final BuildMemory.MemoryImprint memoryImprint;
    private final TaskListener listener;
    private NotificationCommands commands;

    public NotificationBuildCompleted(BuildMemory.MemoryImprint memoryImprint, TaskListener listener, ParameterExpander parameterExpander) {
        super(parameterExpander, memoryImprint.getEvent());
        this.memoryImprint = memoryImprint;
        this.listener = listener;
        this.initCommands();
    }

    private void initCommands() {
        ChangeBasedEvent event = (ChangeBasedEvent)this.gerritEvent;
        String command = this.parameterExpander.getBuildCompletedCommand(this.memoryImprint, this.listener, null);
        this.commands = new NotificationCommands(command);
        Topic topic = event.getChange().getTopicObject();
        if (topic == null) {
            return;
        }
        if (!this.isVoteSameTopic()) {
            return;
        }
        Map<Change, PatchSet> changes = this.queryTopicChanges();
        for (Map.Entry<Change, PatchSet> entry : changes.entrySet()) {
            Change change = entry.getKey();
            if (change.equals((Object)event.getChange()) || change.getStatus() == GerritChangeStatus.ABANDONED) continue;
            PatchSet patchSet = entry.getValue();
            GerritTriggeredEvent eventTopicChange = this.createEventTopicChange((GerritTriggeredEvent)event, change, patchSet);
            String topicChangeCommand = this.parameterExpander.getBuildCompletedCommand(this.memoryImprint, this.listener, eventTopicChange);
            this.commands.addTopicChangeCommand(topicChangeCommand);
        }
    }

    @Override
    public NotificationCommands getCommands() {
        return this.commands;
    }

    @Override
    public boolean isValid() {
        return this.commands.isValid();
    }
}

