/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.notification;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ParameterExpander;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.notification.INotification;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Change;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.PatchSet;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Topic;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Notification
implements INotification {
    private static final Logger logger = LoggerFactory.getLogger(Notification.class);
    protected GerritTriggeredEvent gerritEvent;
    protected ParameterExpander parameterExpander;

    public Notification(ParameterExpander parameterExpander, GerritTriggeredEvent gerritEvent) {
        this.parameterExpander = parameterExpander;
        this.gerritEvent = gerritEvent;
    }

    @Override
    public boolean isVoteSameTopic() {
        IGerritHudsonTriggerConfig config = PluginImpl.getServerConfig(this.gerritEvent);
        if (config == null) {
            logger.error("Could not get server config!");
            return false;
        }
        return config.isVoteSameTopic();
    }

    public Map<Change, PatchSet> queryTopicChanges() {
        ChangeBasedEvent event = (ChangeBasedEvent)this.gerritEvent;
        Topic topic = event.getChange().getTopicObject();
        if (topic == null) {
            logger.error("Topic is null not querying changes!");
            return Collections.emptyMap();
        }
        GerritServer server = PluginImpl.getServer_((GerritTriggeredEvent)event);
        if (server == null) {
            logger.error("Could not get gerrit server based on event!");
            return Collections.emptyMap();
        }
        return topic.getChanges(server.getQueryHandler());
    }

    protected GerritTriggeredEvent createEventTopicChange(GerritTriggeredEvent event, Change change, PatchSet patchSet) {
        PatchsetCreated eventTopicChange = new PatchsetCreated();
        eventTopicChange.setAccount(event.getAccount());
        eventTopicChange.setProvider(event.getProvider());
        eventTopicChange.setReceivedOn(event.getReceivedOn());
        eventTopicChange.setChange(change);
        eventTopicChange.setPatchset(patchSet);
        return eventTopicChange;
    }
}

