/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.config;

import com.sonyericsson.hudson.plugins.gerrit.trigger.VerdictCategory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.ReplicationConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.BuildCancellationPolicy;
import com.sonymobile.tools.gerrit.gerritevents.GerritDefaultValues;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Notify;
import com.sonymobile.tools.gerrit.gerritevents.ssh.Authentication;
import com.sonymobile.tools.gerrit.gerritevents.watchdog.WatchTimeExceptionData;
import hudson.util.Secret;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Config
implements IGerritHudsonTriggerConfig {
    public static final int DEFAULT_GERRIT_BUILD_STARTED_VERIFIED_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_UNSTABLE_VERIFIED_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_FAILURE_VERIFIED_VALUE = -1;
    public static final int DEFAULT_GERRIT_BUILD_SUCCESSFUL_VERIFIED_VALUE = 1;
    public static final int DEFAULT_GERRIT_BUILD_NOT_BUILT_VERIFIED_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_ABORTED_VERIFIED_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_STARTED_CODE_REVIEW_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_UNSTABLE_CODE_REVIEW_VALUE = -1;
    public static final int DEFAULT_GERRIT_BUILD_FAILURE_CODE_REVIEW_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_SUCCESSFUL_CODE_REVIEW_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_NOT_BUILT_CODE_REVIEW_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_ABORTED_CODE_REVIEW_VALUE = 0;
    public static final boolean DEFAULT_ENABLE_PROJECT_AUTO_COMPLETION = true;
    public static final int DEFAULT_DYNAMIC_CONFIG_REFRESH_INTERVAL = 30;
    public static final int DEFAULT_PROJECT_LIST_FETCH_DELAY = 0;
    public static final int DEFAULT_PROJECT_LIST_REFRESH_INTERVAL = 3600;
    public static final int DEFAULT_GERRIT_WATCHDOG_TIMEOUT_MINUTES = 0;
    public static final boolean DEFAULT_ENABLE_MANUAL_TRIGGER = true;
    public static final boolean DEFAULT_ENABLE_PLUGIN_MESSAGES = true;
    public static final boolean DEFAULT_ENABLE_TOPIC_ASSOCIATION = false;
    public static final boolean DEFAULT_TRIGGER_ON_ALL_COMMENTS = false;
    public static final boolean DEFAULT_BUILD_CURRENT_PATCHES_ONLY = false;
    public static final Notify DEFAULT_NOTIFICATION_LEVEL = Notify.ALL;
    private String gerritHostName;
    private int gerritSshPort;
    private String gerritProxy;
    private String gerritUserName;
    private String gerritEMail;
    private File gerritAuthKeyFile;
    private Secret gerritAuthKeyFilePassword;
    private boolean useRestApi;
    private String gerritHttpUserName;
    private Secret gerritHttpPassword;
    private boolean restCodeReview;
    private boolean restVerified;
    @Deprecated
    private transient boolean gerritBuildCurrentPatchesOnly;
    @Deprecated
    private transient int numberOfWorkerThreads;
    private String gerritVerifiedCmdBuildSuccessful;
    private String gerritVerifiedCmdBuildUnstable;
    private String gerritVerifiedCmdBuildFailed;
    private String gerritVerifiedCmdBuildStarted;
    private String gerritVerifiedCmdBuildNotBuilt;
    private String gerritVerifiedCmdBuildAborted;
    private String gerritFrontEndUrl;
    private Integer gerritBuildStartedVerifiedValue = null;
    private Integer gerritBuildSuccessfulVerifiedValue = null;
    private Integer gerritBuildFailedVerifiedValue = null;
    private Integer gerritBuildUnstableVerifiedValue = null;
    private Integer gerritBuildNotBuiltVerifiedValue = null;
    private Integer gerritBuildAbortedVerifiedValue = null;
    private Integer gerritBuildStartedCodeReviewValue = null;
    private Integer gerritBuildSuccessfulCodeReviewValue = null;
    private Integer gerritBuildFailedCodeReviewValue = null;
    private Integer gerritBuildUnstableCodeReviewValue = null;
    private Integer gerritBuildNotBuiltCodeReviewValue = null;
    private Integer gerritBuildAbortedCodeReviewValue = null;
    private boolean enableManualTrigger;
    private boolean enablePluginMessages;
    private boolean triggerOnAllComments;
    @Deprecated
    private transient int numberOfSendingWorkerThreads;
    private int buildScheduleDelay;
    private int dynamicConfigRefreshInterval;
    private boolean enableProjectAutoCompletion;
    private int projectListRefreshInterval;
    @Deprecated
    private transient boolean loadProjectListOnStartup;
    private int projectListFetchDelay;
    private List<VerdictCategory> categories;
    private ReplicationConfig replicationConfig;
    private int watchdogTimeoutMinutes;
    private WatchTimeExceptionData watchTimeExceptionData;
    private Notify notificationLevel;
    private BuildCancellationPolicy buildCurrentPatchesOnly;
    private boolean voteSameTopic;

    public Config(JSONObject formData) {
        this.setValues(formData);
    }

    public Config(IGerritHudsonTriggerConfig config) {
        this.gerritHostName = config.getGerritHostName();
        this.gerritSshPort = config.getGerritSshPort();
        this.gerritProxy = config.getGerritProxy();
        this.gerritUserName = config.getGerritUserName();
        this.gerritEMail = config.getGerritEMail();
        this.notificationLevel = config.getNotificationLevel();
        this.gerritAuthKeyFile = new File(config.getGerritAuthKeyFile().getPath());
        this.gerritAuthKeyFilePassword = Secret.fromString((String)config.getGerritAuthKeyFilePassword());
        this.useRestApi = config.isUseRestApi();
        this.gerritHttpUserName = config.getGerritHttpUserName();
        this.gerritHttpPassword = Secret.fromString((String)config.getGerritHttpPassword());
        this.restCodeReview = config.isRestCodeReview();
        this.restVerified = config.isRestVerified();
        this.gerritBuildCurrentPatchesOnly = config.isGerritBuildCurrentPatchesOnly();
        this.numberOfWorkerThreads = config.getNumberOfReceivingWorkerThreads();
        this.numberOfSendingWorkerThreads = config.getNumberOfSendingWorkerThreads();
        this.gerritBuildStartedVerifiedValue = config.getGerritBuildStartedVerifiedValue();
        this.gerritBuildStartedCodeReviewValue = config.getGerritBuildStartedCodeReviewValue();
        this.gerritBuildSuccessfulVerifiedValue = config.getGerritBuildSuccessfulVerifiedValue();
        this.gerritBuildSuccessfulCodeReviewValue = config.getGerritBuildSuccessfulCodeReviewValue();
        this.gerritBuildFailedVerifiedValue = config.getGerritBuildFailedVerifiedValue();
        this.gerritBuildFailedCodeReviewValue = config.getGerritBuildFailedCodeReviewValue();
        this.gerritBuildUnstableVerifiedValue = config.getGerritBuildUnstableVerifiedValue();
        this.gerritBuildUnstableCodeReviewValue = config.getGerritBuildUnstableCodeReviewValue();
        this.gerritBuildNotBuiltVerifiedValue = config.getGerritBuildNotBuiltVerifiedValue();
        this.gerritBuildNotBuiltCodeReviewValue = config.getGerritBuildNotBuiltCodeReviewValue();
        this.gerritBuildAbortedVerifiedValue = config.getGerritBuildAbortedVerifiedValue();
        this.gerritBuildAbortedCodeReviewValue = config.getGerritBuildAbortedCodeReviewValue();
        this.gerritVerifiedCmdBuildStarted = config.getGerritCmdBuildStarted();
        this.gerritVerifiedCmdBuildFailed = config.getGerritCmdBuildFailed();
        this.gerritVerifiedCmdBuildSuccessful = config.getGerritCmdBuildSuccessful();
        this.gerritVerifiedCmdBuildUnstable = config.getGerritCmdBuildUnstable();
        this.gerritVerifiedCmdBuildNotBuilt = config.getGerritCmdBuildNotBuilt();
        this.gerritVerifiedCmdBuildAborted = config.getGerritCmdBuildAborted();
        this.gerritFrontEndUrl = config.getGerritFrontEndUrl();
        this.enableManualTrigger = config.isEnableManualTrigger();
        this.enablePluginMessages = config.isEnablePluginMessages();
        this.triggerOnAllComments = config.isTriggerOnAllComments();
        this.buildScheduleDelay = config.getBuildScheduleDelay();
        this.dynamicConfigRefreshInterval = config.getDynamicConfigRefreshInterval();
        this.enableProjectAutoCompletion = config.isEnableProjectAutoCompletion();
        this.projectListFetchDelay = config.getProjectListFetchDelay();
        this.projectListRefreshInterval = config.getProjectListRefreshInterval();
        if (config.getCategories() != null) {
            this.categories = new LinkedList<VerdictCategory>();
            for (VerdictCategory cat : config.getCategories()) {
                this.categories.add(new VerdictCategory(cat.getVerdictValue(), cat.getVerdictDescription()));
            }
        }
        if (config.getReplicationConfig() != null) {
            this.replicationConfig = new ReplicationConfig(config.getReplicationConfig());
        }
        this.watchdogTimeoutMinutes = config.getWatchdogTimeoutMinutes();
        this.watchTimeExceptionData = this.addWatchTimeExceptionData(config.getExceptionData());
    }

    @Override
    public void setValues(JSONObject formData) {
        this.gerritHostName = formData.optString("gerritHostName", "");
        this.gerritSshPort = formData.optInt("gerritSshPort", 29418);
        this.gerritProxy = formData.optString("gerritProxy", "");
        this.gerritUserName = formData.optString("gerritUserName", "");
        this.gerritEMail = formData.optString("gerritEMail", "");
        this.notificationLevel = Notify.valueOf((String)formData.optString("notificationLevel", DEFAULT_NOTIFICATION_LEVEL.toString()));
        String file = formData.optString("gerritAuthKeyFile", null);
        this.gerritAuthKeyFile = file != null ? new File(file) : GerritDefaultValues.DEFAULT_GERRIT_AUTH_KEY_FILE;
        this.gerritAuthKeyFilePassword = Secret.fromString((String)formData.optString("gerritAuthKeyFilePassword", GerritDefaultValues.DEFAULT_GERRIT_AUTH_KEY_FILE_PASSWORD));
        if (formData.has("buildCurrentPatchesOnly")) {
            JSONObject currentPatchesOnly = formData.getJSONObject("buildCurrentPatchesOnly");
            this.buildCurrentPatchesOnly = BuildCancellationPolicy.createPolicyFromJSON(currentPatchesOnly);
        } else {
            this.buildCurrentPatchesOnly = new BuildCancellationPolicy();
        }
        this.voteSameTopic = formData.optBoolean("voteSameTopic", false);
        this.numberOfWorkerThreads = formData.optInt("numberOfReceivingWorkerThreads", 3);
        if (this.numberOfWorkerThreads <= 0) {
            this.numberOfWorkerThreads = 3;
        }
        this.numberOfSendingWorkerThreads = formData.optInt("numberOfSendingWorkerThreads", 1);
        if (this.numberOfSendingWorkerThreads <= 0) {
            this.numberOfSendingWorkerThreads = 1;
        }
        this.setVoteValues(formData);
        this.gerritVerifiedCmdBuildStarted = formData.optString("gerritVerifiedCmdBuildStarted", "gerrit review <CHANGE>,<PATCHSET> --message 'Build Started <BUILDURL> <STARTED_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW> --tag autogenerated:jenkins-gerrit-trigger");
        this.gerritVerifiedCmdBuildFailed = formData.optString("gerritVerifiedCmdBuildFailed", "gerrit review <CHANGE>,<PATCHSET> --message 'Build Failed <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW> --tag autogenerated:jenkins-gerrit-trigger");
        this.gerritVerifiedCmdBuildSuccessful = formData.optString("gerritVerifiedCmdBuildSuccessful", "gerrit review <CHANGE>,<PATCHSET> --message 'Build Successful <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW> --tag autogenerated:jenkins-gerrit-trigger");
        this.gerritVerifiedCmdBuildUnstable = formData.optString("gerritVerifiedCmdBuildUnstable", "gerrit review <CHANGE>,<PATCHSET> --message 'Build Unstable <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW> --tag autogenerated:jenkins-gerrit-trigger");
        this.gerritVerifiedCmdBuildNotBuilt = formData.optString("gerritVerifiedCmdBuildNotBuilt", "gerrit review <CHANGE>,<PATCHSET> --message 'No Builds Executed <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW> --tag autogenerated:jenkins-gerrit-trigger");
        this.gerritVerifiedCmdBuildAborted = formData.optString("gerritVerifiedCmdBuildAborted", "gerrit review <CHANGE>,<PATCHSET> --message 'Build Aborted <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW> --tag autogenerated:jenkins-gerrit-trigger");
        this.gerritFrontEndUrl = formData.optString("gerritFrontEndUrl", "");
        this.enableManualTrigger = formData.optBoolean("enableManualTrigger", true);
        this.enablePluginMessages = formData.optBoolean("enablePluginMessages", true);
        this.triggerOnAllComments = formData.optBoolean("triggerOnAllComments", false);
        this.buildScheduleDelay = formData.optInt("buildScheduleDelay", 3);
        if (this.buildScheduleDelay < 0) {
            this.buildScheduleDelay = 0;
        }
        this.dynamicConfigRefreshInterval = formData.optInt("dynamicConfigRefreshInterval", 30);
        this.projectListFetchDelay = formData.optInt("projectListFetchDelay", 0);
        this.projectListRefreshInterval = formData.optInt("projectListRefreshInterval", 3600);
        this.enableProjectAutoCompletion = formData.optBoolean("enableProjectAutoCompletion", true);
        this.categories = new LinkedList<VerdictCategory>();
        if (formData.has("verdictCategories")) {
            Object cat = formData.get("verdictCategories");
            if (cat instanceof JSONArray) {
                for (Object jsonObject : (JSONArray)cat) {
                    this.categories.add(VerdictCategory.createVerdictCategoryFromJSON((JSONObject)jsonObject));
                }
            } else if (cat instanceof JSONObject) {
                this.categories.add(VerdictCategory.createVerdictCategoryFromJSON((JSONObject)cat));
            }
        }
        this.watchdogTimeoutMinutes = formData.optInt("watchdogTimeoutMinutes", 0);
        this.watchTimeExceptionData = this.addWatchTimeExceptionData(formData);
        if (formData.has("useRestApi")) {
            this.useRestApi = true;
            JSONObject restApi = formData.getJSONObject("useRestApi");
            this.gerritHttpUserName = restApi.optString("gerritHttpUserName", "");
            this.gerritHttpPassword = Secret.fromString((String)restApi.optString("gerritHttpPassword", ""));
            this.restCodeReview = restApi.optBoolean("restCodeReview", true);
            this.restVerified = restApi.optBoolean("restVerified", true);
        } else {
            this.useRestApi = false;
        }
        this.replicationConfig = ReplicationConfig.createReplicationConfigFromJSON(formData);
    }

    private void setVoteValues(JSONObject formData) {
        if (formData.isEmpty()) {
            this.gerritBuildStartedVerifiedValue = 0;
            this.gerritBuildSuccessfulVerifiedValue = 1;
            this.gerritBuildFailedVerifiedValue = -1;
            this.gerritBuildUnstableVerifiedValue = 0;
            this.gerritBuildNotBuiltVerifiedValue = 0;
            this.gerritBuildAbortedVerifiedValue = 0;
            this.gerritBuildStartedCodeReviewValue = 0;
            this.gerritBuildSuccessfulCodeReviewValue = 0;
            this.gerritBuildFailedCodeReviewValue = 0;
            this.gerritBuildUnstableCodeReviewValue = -1;
            this.gerritBuildNotBuiltCodeReviewValue = 0;
            this.gerritBuildAbortedCodeReviewValue = 0;
        } else {
            this.gerritBuildStartedVerifiedValue = this.getValueFromFormData(formData, "gerritBuildStartedVerifiedValue");
            this.gerritBuildSuccessfulVerifiedValue = this.getValueFromFormData(formData, "gerritBuildSuccessfulVerifiedValue");
            this.gerritBuildFailedVerifiedValue = this.getValueFromFormData(formData, "gerritBuildFailedVerifiedValue");
            this.gerritBuildUnstableVerifiedValue = this.getValueFromFormData(formData, "gerritBuildUnstableVerifiedValue");
            this.gerritBuildNotBuiltVerifiedValue = this.getValueFromFormData(formData, "gerritBuildNotBuiltVerifiedValue");
            this.gerritBuildAbortedVerifiedValue = this.getValueFromFormData(formData, "gerritBuildAbortedVerifiedValue");
            this.gerritBuildStartedCodeReviewValue = this.getValueFromFormData(formData, "gerritBuildStartedCodeReviewValue");
            this.gerritBuildSuccessfulCodeReviewValue = this.getValueFromFormData(formData, "gerritBuildSuccessfulCodeReviewValue");
            this.gerritBuildFailedCodeReviewValue = this.getValueFromFormData(formData, "gerritBuildFailedCodeReviewValue");
            this.gerritBuildUnstableCodeReviewValue = this.getValueFromFormData(formData, "gerritBuildUnstableCodeReviewValue");
            this.gerritBuildNotBuiltCodeReviewValue = this.getValueFromFormData(formData, "gerritBuildNotBuiltCodeReviewValue");
            this.gerritBuildAbortedCodeReviewValue = this.getValueFromFormData(formData, "gerritBuildAbortedCodeReviewValue");
        }
    }

    private Integer getValueFromFormData(JSONObject formData, String key) {
        if (formData.has(key)) {
            String testData = formData.optString(key);
            if (testData == null || testData.equals("")) {
                return null;
            }
            try {
                return Integer.parseInt(testData);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    private WatchTimeExceptionData addWatchTimeExceptionData(JSONObject formData) {
        LinkedList<Integer> days = new LinkedList<Integer>();
        LinkedList<WatchTimeExceptionData.TimeSpan> exceptionTimes = new LinkedList<WatchTimeExceptionData.TimeSpan>();
        int[] daysAsInt = new int[]{};
        if (formData.has("watchdogExceptions")) {
            JSONObject jsonObject = formData.getJSONObject("watchdogExceptions");
            if (jsonObject.getBoolean(String.valueOf(2))) {
                days.add(2);
            }
            if (jsonObject.getBoolean(String.valueOf(3))) {
                days.add(3);
            }
            if (jsonObject.getBoolean(String.valueOf(4))) {
                days.add(4);
            }
            if (jsonObject.getBoolean(String.valueOf(5))) {
                days.add(5);
            }
            if (jsonObject.getBoolean(String.valueOf(6))) {
                days.add(6);
            }
            if (jsonObject.getBoolean(String.valueOf(7))) {
                days.add(7);
            }
            if (jsonObject.getBoolean(String.valueOf(1))) {
                days.add(1);
            }
            daysAsInt = days.stream().mapToInt(Integer::intValue).toArray();
            if (jsonObject.has("watchdogExceptionTimes")) {
                Object obj = jsonObject.get("watchdogExceptionTimes");
                if (obj instanceof JSONArray) {
                    for (Object json : (JSONArray)obj) {
                        exceptionTimes.add(WatchTimeExceptionData.TimeSpan.createTimeSpanFromJSONObject((JSONObject)((JSONObject)json)));
                    }
                } else if (obj instanceof JSONObject) {
                    exceptionTimes.add(WatchTimeExceptionData.TimeSpan.createTimeSpanFromJSONObject((JSONObject)((JSONObject)obj)));
                }
            }
        }
        return new WatchTimeExceptionData(daysAsInt, exceptionTimes);
    }

    private WatchTimeExceptionData addWatchTimeExceptionData(WatchTimeExceptionData data) {
        if (data != null) {
            int[] daysAsInt = data.getDaysOfWeek();
            LinkedList<WatchTimeExceptionData.TimeSpan> exceptionTimes = new LinkedList<WatchTimeExceptionData.TimeSpan>();
            for (WatchTimeExceptionData.TimeSpan s : data.getTimesOfDay()) {
                WatchTimeExceptionData.Time newFromTime = new WatchTimeExceptionData.Time(s.getFrom().getHour(), s.getFrom().getMinute());
                WatchTimeExceptionData.Time newToTime = new WatchTimeExceptionData.Time(s.getTo().getHour(), s.getTo().getMinute());
                exceptionTimes.add(new WatchTimeExceptionData.TimeSpan(newFromTime, newToTime));
            }
            return new WatchTimeExceptionData(daysAsInt, exceptionTimes);
        }
        return null;
    }

    @DataBoundConstructor
    public Config() {
        this(new JSONObject(false));
    }

    public Config(JSONObject formData, StaplerRequest req) {
        this(formData);
    }

    public File getGerritAuthKeyFile() {
        return this.gerritAuthKeyFile;
    }

    public void setGerritAuthKeyFile(File gerritAuthKeyFile) {
        this.gerritAuthKeyFile = gerritAuthKeyFile;
    }

    public String getGerritAuthKeyFilePassword() {
        return Secret.toString((Secret)this.gerritAuthKeyFilePassword);
    }

    public void setGerritAuthKeyFilePassword(String gerritAuthKeyFilePassword) {
        this.gerritAuthKeyFilePassword = Secret.fromString((String)gerritAuthKeyFilePassword);
    }

    @Override
    public Secret getGerritAuthKeyFileSecretPassword() {
        return this.gerritAuthKeyFilePassword;
    }

    @Override
    public String getGerritFrontEndUrl() {
        String url = this.gerritFrontEndUrl;
        if (url != null && !url.isEmpty() && !url.endsWith("/")) {
            url = url + '/';
        }
        return url;
    }

    public void setGerritFrontEndURL(String gerritFrontEndURL) {
        this.gerritFrontEndUrl = gerritFrontEndURL;
    }

    public void setGerritFrontEndUrl(String gerritFrontEndURL) {
        this.setGerritFrontEndURL(gerritFrontEndURL);
    }

    public String getGerritHostName() {
        return this.gerritHostName;
    }

    public void setGerritHostName(String gerritHostName) {
        this.gerritHostName = gerritHostName;
    }

    public int getGerritSshPort() {
        return this.gerritSshPort;
    }

    public void setGerritSshPort(int gerritSshPort) {
        this.gerritSshPort = gerritSshPort;
    }

    public String getGerritProxy() {
        return this.gerritProxy;
    }

    public void setGerritProxy(String gerritProxy) {
        this.gerritProxy = gerritProxy;
    }

    @Override
    public int getBuildScheduleDelay() {
        return this.buildScheduleDelay;
    }

    public void setBuildScheduleDelay(int buildScheduleDelay) {
        this.buildScheduleDelay = buildScheduleDelay;
    }

    @Override
    public int getDynamicConfigRefreshInterval() {
        if (this.dynamicConfigRefreshInterval == 0) {
            this.dynamicConfigRefreshInterval = 30;
        } else if (this.dynamicConfigRefreshInterval < 5) {
            this.dynamicConfigRefreshInterval = 5;
        }
        return this.dynamicConfigRefreshInterval;
    }

    @Override
    public int getProjectListFetchDelay() {
        return this.projectListFetchDelay;
    }

    public void setProjectListFetchDelay(int projectListFetchDelay) {
        this.projectListFetchDelay = projectListFetchDelay;
    }

    @Override
    public int getProjectListRefreshInterval() {
        if (this.projectListRefreshInterval == 0) {
            this.projectListRefreshInterval = 3600;
        }
        return this.projectListRefreshInterval;
    }

    public void setProjectListRefreshInterval(int projectListRefreshInterval) {
        this.projectListRefreshInterval = projectListRefreshInterval;
    }

    @Override
    public boolean isEnableProjectAutoCompletion() {
        return this.enableProjectAutoCompletion;
    }

    public void setEnableProjectAutoCompletion(boolean enableProjectAutoCompletion) {
        this.enableProjectAutoCompletion = enableProjectAutoCompletion;
    }

    public void setDynamicConfigRefreshInterval(int dynamicConfigRefreshInterval) {
        this.dynamicConfigRefreshInterval = dynamicConfigRefreshInterval;
    }

    public String getGerritUserName() {
        return this.gerritUserName;
    }

    public void setGerritUserName(String gerritUserName) {
        this.gerritUserName = gerritUserName;
    }

    public String getGerritEMail() {
        return this.gerritEMail;
    }

    @Override
    public Notify getNotificationLevel() {
        return this.notificationLevel;
    }

    public void setGerritEMail(String gerritEMail) {
        this.gerritEMail = gerritEMail;
    }

    public void setNotificationLevel(Notify notificationLevel) {
        this.notificationLevel = notificationLevel;
    }

    @Override
    @Deprecated
    public int getNumberOfReceivingWorkerThreads() {
        if (this.numberOfWorkerThreads <= 0) {
            this.numberOfWorkerThreads = 3;
        }
        return this.numberOfWorkerThreads;
    }

    @Override
    @Deprecated
    public int getNumberOfSendingWorkerThreads() {
        if (this.numberOfSendingWorkerThreads <= 0) {
            this.numberOfSendingWorkerThreads = 1;
        }
        return this.numberOfSendingWorkerThreads;
    }

    @Deprecated
    public void setNumberOfReceivingWorkerThreads(int numberOfReceivingWorkerThreads) {
        this.numberOfWorkerThreads = numberOfReceivingWorkerThreads;
    }

    @Override
    @Deprecated
    public void setNumberOfSendingWorkerThreads(int numberOfSendingWorkerThreads) {
        this.numberOfSendingWorkerThreads = numberOfSendingWorkerThreads;
    }

    @Override
    public boolean isGerritBuildCurrentPatchesOnly() {
        return this.getBuildCurrentPatchesOnly().isEnabled();
    }

    @Override
    public BuildCancellationPolicy getBuildCurrentPatchesOnly() {
        if (this.buildCurrentPatchesOnly == null) {
            this.buildCurrentPatchesOnly = new BuildCancellationPolicy();
            this.buildCurrentPatchesOnly.setEnabled(false);
        }
        return this.buildCurrentPatchesOnly;
    }

    public void setBuildCurrentPatchesOnly(BuildCancellationPolicy buildCurrentPatchesOnly) {
        this.buildCurrentPatchesOnly = buildCurrentPatchesOnly;
    }

    @Override
    public boolean isVoteSameTopic() {
        return this.voteSameTopic;
    }

    public void setVoteSameTopic(boolean voteSameTopic) {
        this.voteSameTopic = voteSameTopic;
    }

    public String getVoteSameTopicDescription() {
        return "<b>Warning:</b> The current implementation takes into account that 'Build Current Patches Only' with 'Abort new patch sets' and 'Abort patch sets with same topic' are <b>enabled</b> (see help for more).";
    }

    @Override
    public String getGerritCmdBuildSuccessful() {
        return this.gerritVerifiedCmdBuildSuccessful;
    }

    @Deprecated
    public void setGerritVerifiedCmdBuildSuccessful(String cmd) {
        this.setGerritCmdBuildSuccessful(cmd);
    }

    public void setGerritCmdBuildSuccessful(String cmd) {
        this.gerritVerifiedCmdBuildSuccessful = cmd;
    }

    @Override
    public String getGerritCmdBuildUnstable() {
        return this.gerritVerifiedCmdBuildUnstable;
    }

    @Deprecated
    public void setGerritVerifiedCmdBuildUnstable(String cmd) {
        this.setGerritCmdBuildUnstable(cmd);
    }

    public void setGerritCmdBuildUnstable(String cmd) {
        this.gerritVerifiedCmdBuildUnstable = cmd;
    }

    @Override
    public String getGerritCmdBuildFailed() {
        return this.gerritVerifiedCmdBuildFailed;
    }

    @Deprecated
    public void setGerritVerifiedCmdBuildFailed(String cmd) {
        this.setGerritCmdBuildFailed(cmd);
    }

    public void setGerritCmdBuildFailed(String cmd) {
        this.gerritVerifiedCmdBuildFailed = cmd;
    }

    @Override
    public String getGerritCmdBuildStarted() {
        return this.gerritVerifiedCmdBuildStarted;
    }

    @Deprecated
    public void setGerritVerifiedCmdBuildStarted(String cmd) {
        this.setGerritCmdBuildStarted(cmd);
    }

    public void setGerritCmdBuildStarted(String cmd) {
        this.gerritVerifiedCmdBuildStarted = cmd;
    }

    @Override
    public String getGerritCmdBuildNotBuilt() {
        return this.gerritVerifiedCmdBuildNotBuilt;
    }

    @Deprecated
    public void setGerritVerifiedCmdBuildNotBuilt(String cmd) {
        this.setGerritCmdBuildNotBuilt(cmd);
    }

    public void setGerritCmdBuildNotBuilt(String cmd) {
        this.gerritVerifiedCmdBuildNotBuilt = cmd;
    }

    @Override
    public String getGerritCmdBuildAborted() {
        return this.gerritVerifiedCmdBuildAborted;
    }

    @Deprecated
    public void setGerritVerifiedCmdBuildAborted(String cmd) {
        this.setGerritCmdBuildAborted(cmd);
    }

    public void setGerritCmdBuildAborted(String cmd) {
        this.gerritVerifiedCmdBuildAborted = cmd;
    }

    @Override
    public Integer getGerritBuildStartedVerifiedValue() {
        return this.gerritBuildStartedVerifiedValue;
    }

    @Override
    public Integer getGerritBuildStartedCodeReviewValue() {
        return this.gerritBuildStartedCodeReviewValue;
    }

    @Override
    public Integer getGerritBuildSuccessfulVerifiedValue() {
        return this.gerritBuildSuccessfulVerifiedValue;
    }

    @Override
    public Integer getGerritBuildSuccessfulCodeReviewValue() {
        return this.gerritBuildSuccessfulCodeReviewValue;
    }

    @Override
    public Integer getGerritBuildFailedVerifiedValue() {
        return this.gerritBuildFailedVerifiedValue;
    }

    @Override
    public Integer getGerritBuildFailedCodeReviewValue() {
        return this.gerritBuildFailedCodeReviewValue;
    }

    @Override
    public Integer getGerritBuildUnstableVerifiedValue() {
        return this.gerritBuildUnstableVerifiedValue;
    }

    @Override
    public Integer getGerritBuildUnstableCodeReviewValue() {
        return this.gerritBuildUnstableCodeReviewValue;
    }

    @Override
    public Integer getGerritBuildNotBuiltVerifiedValue() {
        return this.gerritBuildNotBuiltVerifiedValue;
    }

    @Override
    public Integer getGerritBuildNotBuiltCodeReviewValue() {
        return this.gerritBuildNotBuiltCodeReviewValue;
    }

    @Override
    public Integer getGerritBuildAbortedVerifiedValue() {
        return this.gerritBuildAbortedVerifiedValue;
    }

    @Override
    public Integer getGerritBuildAbortedCodeReviewValue() {
        return this.gerritBuildAbortedCodeReviewValue;
    }

    public void setGerritBuildStartedVerifiedValue(Integer gerritBuildStartedVerifiedValue) {
        this.gerritBuildStartedVerifiedValue = gerritBuildStartedVerifiedValue;
    }

    public void setGerritBuildSuccessfulVerifiedValue(Integer gerritBuildSuccessfulVerifiedValue) {
        this.gerritBuildSuccessfulVerifiedValue = gerritBuildSuccessfulVerifiedValue;
    }

    public void setGerritBuildFailedVerifiedValue(Integer gerritBuildFailedVerifiedValue) {
        this.gerritBuildFailedVerifiedValue = gerritBuildFailedVerifiedValue;
    }

    public void setGerritBuildUnstableVerifiedValue(Integer gerritBuildUnstableVerifiedValue) {
        this.gerritBuildUnstableVerifiedValue = gerritBuildUnstableVerifiedValue;
    }

    public void setGerritBuildNotBuiltVerifiedValue(Integer gerritBuildNotBuiltVerifiedValue) {
        this.gerritBuildNotBuiltVerifiedValue = gerritBuildNotBuiltVerifiedValue;
    }

    public void setGerritBuildAbortedVerifiedValue(Integer gerritBuildAbortedVerifiedValue) {
        this.gerritBuildAbortedVerifiedValue = gerritBuildAbortedVerifiedValue;
    }

    public void setGerritBuildStartedCodeReviewValue(Integer gerritBuildStartedCodeReviewValue) {
        this.gerritBuildStartedCodeReviewValue = gerritBuildStartedCodeReviewValue;
    }

    public void setGerritBuildSuccessfulCodeReviewValue(Integer gerritBuildSuccessfulCodeReviewValue) {
        this.gerritBuildSuccessfulCodeReviewValue = gerritBuildSuccessfulCodeReviewValue;
    }

    public void setGerritBuildFailedCodeReviewValue(Integer gerritBuildFailedCodeReviewValue) {
        this.gerritBuildFailedCodeReviewValue = gerritBuildFailedCodeReviewValue;
    }

    public void setGerritBuildUnstableCodeReviewValue(Integer gerritBuildUnstableCodeReviewValue) {
        this.gerritBuildUnstableCodeReviewValue = gerritBuildUnstableCodeReviewValue;
    }

    public void setGerritBuildNotBuiltCodeReviewValue(Integer gerritBuildNotBuiltCodeReviewValue) {
        this.gerritBuildNotBuiltCodeReviewValue = gerritBuildNotBuiltCodeReviewValue;
    }

    public void setGerritBuildAbortedCodeReviewValue(Integer gerritBuildAbortedCodeReviewValue) {
        this.gerritBuildAbortedCodeReviewValue = gerritBuildAbortedCodeReviewValue;
    }

    @Override
    public String getGerritFrontEndUrlFor(String changeSetNumber, String revision) {
        StringBuilder str = new StringBuilder(this.getGerritFrontEndUrl());
        str.append(changeSetNumber);
        return str.toString();
    }

    @Override
    public String getGerritFrontEndUrlFor(GerritTriggeredEvent event) {
        String providerUrl;
        String changeUrl;
        if (event instanceof ChangeBasedEvent && (changeUrl = ((ChangeBasedEvent)event).getChange().getUrl()) != null && !changeUrl.isEmpty()) {
            return changeUrl;
        }
        String url = this.getGerritFrontEndUrl();
        Provider provider = event.getProvider();
        if (provider != null && (providerUrl = provider.getUrl()) != null && !providerUrl.isEmpty()) {
            url = providerUrl;
        }
        StringBuilder str = new StringBuilder(url);
        if (event instanceof ChangeBasedEvent) {
            str.append(((ChangeBasedEvent)event).getChange().getNumber());
        }
        return str.toString();
    }

    @Override
    public List<VerdictCategory> getCategories() {
        return this.categories;
    }

    @Override
    public void setCategories(List<VerdictCategory> categories) {
        this.categories = categories;
    }

    @Override
    public boolean isEnableManualTrigger() {
        return this.enableManualTrigger;
    }

    public void setEnableManualTrigger(boolean enableManualTrigger) {
        this.enableManualTrigger = enableManualTrigger;
    }

    public Authentication getGerritAuthentication() {
        return new Authentication(this.gerritAuthKeyFile, this.gerritUserName, this.getGerritAuthKeyFilePassword());
    }

    @Override
    public boolean hasDefaultValues() {
        return !(this.gerritHostName != null && !"".equals(this.gerritHostName) || this.gerritFrontEndUrl != null && !"".equals(this.gerritFrontEndUrl));
    }

    @Override
    public boolean isEnablePluginMessages() {
        return this.enablePluginMessages;
    }

    @Override
    public boolean isTriggerOnAllComments() {
        return this.triggerOnAllComments;
    }

    public void setTriggerOnAllComments(boolean triggerOnAllComments) {
        this.triggerOnAllComments = triggerOnAllComments;
    }

    @Override
    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig) {
        this.replicationConfig = replicationConfig;
    }

    public int getWatchdogTimeoutSeconds() {
        return (int)TimeUnit.MINUTES.toSeconds(this.watchdogTimeoutMinutes);
    }

    public int getWatchdogTimeoutMinutes() {
        return this.watchdogTimeoutMinutes;
    }

    public void setWatchdogTimeoutMinutes(int watchdogTimeoutMinutes) {
        this.watchdogTimeoutMinutes = watchdogTimeoutMinutes;
    }

    public WatchTimeExceptionData getExceptionData() {
        return this.watchTimeExceptionData;
    }

    public void setExceptionData(WatchTimeExceptionData exceptionData) {
        this.watchTimeExceptionData = exceptionData;
    }

    @Override
    public boolean isUseRestApi() {
        return this.useRestApi;
    }

    public void setUseRestApi(boolean useRestApi) {
        this.useRestApi = useRestApi;
    }

    @Override
    public Secret getGerritHttpSecretPassword() {
        return this.gerritHttpPassword;
    }

    @Override
    public String getGerritHttpPassword() {
        return Secret.toString((Secret)this.gerritHttpPassword);
    }

    public void setGerritHttpPassword(String gerritHttpPassword) {
        this.gerritHttpPassword = Secret.fromString((String)gerritHttpPassword);
    }

    @Override
    public String getGerritHttpUserName() {
        return this.gerritHttpUserName;
    }

    public void setGerritHttpUserName(String gerritHttpUserName) {
        this.gerritHttpUserName = gerritHttpUserName;
    }

    public Credentials getHttpCredentials() {
        return new UsernamePasswordCredentials(this.gerritHttpUserName, this.getGerritHttpPassword());
    }

    @Override
    public boolean isRestCodeReview() {
        return this.restCodeReview;
    }

    public void setRestCodeReview(boolean restCodeReview) {
        this.restCodeReview = restCodeReview;
    }

    @Override
    public boolean isRestVerified() {
        return this.restVerified;
    }

    public void setRestVerified(boolean restVerified) {
        this.restVerified = restVerified;
    }

    Object readResolve() {
        if (this.buildCurrentPatchesOnly == null) {
            this.buildCurrentPatchesOnly = new BuildCancellationPolicy();
            this.buildCurrentPatchesOnly.setEnabled(this.gerritBuildCurrentPatchesOnly);
            this.buildCurrentPatchesOnly.setAbortManualPatchsets(false);
            this.buildCurrentPatchesOnly.setAbortNewPatchsets(false);
        }
        if (this.gerritVerifiedCmdBuildAborted == null) {
            this.gerritVerifiedCmdBuildAborted = this.gerritVerifiedCmdBuildFailed;
            if (this.gerritBuildAbortedCodeReviewValue == null) {
                this.gerritBuildAbortedCodeReviewValue = this.gerritBuildFailedCodeReviewValue;
            }
            if (this.gerritBuildAbortedVerifiedValue == null) {
                this.gerritBuildAbortedVerifiedValue = this.gerritBuildFailedVerifiedValue;
            }
        }
        return this;
    }
}

