/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefUpdated;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.kohsuke.stapler.DataBoundConstructor;

public class GerritTriggerBuildChooser
extends BuildChooser {
    private static final long serialVersionUID = 2003462680723330645L;
    private final String separator = "#";
    private static final Logger LOGGER = Logger.getLogger(GerritTriggerBuildChooser.class.getName());

    @DataBoundConstructor
    public GerritTriggerBuildChooser() {
    }

    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, GitClient git, TaskListener listener, BuildData data, BuildChooserContext context) throws GitException, IOException, InterruptedException {
        try {
            String refspec;
            String rev = (String)context.actOnBuild((BuildChooserContext.ContextCallable)new GetGerritEventRevision());
            if (rev == null) {
                rev = "FETCH_HEAD";
            }
            if ((refspec = (String)context.actOnBuild((BuildChooserContext.ContextCallable)new GetGerritEventRefspec())) == null) {
                refspec = singleBranch;
            }
            ObjectId sha1 = git.revParse(rev);
            Revision revision = new Revision(sha1);
            revision.getBranches().add(new Branch(refspec, sha1));
            return Collections.singletonList(revision);
        }
        catch (GitException e) {
            return Collections.emptyList();
        }
    }

    public Build prevBuildForChangelog(String singleBranch, BuildData data, GitClient git, BuildChooserContext context) throws InterruptedException, IOException {
        if (data != null) {
            ObjectId sha1 = git.revParse("FETCH_HEAD");
            ObjectId parentSha1 = this.getFirstParent(sha1, git);
            Revision parentRev = new Revision(parentSha1);
            parentRev.getBranches().add(new Branch(singleBranch, parentSha1));
            int prevBuildNum = 0;
            Result r = null;
            Build lastBuild = data.getLastBuildOfBranch(singleBranch);
            if (lastBuild != null) {
                prevBuildNum = lastBuild.getBuildNumber();
                r = lastBuild.getBuildResult();
            }
            return new Build(parentRev, prevBuildNum, r);
        }
        return null;
    }

    private ObjectId getFirstParent(final ObjectId id, GitClient git) throws GitException, IOException, InterruptedException {
        return (ObjectId)git.withRepository((RepositoryCallback)new RepositoryCallback<ObjectId>(){

            public ObjectId invoke(Repository repository, VirtualChannel virtualChannel) throws IOException, InterruptedException {
                Object result = null;
                try (RevWalk walk = new RevWalk(repository);){
                    RevCommit commit = walk.parseCommit((AnyObjectId)id);
                    result = commit.getParentCount() > 0 ? commit.getParent(0) : id;
                }
                catch (Exception e) {
                    throw new GitException("Failed to find parent id. ", (Throwable)e);
                }
                return result;
            }
        });
    }

    private static class GetGerritEventRefspec
    implements BuildChooserContext.ContextCallable<Run<?, ?>, String> {
        static final long serialVersionUID = 0L;

        private GetGerritEventRefspec() {
        }

        public String invoke(Run<?, ?> build, VirtualChannel channel) {
            GerritCause cause = (GerritCause)build.getCause(GerritCause.class);
            if (cause != null) {
                GerritTriggeredEvent event = cause.getEvent();
                if (event instanceof ChangeBasedEvent) {
                    return ((ChangeBasedEvent)event).getPatchSet().getRef();
                }
                if (event instanceof RefUpdated) {
                    return ((RefUpdated)event).getRefUpdate().getRefName();
                }
            }
            return null;
        }
    }

    private static class GetGerritEventRevision
    implements BuildChooserContext.ContextCallable<Run<?, ?>, String> {
        static final long serialVersionUID = 0L;

        private GetGerritEventRevision() {
        }

        public String invoke(Run<?, ?> build, VirtualChannel channel) {
            GerritCause cause = (GerritCause)build.getCause(GerritCause.class);
            if (cause != null) {
                GerritTriggeredEvent event = cause.getEvent();
                if (event instanceof ChangeBasedEvent) {
                    return ((ChangeBasedEvent)event).getPatchSet().getRevision();
                }
                if (event instanceof RefUpdated) {
                    return ((RefUpdated)event).getRefUpdate().getNewRev();
                }
            }
            return null;
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public String getLegacyId() {
            return Messages.DisplayName();
        }
    }
}

