/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.job.rest;

import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ParameterExpander;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Notify;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ReviewInput;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ReviewLabel;
import com.sonymobile.tools.gerrit.gerritevents.rest.RestConnectionConfig;
import com.sonymobile.tools.gerrit.gerritevents.workers.rest.AbstractRestCommandJob;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;

public class BuildStartedRestCommandJob
extends AbstractRestCommandJob {
    private static final String LABEL_CODEREVIEW = "Code-Review";
    private static final String LABEL_VERIFIED = "Verified";
    private final Run build;
    private final BuildsStartedStats stats;
    private final TaskListener listener;
    private final ParameterExpander parameterExpander;
    private final IGerritHudsonTriggerConfig config;

    public BuildStartedRestCommandJob(IGerritHudsonTriggerConfig config, Run build, TaskListener listener, ChangeBasedEvent event, BuildsStartedStats stats) {
        super((RestConnectionConfig)config, listener != null ? listener.getLogger() : null, event);
        this.build = build;
        this.stats = stats;
        this.listener = listener;
        this.parameterExpander = new ParameterExpander(config);
        this.config = config;
    }

    protected ReviewInput createReview() {
        String message = this.parameterExpander.getBuildStartedMessage(this.build, this.listener, this.event, this.stats);
        ArrayList<ReviewLabel> scoredLabels = new ArrayList<ReviewLabel>();
        if (this.event.isScorable()) {
            Integer verValue;
            Integer crValue;
            if (this.config.isRestCodeReview() && (crValue = this.parameterExpander.getBuildStartedCodeReviewValue(this.build)) != null && crValue != Integer.MAX_VALUE) {
                scoredLabels.add(new ReviewLabel(LABEL_CODEREVIEW, crValue.intValue()));
            }
            if (this.config.isRestVerified() && (verValue = this.parameterExpander.getBuildStartedVerifiedValue(this.build)) != null && verValue != Integer.MAX_VALUE) {
                scoredLabels.add(new ReviewLabel(LABEL_VERIFIED, verValue.intValue()));
            }
        }
        Notify notificationLevel = Notify.ALL;
        GerritTrigger trigger = GerritTrigger.getTrigger(this.build.getParent());
        if (trigger != null) {
            notificationLevel = this.parameterExpander.getNotificationLevel(trigger);
        }
        return new ReviewInput(message, scoredLabels).setNotify(notificationLevel).setTag("autogenerated:jenkins-gerrit-trigger");
    }
}

