/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.config;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.Config;
import com.sonymobile.tools.gerrit.gerritevents.watchdog.WatchTimeExceptionData;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.impl.attributes.MultivaluedAttribute;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension(optional=true)
public class GerritJcascConfigurator
extends BaseConfigurator<PluginImpl> {
    protected PluginImpl instance(Mapping mapping, ConfigurationContext configurationContext) {
        return PluginImpl.getInstance();
    }

    @NonNull
    public String getName() {
        return "gerrit-trigger";
    }

    public String getDisplayName() {
        return "Gerrit Trigger";
    }

    public Class<PluginImpl> getTarget() {
        return PluginImpl.class;
    }

    protected void configure(Mapping config, PluginImpl instance, boolean dryrun, ConfigurationContext context) throws ConfiguratorException {
        if (!dryrun) {
            for (GerritServer oldServer : instance.getServers()) {
                oldServer.stopConnection();
                oldServer.stop();
            }
            instance.getServers().clear();
        }
        try {
            super.configure(config, (Object)instance, dryrun, context);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfiguratorException((Configurator)this, "Failed configuring gerrit trigger", (Throwable)ex);
        }
        if (!dryrun) {
            instance.getPluginConfig().updateEventFilter();
            for (GerritServer server : instance.getServers()) {
                server.getConfig().setNumberOfSendingWorkerThreads(instance.getPluginConfig().getNumberOfSendingWorkerThreads());
                server.start();
            }
        }
    }

    @Extension(optional=true)
    public static final class TimeSpanConfigurator
    implements Configurator<WatchTimeExceptionData.TimeSpan> {
        public Class<WatchTimeExceptionData.TimeSpan> getTarget() {
            return WatchTimeExceptionData.TimeSpan.class;
        }

        public Set<Attribute<WatchTimeExceptionData.TimeSpan, ?>> describe() {
            HashSet attributes = new HashSet();
            Collections.addAll(attributes, new Attribute("from", String.class).getter(ts -> ts.getFrom().getHourAsString() + ":" + ts.getFrom().getMinuteAsString()), new Attribute("to", String.class).getter(ts -> ts.getTo().getHourAsString() + ":" + ts.getTo().getMinuteAsString()));
            return Collections.unmodifiableSet(attributes);
        }

        public WatchTimeExceptionData.TimeSpan configure(CNode config, ConfigurationContext context) {
            throw new UnsupportedOperationException("Configured by " + WatchTimeExceptionDataConfigurator.class);
        }

        public WatchTimeExceptionData.TimeSpan check(CNode config, ConfigurationContext context) {
            throw new UnsupportedOperationException("Configured by " + WatchTimeExceptionDataConfigurator.class);
        }
    }

    @Extension(optional=true)
    public static final class WatchTimeExceptionDataConfigurator
    implements Configurator<WatchTimeExceptionData> {
        private static final String DAYS_OF_WEEK = "daysOfWeek";
        private static final String TIMES_OF_DAY = "timesOfDay";
        private static final Map<String, Integer> DAY_NAME_TO_ORDINAL = new HashMap<String, Integer>();

        public Class<WatchTimeExceptionData> getTarget() {
            return WatchTimeExceptionData.class;
        }

        public Set<Attribute<WatchTimeExceptionData, ?>> describe() {
            HashSet attributes = new HashSet();
            Collections.addAll(attributes, new MultivaluedAttribute(DAYS_OF_WEEK, String.class).getter(target -> Arrays.stream(target.getDaysOfWeek()).mapToObj(this::ordinalToName).collect(Collectors.toList())), new MultivaluedAttribute(TIMES_OF_DAY, WatchTimeExceptionData.TimeSpan.class).getter(WatchTimeExceptionData::getTimesOfDay));
            return Collections.unmodifiableSet(attributes);
        }

        private int nameToOrdinal(String dayName) {
            Integer ordinal = DAY_NAME_TO_ORDINAL.get(dayName.toLowerCase());
            if (ordinal == null) {
                throw new IllegalArgumentException("Unknown day of week for name: " + dayName);
            }
            return ordinal;
        }

        private String ordinalToName(int dayNumber) {
            for (Map.Entry<String, Integer> es : DAY_NAME_TO_ORDINAL.entrySet()) {
                if (es.getValue() != dayNumber) continue;
                return es.getKey();
            }
            throw new IllegalArgumentException("Unknown day of week for ordinal: " + dayNumber);
        }

        public WatchTimeExceptionData configure(CNode config, ConfigurationContext context) throws ConfiguratorException {
            Mapping mapping = config != null ? config.asMapping() : Mapping.EMPTY;
            try {
                Sequence days = ((CNode)mapping.get((Object)DAYS_OF_WEEK)).asSequence();
                int[] dayNumbers = new int[days.size()];
                for (int i = 0; i < days.size(); ++i) {
                    dayNumbers[i] = this.nameToOrdinal(((CNode)days.get(i)).asScalar().getValue());
                }
                ArrayList<WatchTimeExceptionData.TimeSpan> timeSpans = new ArrayList<WatchTimeExceptionData.TimeSpan>();
                for (CNode timeSpanNode : ((CNode)mapping.get((Object)TIMES_OF_DAY)).asSequence()) {
                    Mapping tsm = timeSpanNode.asMapping();
                    String from = ((CNode)tsm.get((Object)"from")).asScalar().getValue();
                    String to = ((CNode)tsm.get((Object)"to")).asScalar().getValue();
                    WatchTimeExceptionData.TimeSpan timeSpan = new WatchTimeExceptionData.TimeSpan(WatchTimeExceptionData.Time.createTimeFromString((String)from), WatchTimeExceptionData.Time.createTimeFromString((String)to));
                    timeSpans.add(timeSpan);
                }
                return new WatchTimeExceptionData(dayNumbers, timeSpans);
            }
            catch (IllegalArgumentException ex) {
                throw new ConfiguratorException((Configurator)this, "Failed configuring " + this.getTarget() + " from " + mapping, (Throwable)ex);
            }
        }

        public WatchTimeExceptionData check(CNode config, ConfigurationContext context) throws ConfiguratorException {
            return this.configure(config, context);
        }

        static {
            DAY_NAME_TO_ORDINAL.put("monday", 2);
            DAY_NAME_TO_ORDINAL.put("tuesday", 3);
            DAY_NAME_TO_ORDINAL.put("wednesday", 4);
            DAY_NAME_TO_ORDINAL.put("thursday", 5);
            DAY_NAME_TO_ORDINAL.put("friday", 6);
            DAY_NAME_TO_ORDINAL.put("saturday", 7);
            DAY_NAME_TO_ORDINAL.put("sunday", 1);
        }
    }

    @Extension(optional=true)
    public static final class ServerConfigurator
    extends BaseConfigurator<GerritServer> {
        protected GerritServer instance(Mapping mapping, ConfigurationContext context) {
            return new GerritServer();
        }

        public Class<GerritServer> getTarget() {
            return GerritServer.class;
        }

        public Set<Attribute<GerritServer, ?>> describe() {
            Set describe = super.describe();
            describe.add(new Attribute("config", Config.class));
            return describe;
        }
    }
}

