/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.utils;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final String REFSPEC_PREFIX = "refs/changes/";
    public static final String PLUGIN_URL = "/plugin/gerrit-trigger/";
    private static final Pattern QUOTES_PATTERN = Pattern.compile("\"");
    public static final String PLUGIN_IMAGES_URL = "/plugin/gerrit-trigger/images/";
    public static final String PLUGIN_JS_URL = "/plugin/gerrit-trigger/js/";

    private StringUtil() {
    }

    public static String makeRefSpec(ChangeBasedEvent event) {
        if (event.getPatchSet() != null && event.getPatchSet().getRef() != null && event.getPatchSet().getRef().length() > 0) {
            return event.getPatchSet().getRef();
        }
        StringBuilder str = new StringBuilder(REFSPEC_PREFIX);
        String number = event.getChange().getNumber();
        if (number.length() < 2) {
            str.append("0").append(number);
        } else if (number.length() == 2) {
            str.append(number);
        } else {
            str.append(number.substring(number.length() - 2));
        }
        str.append("/").append(number);
        str.append("/").append(event.getPatchSet().getNumber());
        return str.toString();
    }

    public static String getPluginImageUrl(String imageName) {
        return PLUGIN_IMAGES_URL + imageName;
    }

    public static String getPluginJsUrl(String jsName) {
        return PLUGIN_JS_URL + jsName;
    }

    public static String escapeQuotes(String value) {
        if (value == null) {
            return null;
        }
        return QUOTES_PATTERN.matcher(value).replaceAll("\\\\\"");
    }

    public static String getDefaultDisplayNameForSpecificServer(GerritEventListener listener, String serverName) {
        StringBuilder name = new StringBuilder("");
        if (GerritServer.isAnyServer(serverName)) {
            name.append("Any Server: ");
        } else {
            GerritServer server = PluginImpl.getServer_(serverName);
            if (server != null) {
                name.append(server.getDisplayName());
            } else {
                name.append(serverName);
            }
            name.append(": ");
        }
        name.append(listener.getClass().getSimpleName());
        return name.toString();
    }
}

