/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.utils;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.HttpUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritPluginChecker {
    private static final Logger logger = LoggerFactory.getLogger(GerritPluginChecker.class);

    private GerritPluginChecker() {
    }

    private static String buildURL(IGerritHudsonTriggerConfig config) {
        String gerritFrontEndUrl;
        if (config == null) {
            throw new IllegalArgumentException("Gerrit Server Configuration cannot be null");
        }
        if (!config.isUseRestApi()) {
            logger.debug("REST API is not enabled.");
            return null;
        }
        String restUrl = gerritFrontEndUrl = config.getGerritFrontEndUrl();
        if (gerritFrontEndUrl != null && !gerritFrontEndUrl.endsWith("/")) {
            restUrl = gerritFrontEndUrl + "/";
        }
        return restUrl;
    }

    private static boolean decodeStatus(int statusCode, String pluginName, boolean quiet) {
        String message = "";
        switch (statusCode) {
            case 200: {
                message = Messages.PluginInstalled(pluginName);
                break;
            }
            case 404: {
                message = Messages.PluginNotInstalled(pluginName);
                break;
            }
            case 401: {
                message = Messages.PluginHttpConnectionUnauthorized(pluginName, Messages.HttpConnectionUnauthorized());
                break;
            }
            case 403: {
                message = Messages.PluginHttpConnectionForbidden(pluginName, Messages.HttpConnectionUnauthorized());
                break;
            }
            default: {
                message = Messages.PluginHttpConnectionGeneralError(pluginName, Messages.HttpConnectionError(statusCode));
            }
        }
        GerritPluginChecker.logMsg(message, quiet);
        return 200 == statusCode;
    }

    private static void logMsg(String message, boolean quiet) {
        if (quiet) {
            logger.debug(message);
        } else {
            logger.warn(message);
        }
    }

    public static Boolean isPluginEnabled(IGerritHudsonTriggerConfig config, String pluginName) {
        return GerritPluginChecker.isPluginEnabled(config, pluginName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean isPluginEnabled(IGerritHudsonTriggerConfig config, String pluginName, boolean quiet) {
        String restUrl = GerritPluginChecker.buildURL(config);
        if (restUrl == null) {
            GerritPluginChecker.logMsg(Messages.PluginInstalledRESTApiNull(pluginName), quiet);
            return false;
        }
        logger.trace("{}plugins/{}/", (Object)restUrl, (Object)pluginName);
        CloseableHttpResponse execute = null;
        try {
            execute = HttpUtils.performHTTPGet(config, restUrl + "plugins/" + pluginName + "/");
            int statusCode = execute.getStatusLine().getStatusCode();
            logger.debug("status code: {}", (Object)statusCode);
            Boolean bl = GerritPluginChecker.decodeStatus(statusCode, pluginName, quiet);
            return bl;
        }
        catch (Exception e) {
            logger.warn(Messages.PluginHttpConnectionGeneralError(pluginName, e.getMessage()), (Throwable)e);
            Boolean bl = null;
            return bl;
        }
        finally {
            if (execute != null) {
                try {
                    execute.close();
                }
                catch (Exception exp) {
                    logger.trace("Error happened when close http client.", (Throwable)exp);
                }
            }
        }
    }
}

