/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.impls;

import com.sonyericsson.hudson.plugins.gerrit.trigger.api.GerritTriggerApi;
import com.sonymobile.tools.gerrit.gerritevents.Handler;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import hudson.Extension;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jenkinsci.plugins.rabbitmqconsumer.extensions.MessageQueueListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(optional=true)
public class RabbitMQMessageListenerImpl
extends MessageQueueListener {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQMessageListenerImpl.class);
    private static final String PLUGIN_NAME = "Gerrit Trigger";
    private static final String PLUGIN_APPID = "gerrit";
    private static final String JSON_CONTENTTYPE = "application/json";
    private static final String GERRIT_NAME = "gerrit-name";
    private static final String GERRIT_HOST = "gerrit-host";
    private static final String GERRIT_SCHEME = "gerrit-scheme";
    private static final String GERRIT_PORT = "gerrit-port";
    private static final String GERRIT_FRONT_URL = "gerrit-front-url";
    private static final String GERRIT_VERSION = "gerrit-version";
    private GerritTriggerApi api = null;
    private Set<String> queueNames = new CopyOnWriteArraySet<String>();

    public String getName() {
        return PLUGIN_NAME;
    }

    public String getAppId() {
        return PLUGIN_APPID;
    }

    public void onBind(String queueName) {
        logger.info("Binded to " + queueName);
        this.queueNames.add(queueName);
    }

    public void onUnbind(String queueName) {
        logger.info("Unbinded from " + queueName);
        this.queueNames.remove(queueName);
    }

    public void onReceive(String queueName, String contentType, Map<String, Object> headers, byte[] body) {
        if (this.queueNames.contains(queueName) && JSON_CONTENTTYPE.equals(contentType)) {
            logger.debug("Message received.");
            Provider provider = new Provider();
            if (headers != null) {
                if (headers.containsKey(GERRIT_NAME)) {
                    provider.setName(headers.get(GERRIT_NAME).toString());
                }
                if (headers.containsKey(GERRIT_HOST)) {
                    provider.setHost(headers.get(GERRIT_HOST).toString());
                }
                if (headers.containsKey(GERRIT_SCHEME)) {
                    provider.setScheme(headers.get(GERRIT_SCHEME).toString());
                }
                if (headers.containsKey(GERRIT_PORT)) {
                    provider.setPort(headers.get(GERRIT_PORT).toString());
                }
                if (headers.containsKey(GERRIT_FRONT_URL)) {
                    provider.setUrl(headers.get(GERRIT_FRONT_URL).toString());
                }
                if (headers.containsKey(GERRIT_VERSION)) {
                    provider.setVersion(headers.get(GERRIT_VERSION).toString());
                }
            }
            if (this.api == null) {
                this.api = new GerritTriggerApi();
            }
            try {
                Handler handler = this.api.getHandler();
                handler.post(new String(body, "UTF-8"), provider);
            }
            catch (Exception ex) {
                logger.warn("No handler for Gerrit Trigger. Message would be lost.");
            }
        } else {
            logger.debug("Message from unknown queue or unknown content type. This will be discarded.");
        }
    }
}

