/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.Extension;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCommentAddedContainsEvent
extends PluginGerritEvent
implements Serializable {
    private static final long serialVersionUID = -1190562081236235820L;
    private String commentAddedCommentContains;
    private static final Logger logger = LoggerFactory.getLogger(PluginCommentAddedContainsEvent.class);

    public PluginCommentAddedContainsEvent() {
    }

    @DataBoundConstructor
    public PluginCommentAddedContainsEvent(String commentAddedCommentContains) {
        this.commentAddedCommentContains = commentAddedCommentContains;
    }

    public String getCommentAddedCommentContains() {
        return this.commentAddedCommentContains;
    }

    @Override
    public Class getCorrespondingEventClass() {
        return CommentAdded.class;
    }

    public boolean match(GerritTriggeredEvent event) {
        if (!super.shouldTriggerOn(event)) {
            return false;
        }
        Pattern p = Pattern.compile(this.commentAddedCommentContains, 40);
        CommentAdded ca = (CommentAdded)event;
        logger.debug("input comment: '{}'", (Object)ca.getComment());
        return p.matcher(ca.getComment()).find();
    }

    @Extension
    @Symbol(value={"commentAddedContains"})
    public static class PluginCommentAddedContainsEventDescriptor
    extends PluginGerritEvent.PluginGerritEventDescriptor {
        public String getDisplayName() {
            return Messages.CommentAddedContainsDisplayName();
        }
    }
}

