/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import java.io.File;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public interface CompareUtil {
    public boolean matches(String var1, String var2);

    public String getName();

    public char getOperator();

    public static class RegExpCompareUtil
    implements CompareUtil {
        @Override
        public boolean matches(String pattern, String str) {
            return str.matches(pattern);
        }

        @Override
        public String getName() {
            return "RegExp";
        }

        @Override
        public char getOperator() {
            return '~';
        }
    }

    public static class PlainCompareUtil
    implements CompareUtil {
        @Override
        public boolean matches(String pattern, String str) {
            return pattern.equalsIgnoreCase(str);
        }

        @Override
        public String getName() {
            return "Plain";
        }

        @Override
        public char getOperator() {
            return '=';
        }
    }

    public static class AntCompareUtil
    implements CompareUtil {
        @Override
        public boolean matches(String pattern, String str) {
            String safePattern = pattern.replace('/', File.separatorChar);
            String safeStr = str.replace('/', File.separatorChar);
            return SelectorUtils.matchPath((String)safePattern, (String)safeStr);
        }

        @Override
        public String getName() {
            return "Path";
        }

        @Override
        public char getOperator() {
            return '^';
        }
    }
}

