/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.trigger.config.Config;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.GerritMessageProvider;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.Logic;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Notify;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterExpander {
    public static final int DEFAULT_PARAMETERS_COUNT = 11;
    public static final String MESSAGE_DELIMITER = " : ";
    private static final Logger logger = LoggerFactory.getLogger(ParameterExpander.class);
    private IGerritHudsonTriggerConfig config;
    private Jenkins jenkins;

    public ParameterExpander(IGerritHudsonTriggerConfig config, Jenkins jenkins) {
        this.config = config;
        this.jenkins = jenkins;
    }

    public ParameterExpander(IGerritHudsonTriggerConfig config) {
        this(config, Jenkins.getInstance());
    }

    public String getBuildStartedCommand(Run r, TaskListener taskListener, ChangeBasedEvent event, BuildsStartedStats stats) {
        String buildStartMessage;
        GerritTrigger trigger = GerritTrigger.getTrigger(r.getParent());
        String gerritCmd = this.config.getGerritCmdBuildStarted();
        Map<String, String> parameters = this.createStandardParameters(r, (GerritTriggeredEvent)event, this.getBuildStartedCodeReviewValue(r), this.getBuildStartedVerifiedValue(r), Notify.ALL.name());
        StringBuilder startedStats = new StringBuilder();
        if (stats.getTotalBuildsToStart() > 1) {
            startedStats.append(stats.toString());
        }
        if ((buildStartMessage = trigger.getBuildStartMessage()) != null && !buildStartMessage.isEmpty()) {
            startedStats.append("\n\n").append(this.expandParameters(buildStartMessage, r, taskListener, parameters));
        }
        if (this.config.isEnablePluginMessages()) {
            for (GerritMessageProvider messageProvider : ParameterExpander.emptyIfNull(GerritMessageProvider.all())) {
                String extensionMessage = messageProvider.getBuildStartedMessage(r);
                if (extensionMessage == null) continue;
                startedStats.append("\n\n").append(extensionMessage);
            }
        }
        parameters.put("STARTED_STATS", startedStats.toString());
        return this.expandParameters(gerritCmd, r, taskListener, parameters);
    }

    private static <T> Iterable<T> emptyIfNull(Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return iterable;
    }

    private Integer getBuildStartedVerifiedValue(Run r) {
        GerritTrigger trigger = GerritTrigger.getTrigger(r.getParent());
        if (trigger == null) {
            logger.warn("Unable to get trigger config for build {} will use global value.");
            return this.config.getGerritBuildStartedVerifiedValue();
        }
        if (trigger.getGerritBuildStartedVerifiedValue() != null) {
            Integer value = trigger.getGerritBuildStartedVerifiedValue();
            logger.trace("BuildStartedVerified overridden in project config. returning {}", (Object)value);
            return value;
        }
        Integer value = this.config.getGerritBuildStartedVerifiedValue();
        logger.trace("BuildStartedVerified standard value used {}", (Object)value);
        return value;
    }

    private Integer getBuildStartedCodeReviewValue(Run r) {
        GerritTrigger trigger = GerritTrigger.getTrigger(r.getParent());
        if (trigger == null) {
            logger.warn("Unable to get trigger config for build {} will use global value.");
            return this.config.getGerritBuildStartedCodeReviewValue();
        }
        if (trigger.getGerritBuildStartedCodeReviewValue() != null) {
            Integer value = trigger.getGerritBuildStartedCodeReviewValue();
            logger.trace("BuildStartedCodeReview overridden in project config. returning {}", (Object)value);
            return value;
        }
        Integer value = this.config.getGerritBuildStartedCodeReviewValue();
        logger.trace("BuildStartedCodeReview standard value used {}", (Object)value);
        return value;
    }

    private Map<String, String> createStandardParameters(Run r, GerritTriggeredEvent gerritEvent, Integer codeReview, Integer verified, String notifyLevel) {
        HashMap<String, String> map = new HashMap<String, String>(11);
        if (gerritEvent instanceof ChangeBasedEvent) {
            ChangeBasedEvent event = (ChangeBasedEvent)gerritEvent;
            map.put("GERRIT_NAME", event.getChange().getProject());
            map.put("CHANGE_ID", event.getChange().getId());
            map.put("BRANCH", event.getChange().getBranch());
            if (null != event.getChange().getTopic()) {
                map.put("TOPIC", event.getChange().getTopic());
            }
            map.put("CHANGE", event.getChange().getNumber());
            if (null != event.getPatchSet()) {
                map.put("PATCHSET", event.getPatchSet().getNumber());
                map.put("PATCHSET_REVISION", event.getPatchSet().getRevision());
                map.put("REFSPEC", StringUtil.makeRefSpec(event));
            }
        }
        if (r != null) {
            map.put("BUILDURL", this.jenkins.getRootUrl() + r.getUrl());
        }
        map.put("VERIFIED", String.valueOf(verified));
        map.put("CODE_REVIEW", String.valueOf(codeReview));
        map.put("NOTIFICATION_LEVEL", notifyLevel);
        return map;
    }

    private String expandParameters(String gerritCommand, Run r, TaskListener taskListener, Map<String, String> parameters) {
        String command = gerritCommand;
        if (r != null && taskListener != null) {
            try {
                command = r.getEnvironment(taskListener).expand(command);
            }
            catch (Exception ex) {
                logger.error("Failed to expand env vars into gerrit cmd. Gerrit won't be notified!!", (Throwable)ex);
                return null;
            }
        }
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            command = command.replace("<" + param.getKey() + ">", param.getValue());
        }
        command = command.replace("--code-review null", "");
        command = command.replace("--code-review 2147483647", "");
        command = command.replace("--verified null", "");
        command = command.replace("--verified 2147483647", "");
        return command;
    }

    protected Integer getCodeReviewValue(Result res, GerritTrigger trigger) {
        if (res == Result.SUCCESS) {
            if (trigger.getGerritBuildSuccessfulCodeReviewValue() != null) {
                return trigger.getGerritBuildSuccessfulCodeReviewValue();
            }
            return this.config.getGerritBuildSuccessfulCodeReviewValue();
        }
        if (res == Result.FAILURE) {
            if (trigger.getGerritBuildFailedCodeReviewValue() != null) {
                return trigger.getGerritBuildFailedCodeReviewValue();
            }
            return this.config.getGerritBuildFailedCodeReviewValue();
        }
        if (res == Result.UNSTABLE) {
            if (trigger.getGerritBuildUnstableCodeReviewValue() != null) {
                return trigger.getGerritBuildUnstableCodeReviewValue();
            }
            return this.config.getGerritBuildUnstableCodeReviewValue();
        }
        if (res == Result.NOT_BUILT) {
            if (trigger.getGerritBuildNotBuiltCodeReviewValue() != null) {
                return trigger.getGerritBuildNotBuiltCodeReviewValue();
            }
            return this.config.getGerritBuildNotBuiltCodeReviewValue();
        }
        if (res == Result.ABORTED) {
            if (trigger.getGerritBuildAbortedCodeReviewValue() != null) {
                return trigger.getGerritBuildAbortedCodeReviewValue();
            }
            return this.config.getGerritBuildAbortedCodeReviewValue();
        }
        if (trigger.getGerritBuildFailedCodeReviewValue() != null) {
            return trigger.getGerritBuildFailedCodeReviewValue();
        }
        return this.config.getGerritBuildFailedCodeReviewValue();
    }

    protected Integer getVerifiedValue(Result res, GerritTrigger trigger) {
        if (res == Result.SUCCESS) {
            if (trigger.getGerritBuildSuccessfulVerifiedValue() != null) {
                return trigger.getGerritBuildSuccessfulVerifiedValue();
            }
            return this.config.getGerritBuildSuccessfulVerifiedValue();
        }
        if (res == Result.FAILURE) {
            if (trigger.getGerritBuildFailedVerifiedValue() != null) {
                return trigger.getGerritBuildFailedVerifiedValue();
            }
            return this.config.getGerritBuildFailedVerifiedValue();
        }
        if (res == Result.UNSTABLE) {
            if (trigger.getGerritBuildUnstableVerifiedValue() != null) {
                return trigger.getGerritBuildUnstableVerifiedValue();
            }
            return this.config.getGerritBuildUnstableVerifiedValue();
        }
        if (res == Result.NOT_BUILT) {
            if (trigger.getGerritBuildNotBuiltVerifiedValue() != null) {
                return trigger.getGerritBuildNotBuiltVerifiedValue();
            }
            return this.config.getGerritBuildNotBuiltVerifiedValue();
        }
        if (res == Result.ABORTED) {
            if (trigger.getGerritBuildAbortedVerifiedValue() != null) {
                return trigger.getGerritBuildAbortedVerifiedValue();
            }
            return this.config.getGerritBuildAbortedVerifiedValue();
        }
        if (trigger.getGerritBuildFailedVerifiedValue() != null) {
            return trigger.getGerritBuildFailedVerifiedValue();
        }
        return this.config.getGerritBuildFailedVerifiedValue();
    }

    @CheckForNull
    public Integer getMinimumVerifiedValue(BuildMemory.MemoryImprint memoryImprint, boolean onlyBuilt) {
        Integer verified = Integer.MAX_VALUE;
        for (BuildMemory.MemoryImprint.Entry entry : memoryImprint.getEntries()) {
            Integer verifiedObj;
            GerritTrigger trigger;
            Run build;
            if (entry == null || (build = entry.getBuild()) == null) continue;
            Result result = build.getResult();
            if (onlyBuilt && result == Result.NOT_BUILT || Logic.shouldSkip((trigger = GerritTrigger.getTrigger(entry.getProject())).getSkipVote(), result) || (verifiedObj = this.getVerifiedValue(result, trigger)) == null) continue;
            verified = Math.min(verified, verifiedObj);
        }
        if (verified == Integer.MAX_VALUE) {
            return null;
        }
        return verified;
    }

    @CheckForNull
    public Integer getMinimumCodeReviewValue(BuildMemory.MemoryImprint memoryImprint, boolean onlyBuilt) {
        Integer codeReview = Integer.MAX_VALUE;
        for (BuildMemory.MemoryImprint.Entry entry : memoryImprint.getEntries()) {
            Integer codeReviewObj;
            GerritTrigger trigger;
            Run build = entry.getBuild();
            if (build == null) continue;
            Result result = build.getResult();
            if (onlyBuilt && result == Result.NOT_BUILT || Logic.shouldSkip((trigger = GerritTrigger.getTrigger(entry.getProject())).getSkipVote(), result) || (codeReviewObj = this.getCodeReviewValue(result, trigger)) == null) continue;
            codeReview = Math.min(codeReview, codeReviewObj);
        }
        if (codeReview == Integer.MAX_VALUE) {
            return null;
        }
        return codeReview;
    }

    public Notify getHighestNotificationLevel(BuildMemory.MemoryImprint memoryImprint, boolean onlyBuilt) {
        Notify highestLevel = Notify.NONE;
        for (BuildMemory.MemoryImprint.Entry entry : memoryImprint.getEntries()) {
            Notify level;
            GerritTrigger trigger;
            Run build;
            if (entry == null || (build = entry.getBuild()) == null) continue;
            Result result = build.getResult();
            if (onlyBuilt && result == Result.NOT_BUILT || (trigger = GerritTrigger.getTrigger(entry.getProject())) == null || Logic.shouldSkip(trigger.getSkipVote(), result) || (level = this.getNotificationLevel(trigger)) == null || level.compareTo((Enum)highestLevel) <= 0) continue;
            highestLevel = level;
        }
        return highestLevel;
    }

    public Notify getNotificationLevel(GerritTrigger trigger) {
        String level = trigger.getNotificationLevel();
        if (level != null && level.length() > 0) {
            return Notify.valueOf((String)level);
        }
        Notify serverLevel = this.config.getNotificationLevel();
        if (serverLevel != null) {
            return serverLevel;
        }
        return Config.DEFAULT_NOTIFICATION_LEVEL;
    }

    public String getBuildCompletedCommand(BuildMemory.MemoryImprint memoryImprint, TaskListener listener) {
        String command;
        boolean onlyCountBuilt = true;
        if (memoryImprint.wereAllBuildsSuccessful()) {
            command = this.config.getGerritCmdBuildSuccessful();
        } else if (memoryImprint.wereAnyBuildsFailed()) {
            command = this.config.getGerritCmdBuildFailed();
        } else if (memoryImprint.wereAnyBuildsUnstable()) {
            command = this.config.getGerritCmdBuildUnstable();
        } else if (memoryImprint.wereAllBuildsNotBuilt()) {
            onlyCountBuilt = false;
            command = this.config.getGerritCmdBuildNotBuilt();
        } else {
            command = memoryImprint.wereAnyBuildsAborted() ? this.config.getGerritCmdBuildAborted() : this.config.getGerritCmdBuildFailed();
        }
        Integer verified = null;
        Integer codeReview = null;
        Notify notifyLevel = Notify.ALL;
        if (memoryImprint.getEvent().isScorable()) {
            verified = this.getMinimumVerifiedValue(memoryImprint, onlyCountBuilt);
            codeReview = this.getMinimumCodeReviewValue(memoryImprint, onlyCountBuilt);
            notifyLevel = this.getHighestNotificationLevel(memoryImprint, onlyCountBuilt);
        }
        Map<String, String> parameters = this.createStandardParameters(null, memoryImprint.getEvent(), codeReview, verified, notifyLevel.name());
        parameters.put("BUILDS_STATS", this.createBuildsStats(memoryImprint, listener, parameters).replaceAll("'", "'\"'\"'"));
        Run build = null;
        BuildMemory.MemoryImprint.Entry[] entries = memoryImprint.getEntries();
        if (entries.length > 0 && entries[0].getBuild() != null) {
            build = entries[0].getBuild();
        }
        return this.expandParameters(command, build, listener, parameters);
    }

    private String createBuildsStats(BuildMemory.MemoryImprint memoryImprint, TaskListener listener, Map<String, String> parameters) {
        StringBuilder str = new StringBuilder("");
        String rootUrl = this.jenkins.getRootUrl();
        String unsuccessfulMessage = null;
        BuildMemory.MemoryImprint.Entry[] entries = memoryImprint.getEntries();
        Arrays.sort(entries, EntryByBuildResultComparator.DESCENDING);
        if (entries.length > 0) {
            for (BuildMemory.MemoryImprint.Entry entry : entries) {
                Run build;
                if (entry == null || (build = entry.getBuild()) == null) continue;
                GerritTrigger trigger = GerritTrigger.getTrigger(build.getParent());
                Result res = build.getResult();
                if (res == null) {
                    res = Result.NOT_BUILT;
                }
                str.append("\n\n");
                if (entry.getCustomUrl() != null && !entry.getCustomUrl().isEmpty()) {
                    str.append(this.expandParameters(entry.getCustomUrl(), build, listener, parameters));
                } else if (trigger.getCustomUrl() != null && !trigger.getCustomUrl().isEmpty()) {
                    str.append(this.expandParameters(trigger.getCustomUrl(), build, listener, parameters));
                } else {
                    str.append(rootUrl).append(build.getUrl());
                }
                str.append(MESSAGE_DELIMITER);
                String customMessage = null;
                customMessage = res == Result.SUCCESS ? trigger.getBuildSuccessfulMessage() : (res == Result.FAILURE ? trigger.getBuildFailureMessage() : (res == Result.UNSTABLE ? trigger.getBuildUnstableMessage() : (res == Result.NOT_BUILT ? trigger.getBuildNotBuiltMessage() : (res == Result.ABORTED ? trigger.getBuildAbortedMessage() : trigger.getBuildFailureMessage()))));
                if (customMessage == null || customMessage.isEmpty()) {
                    str.append(res.toString());
                    if (Logic.shouldSkip(trigger.getSkipVote(), res)) {
                        str.append(" (skipped)");
                    }
                } else {
                    str.append(this.expandParameters(customMessage, build, listener, parameters));
                }
                if (res.isWorseThan(Result.SUCCESS) && null != (unsuccessfulMessage = entry.getUnsuccessfulMessage()) && !unsuccessfulMessage.isEmpty()) {
                    logger.trace("Using unsuccessful message.");
                    str.append(" <<<\n");
                    str.append(unsuccessfulMessage.trim());
                    str.append("\n>>>");
                }
                if (!this.config.isEnablePluginMessages()) continue;
                for (GerritMessageProvider messageProvider : ParameterExpander.emptyIfNull(GerritMessageProvider.all())) {
                    String extensionMessage = messageProvider.getBuildCompletedMessage(build);
                    if (extensionMessage == null) continue;
                    str.append("\n\n").append(extensionMessage);
                }
            }
        } else {
            logger.error("I got a request to create build statistics, but no entries where found!");
        }
        return str.toString();
    }

    public String getBuildCompletedMessage(BuildMemory.MemoryImprint memoryImprint, TaskListener listener) {
        String completedCommand = this.getBuildCompletedCommand(memoryImprint, listener);
        return this.findMessage(completedCommand);
    }

    public String getBuildStartedMessage(Run build, TaskListener listener, ChangeBasedEvent event, BuildsStartedStats stats) {
        String startedCommand = this.getBuildStartedCommand(build, listener, event, stats);
        return this.findMessage(startedCommand);
    }

    protected String findMessage(String completedCommand) {
        String messageStart = "--message '";
        String fromMessage = completedCommand.substring(completedCommand.indexOf(messageStart));
        int endIndex = fromMessage.indexOf("' --");
        if (endIndex <= -1) {
            endIndex = fromMessage.length();
        }
        return fromMessage.substring(messageStart.length(), endIndex);
    }

    private static final class EntryByBuildResultComparator
    implements Comparator<BuildMemory.MemoryImprint.Entry> {
        static final EntryByBuildResultComparator DESCENDING = new EntryByBuildResultComparator(true);
        private boolean descending;

        private EntryByBuildResultComparator(boolean descending) {
            this.descending = descending;
        }

        @Override
        public int compare(BuildMemory.MemoryImprint.Entry e1, BuildMemory.MemoryImprint.Entry e2) {
            if (e1 == null) {
                throw new NullPointerException("e1");
            }
            if (e2 == null) {
                throw new NullPointerException("e2");
            }
            Run b1 = e1.getBuild();
            Run b2 = e2.getBuild();
            if (b1 != null && b2 != null) {
                Result r1 = b1.getResult();
                Result r2 = b2.getResult();
                int o1 = 0;
                if (r1 != null) {
                    o1 = r1.ordinal;
                }
                int o2 = 0;
                if (r2 != null) {
                    o2 = r2.ordinal;
                }
                if (this.descending) {
                    return o2 - o1;
                }
                return o1 - o2;
            }
            if (b1 != null) {
                return 1;
            }
            if (b2 != null) {
                return -1;
            }
            return 0;
        }
    }
}

