/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.extensions;

import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Result;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GerritTriggeredBuildListener
implements ExtensionPoint {
    private static final Logger logger = LoggerFactory.getLogger(GerritTriggeredBuildListener.class);

    public abstract void onStarted(GerritTriggeredEvent var1, String var2);

    public abstract void onCompleted(Result var1, GerritTriggeredEvent var2, String var3);

    public static void fireOnStarted(GerritTriggeredEvent event, String command) {
        for (GerritTriggeredBuildListener listener : GerritTriggeredBuildListener.all()) {
            try {
                listener.onStarted(event, command);
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage());
            }
        }
    }

    public static void fireOnCompleted(BuildMemory.MemoryImprint memoryImprint, String command) {
        Result result = Result.FAILURE;
        if (memoryImprint.wereAllBuildsSuccessful()) {
            result = Result.SUCCESS;
        } else if (memoryImprint.wereAnyBuildsFailed()) {
            result = Result.FAILURE;
        } else if (memoryImprint.wereAnyBuildsUnstable()) {
            result = Result.UNSTABLE;
        } else if (memoryImprint.wereAllBuildsNotBuilt()) {
            result = Result.NOT_BUILT;
        } else if (memoryImprint.wereAnyBuildsAborted()) {
            result = Result.ABORTED;
        }
        for (GerritTriggeredBuildListener listener : GerritTriggeredBuildListener.all()) {
            try {
                listener.onCompleted(result, memoryImprint.getEvent(), command);
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage());
            }
        }
    }

    public static ExtensionList<GerritTriggeredBuildListener> all() {
        Jenkins jenkins = Jenkins.getInstance();
        assert (jenkins != null);
        return jenkins.getExtensionList(GerritTriggeredBuildListener.class);
    }
}

