/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics.BuildMemoryReport;
import com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics.EventListenersReport;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.manual.ManualTriggerAction;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritChangeKind;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Account;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Change;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.PatchSet;
import hudson.Main;
import hudson.security.Permission;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class Diagnostics
implements ModelObjectWithChildren,
ModelObjectWithContextMenu {
    private static final Random RND = new Random();

    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        return this.getContextMenu(null);
    }

    @Restricted(value={NoExternalUse.class})
    public ModelObjectWithContextMenu.ContextMenu getContextMenu(String context) {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        String url = this.makeRelativeUrl(context, "buildMemory");
        menu.add(new ModelObjectWithContextMenu.MenuItem().withUrl(url).withStockIcon("clipboard.png").withDisplayName(Messages.BuildMemoryReport_DisplayName()));
        url = this.makeRelativeUrl(context, "eventListeners");
        menu.add(new ModelObjectWithContextMenu.MenuItem().withUrl(url).withStockIcon("clipboard.png").withDisplayName(Messages.EventListenersReport_DisplayName()));
        if (this.isDebugMode()) {
            menu.add("triggerDebugEvent", "warning.png", "Trigger Debug", false, true);
        }
        return menu;
    }

    private String makeRelativeUrl(String context, String name) {
        StringBuilder url = new StringBuilder(name);
        if (!StringUtils.isBlank((CharSequence)context)) {
            if (!context.endsWith("/")) {
                url.insert(0, '/');
            }
            url.insert(0, context);
        }
        return url.toString();
    }

    @Nonnull
    public static Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    public String getDisplayName() {
        return Messages.GerritManagement_Diagnostics_DisplayName();
    }

    @CheckForNull
    public BuildMemoryReport getBuildMemory() {
        ToGerritRunListener instance = ToGerritRunListener.getInstance();
        if (instance != null) {
            return instance.report();
        }
        return null;
    }

    @CheckForNull
    public EventListenersReport getEventListeners() {
        return EventListenersReport.report();
    }

    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        return this.getContextMenu(null);
    }

    public void doTriggerDebugEvent(StaplerRequest request, StaplerResponse response) throws IOException {
        if (!this.isDebugMode()) {
            throw new IllegalStateException("Can only be done in a dev environment!");
        }
        List<GerritServer> servers = PluginImpl.getServers_();
        if (servers.isEmpty()) {
            throw new IllegalStateException("Need at least one server configured!");
        }
        GerritServer srv = servers.size() == 1 ? servers.get(0) : servers.get(RND.nextInt(servers.size()));
        ManualPatchsetCreated event = new ManualPatchsetCreated();
        Authentication authentication = Jenkins.getAuthentication();
        event.setUserName(authentication.getName());
        event.setAccount(new Account(authentication.getName(), authentication.getName() + "@example.com"));
        Change change = new Change();
        change.setOwner(event.getAccount());
        change.setCommitMessage("Debug Commit Message");
        change.setSubject("Debug Subject");
        change.setBranch("master");
        change.setCreatedOn(new Date());
        change.setId("I" + UUID.randomUUID().toString().replace("-", ""));
        change.setLastUpdated(new Date());
        change.setProject("debug/project");
        change.setTopic("debug");
        change.setNumber(String.valueOf(RND.nextInt(10001)));
        change.setUrl("http://gerrit/" + change.getNumber());
        event.setChange(change);
        PatchSet patchSet = new PatchSet();
        patchSet.setUploader(event.getAccount());
        patchSet.setNumber(String.valueOf(RND.nextInt(32)));
        patchSet.setCreatedOn(new Date());
        patchSet.setDraft(false);
        patchSet.setKind(GerritChangeKind.REWORK);
        patchSet.setRevision(UUID.randomUUID().toString().replace("-", ""));
        patchSet.setRef("refs/changes/" + change.getNumber() + "/" + patchSet.getNumber());
        event.setPatchset(patchSet);
        event.setEventCreatedOn(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        event.setReceivedOn(System.currentTimeMillis());
        event.setProvider(ManualTriggerAction.createProvider(srv));
        srv.triggerEvent((GerritEvent)event);
        response.sendRedirect2(request.getReferer());
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isDebugMode() {
        if (Main.isDevelopmentMode || Main.isUnitTest) {
            return true;
        }
        return System.getProperty("hudson.hpi.run") != null;
    }
}

