/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.replication;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritSlave;
import hudson.model.queue.CauseOfBlockage;
import java.util.Collection;
import javax.annotation.Nullable;

public class WaitingForReplication
extends CauseOfBlockage {
    private Collection<GerritSlave> gerritSlaves;

    public WaitingForReplication(Collection<GerritSlave> gerritSlaves) {
        this.gerritSlaves = gerritSlaves;
    }

    public String getShortDescription() {
        Collection gerritSlaveNames = Collections2.transform(this.gerritSlaves, (Function)ToGerritSlaveName.INSTANCE);
        return Messages.WaitingForReplication(Joiner.on((String)", ").join((Iterable)gerritSlaveNames));
    }

    private static enum ToGerritSlaveName implements Function<GerritSlave, String>
    {
        INSTANCE;


        public String apply(@Nullable GerritSlave gerritSlave) {
            if (gerritSlave != null) {
                return gerritSlave.getName();
            }
            return null;
        }
    }
}

