/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritChangeKind;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.PatchsetCreated;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import java.io.Serializable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PluginPatchsetCreatedEvent
extends PluginGerritEvent
implements Serializable {
    private static final long serialVersionUID = 970946986242309088L;
    private boolean excludeDrafts = false;
    private boolean excludeTrivialRebase = false;
    private boolean excludeNoCodeChange = false;
    private boolean excludePrivateState = false;
    private boolean excludeWipState = false;

    @DataBoundConstructor
    public PluginPatchsetCreatedEvent() {
        this.excludeDrafts = false;
        this.excludeTrivialRebase = false;
        this.excludeNoCodeChange = false;
        this.excludePrivateState = false;
        this.excludeWipState = false;
    }

    @Deprecated
    public PluginPatchsetCreatedEvent(boolean excludeDrafts, boolean excludeTrivialRebase, boolean excludeNoCodeChange) {
        this.excludeDrafts = excludeDrafts;
        this.excludeTrivialRebase = excludeTrivialRebase;
        this.excludeNoCodeChange = excludeNoCodeChange;
    }

    @DataBoundSetter
    public void setExcludeDrafts(boolean excludeDrafts) {
        this.excludeDrafts = excludeDrafts;
    }

    @DataBoundSetter
    public void setExcludeTrivialRebase(boolean excludeTrivialRebase) {
        this.excludeTrivialRebase = excludeTrivialRebase;
    }

    @DataBoundSetter
    public void setExcludeNoCodeChange(boolean excludeNoCodeChange) {
        this.excludeNoCodeChange = excludeNoCodeChange;
    }

    @DataBoundSetter
    public void setExcludePrivateState(boolean excludePrivateState) {
        this.excludePrivateState = excludePrivateState;
    }

    @DataBoundSetter
    public void setExcludeWipState(boolean excludeWipState) {
        this.excludeWipState = excludeWipState;
    }

    public Descriptor<PluginGerritEvent> getDescriptor() {
        return Hudson.getInstance().getDescriptorByType(PluginPatchsetCreatedEventDescriptor.class);
    }

    @Override
    public Class getCorrespondingEventClass() {
        return PatchsetCreated.class;
    }

    public boolean isExcludeDrafts() {
        return this.excludeDrafts;
    }

    public boolean isExcludeTrivialRebase() {
        return this.excludeTrivialRebase;
    }

    public boolean isExcludeNoCodeChange() {
        return this.excludeNoCodeChange;
    }

    public boolean isExcludePrivateState() {
        return this.excludePrivateState;
    }

    public boolean isExcludeWipState() {
        return this.excludeWipState;
    }

    @Override
    public boolean shouldTriggerOn(GerritTriggeredEvent event) {
        if (!super.shouldTriggerOn(event)) {
            return false;
        }
        if (this.excludeDrafts && ((PatchsetCreated)event).getPatchSet().isDraft()) {
            return false;
        }
        if (event instanceof ManualPatchsetCreated) {
            return true;
        }
        if (this.excludeTrivialRebase && GerritChangeKind.TRIVIAL_REBASE == ((PatchsetCreated)event).getPatchSet().getKind()) {
            return false;
        }
        if (this.excludeNoCodeChange && GerritChangeKind.NO_CODE_CHANGE == ((PatchsetCreated)event).getPatchSet().getKind()) {
            return false;
        }
        if (this.excludePrivateState && ((PatchsetCreated)event).getChange().isPrivate()) {
            return false;
        }
        return !this.excludeWipState || !((PatchsetCreated)event).getChange().isWip();
    }

    @Extension
    @Symbol(value={"patchsetCreated"})
    public static class PluginPatchsetCreatedEventDescriptor
    extends PluginGerritEvent.PluginGerritEventDescriptor {
        public String getDisplayName() {
            return Messages.PatchsetCreatedDisplayName();
        }
    }
}

