/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.NamedGerritEventListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.EventListener;
import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import com.sonymobile.tools.gerrit.gerritevents.GerritHandler;
import hudson.model.ModelObject;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class EventListenersReport
implements ModelObject {
    private Set<EventListener> jobs;
    private Set<GerritEventListener> others;

    EventListenersReport(Set<EventListener> jobs, Set<GerritEventListener> others) {
        this.jobs = jobs;
        this.others = others;
    }

    public Set<EventListener> getJobs() {
        return this.jobs;
    }

    public Set<GerritEventListener> getOthers() {
        return this.others;
    }

    @Restricted(value={NoExternalUse.class})
    public String getName(GerritEventListener listener) {
        if (listener instanceof NamedGerritEventListener) {
            return ((NamedGerritEventListener)listener).getDisplayName();
        }
        return listener.getClass().getSimpleName();
    }

    @CheckForNull
    public static EventListenersReport report() {
        GerritHandler handler = PluginImpl.getHandler_();
        if (handler != null) {
            TreeSet<EventListener> jobs = new TreeSet<EventListener>(new Comparator<EventListener>(){

                @Override
                public int compare(EventListener o1, EventListener o2) {
                    return o1.getJob().compareTo(o2.getJob());
                }
            });
            LinkedHashSet<GerritEventListener> others = new LinkedHashSet<GerritEventListener>();
            Set view = handler.getGerritEventListenersView();
            for (GerritEventListener listener : view) {
                if (listener instanceof EventListener) {
                    jobs.add((EventListener)listener);
                    continue;
                }
                others.add(listener);
            }
            return new EventListenersReport(jobs, others);
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.EventListenersReport_DisplayName();
    }
}

