/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.config;

import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.replication.ReplicationCache;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEventType;
import com.sonymobile.tools.gerrit.gerritevents.workers.GerritWorkersConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfig
implements GerritWorkersConfig {
    public static final int DEFAULT_NR_OF_RECEIVING_WORKER_THREADS = 3;
    public static final int DEFAULT_NR_OF_SENDING_WORKER_THREADS = 1;
    public static final List<String> DEFAULT_EVENT_FILTER = PluginConfig.getDefaultEventFilter();
    public static final List<String> ALL_EVENTS = PluginConfig.getAllEvents();
    private static final Logger logger = LoggerFactory.getLogger(PluginImpl.class);
    private int numberOfReceivingWorkerThreads;
    private int numberOfSendingWorkerThreads;
    private int replicationCacheExpirationInMinutes;
    private List<String> filterIn;

    public PluginConfig() {
        this(new JSONObject(false));
    }

    public PluginConfig(JSONObject formData) {
        this.setValues(formData);
    }

    public PluginConfig(PluginConfig pluginConfig) {
        this.numberOfReceivingWorkerThreads = pluginConfig.getNumberOfReceivingWorkerThreads();
        this.numberOfSendingWorkerThreads = pluginConfig.getNumberOfSendingWorkerThreads();
        this.replicationCacheExpirationInMinutes = pluginConfig.getReplicationCacheExpirationInMinutes();
        this.filterIn = pluginConfig.getFilterIn();
    }

    public PluginConfig(JSONObject formData, StaplerRequest req) {
        this(formData);
    }

    public void setValues(JSONObject formData) {
        this.numberOfReceivingWorkerThreads = formData.optInt("numberOfReceivingWorkerThreads", 3);
        if (this.numberOfReceivingWorkerThreads <= 0) {
            this.numberOfReceivingWorkerThreads = 3;
        }
        this.numberOfSendingWorkerThreads = formData.optInt("numberOfSendingWorkerThreads", 1);
        if (this.numberOfSendingWorkerThreads <= 0) {
            this.numberOfSendingWorkerThreads = 1;
        }
        this.replicationCacheExpirationInMinutes = formData.optInt("replicationCacheExpirationInMinutes", ReplicationCache.DEFAULT_EXPIRATION_IN_MINUTES);
        if (this.replicationCacheExpirationInMinutes <= 0) {
            this.replicationCacheExpirationInMinutes = ReplicationCache.DEFAULT_EXPIRATION_IN_MINUTES;
        }
        this.filterIn = this.getFilterInFromFormData(formData);
        this.updateEventFilter();
    }

    public int getNumberOfReceivingWorkerThreads() {
        if (this.numberOfReceivingWorkerThreads <= 0) {
            this.numberOfReceivingWorkerThreads = 3;
        }
        return this.numberOfReceivingWorkerThreads;
    }

    public void setNumberOfReceivingWorkerThreads(int numberOfReceivingWorkerThreads) {
        this.numberOfReceivingWorkerThreads = numberOfReceivingWorkerThreads;
    }

    public int getNumberOfSendingWorkerThreads() {
        if (this.numberOfSendingWorkerThreads <= 0) {
            this.numberOfSendingWorkerThreads = 1;
        }
        return this.numberOfSendingWorkerThreads;
    }

    public void setNumberOfSendingWorkerThreads(int numberOfSendingWorkerThreads) {
        this.numberOfSendingWorkerThreads = numberOfSendingWorkerThreads;
    }

    public int getReplicationCacheExpirationInMinutes() {
        if (this.replicationCacheExpirationInMinutes <= 0) {
            this.replicationCacheExpirationInMinutes = ReplicationCache.DEFAULT_EXPIRATION_IN_MINUTES;
        }
        return this.replicationCacheExpirationInMinutes;
    }

    public void setReplicationCacheExpirationInMinutes(int replicationCacheExpirationInMinutes) {
        this.replicationCacheExpirationInMinutes = replicationCacheExpirationInMinutes;
    }

    public int getEventTypesSize() {
        return GerritEventType.values().length;
    }

    public List<String> getFilterIn() {
        if (this.filterIn == null) {
            GerritEventType[] types = GerritEventType.values();
            ArrayList<String> typeList = new ArrayList<String>();
            for (GerritEventType type : types) {
                if (!type.isInteresting()) continue;
                typeList.add(type.getTypeValue());
            }
            Collections.sort(typeList);
            return typeList;
        }
        return this.filterIn;
    }

    private List<String> getFilterInFromFormData(JSONObject formData) {
        String stringIn = formData.optString("filterIn", null);
        List<Object> filter = null;
        String[] arrayIn = null;
        if (stringIn != null && !stringIn.equals("null")) {
            filter = new ArrayList();
            arrayIn = stringIn.split("\\s+");
            filter = Arrays.asList(arrayIn);
        }
        return filter;
    }

    public void updateEventFilter() {
        List<String> filter = this.filterIn != null ? this.filterIn : PluginConfig.getDefaultEventFilter();
        logger.info("Listening to event types: {}", filter);
        for (GerritEventType type : GerritEventType.values()) {
            type.setInteresting(filter.contains(type.getTypeValue()));
        }
    }

    public static List<String> getDefaultEventFilter() {
        GerritEventType[] types = GerritEventType.values();
        ArrayList<String> typeList = new ArrayList<String>();
        for (GerritEventType type : types) {
            typeList.add(type.getTypeValue());
        }
        Collections.sort(typeList);
        return typeList;
    }

    public static List<String> getAllEvents() {
        GerritEventType[] types = GerritEventType.values();
        ArrayList<String> typeList = new ArrayList<String>();
        for (GerritEventType type : types) {
            typeList.add(type.getTypeValue());
        }
        Collections.sort(typeList);
        return typeList;
    }
}

