/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.workflow;

import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import hudson.Extension;
import hudson.Util;
import hudson.model.Run;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SetGerritReviewStep
extends AbstractStepImpl {
    private String customUrl;
    private String unsuccessfulMessage;

    @DataBoundConstructor
    public SetGerritReviewStep() {
    }

    @CheckForNull
    public String getCustomUrl() {
        return this.customUrl;
    }

    @DataBoundSetter
    public void setCustomUrl(String customUrl) {
        this.customUrl = Util.fixEmptyAndTrim((String)customUrl);
    }

    @CheckForNull
    public String getUnsuccessfulMessage() {
        return this.unsuccessfulMessage;
    }

    @DataBoundSetter
    public void setUnsuccessfulMessage(String unsuccessfulMessage) {
        this.unsuccessfulMessage = Util.fixEmptyAndTrim((String)unsuccessfulMessage);
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "setGerritReview";
        }

        public String getDisplayName() {
            return "Set Gerrit review";
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Void> {
        @StepContextParameter
        private transient Run build;
        @Inject
        private transient SetGerritReviewStep step;
        private static final long serialVersionUID = 1L;

        protected Void run() throws Exception {
            String unsuccessfulMessage;
            ToGerritRunListener listener = ToGerritRunListener.getInstance();
            String customUrl = this.step.getCustomUrl();
            if (customUrl != null) {
                listener.setBuildCustomUrl(this.build, customUrl);
            }
            if ((unsuccessfulMessage = this.step.getUnsuccessfulMessage()) != null) {
                listener.setBuildUnsuccessfulMessage(this.build, unsuccessfulMessage);
            }
            return null;
        }
    }
}

