/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.utils;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.HttpUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritPluginChecker {
    private static final Logger logger = LoggerFactory.getLogger(GerritPluginChecker.class);

    private GerritPluginChecker() {
    }

    private static String buildURL(IGerritHudsonTriggerConfig config) {
        String gerritFrontEndUrl;
        if (config == null) {
            throw new IllegalArgumentException("Gerrit Server Configuration cannot be null");
        }
        if (!config.isUseRestApi()) {
            logger.debug("REST API is not enabled.");
            return null;
        }
        String restUrl = gerritFrontEndUrl = config.getGerritFrontEndUrl();
        if (gerritFrontEndUrl != null && !gerritFrontEndUrl.endsWith("/")) {
            restUrl = gerritFrontEndUrl + "/";
        }
        return restUrl;
    }

    private static boolean decodeStatus(int statusCode, String pluginName, boolean quiet) {
        String message = "";
        switch (statusCode) {
            case 200: {
                message = Messages.PluginInstalled(pluginName);
                if (quiet) {
                    logger.debug(message);
                } else {
                    logger.info(message);
                }
                return true;
            }
            case 404: {
                message = Messages.PluginNotInstalled(pluginName);
                if (quiet) {
                    logger.debug(message);
                } else {
                    logger.warn(message);
                }
                return false;
            }
            case 401: {
                message = Messages.PluginHttpConnectionUnauthorized(pluginName, Messages.HttpConnectionUnauthorized());
                if (quiet) {
                    logger.debug(message);
                } else {
                    logger.warn(message);
                }
                return false;
            }
            case 403: {
                message = Messages.PluginHttpConnectionForbidden(pluginName, Messages.HttpConnectionUnauthorized());
                if (quiet) {
                    logger.debug(message);
                } else {
                    logger.warn(message);
                }
                return false;
            }
        }
        message = Messages.PluginHttpConnectionGeneralError(pluginName, Messages.HttpConnectionError(statusCode));
        if (quiet) {
            logger.debug(message);
        } else {
            logger.warn(message);
        }
        return false;
    }

    public static Boolean isPluginEnabled(IGerritHudsonTriggerConfig config, String pluginName) {
        return GerritPluginChecker.isPluginEnabled(config, pluginName, false);
    }

    public static Boolean isPluginEnabled(IGerritHudsonTriggerConfig config, String pluginName, boolean quiet) {
        String restUrl = GerritPluginChecker.buildURL(config);
        if (restUrl == null) {
            if (quiet) {
                logger.debug(Messages.PluginInstalledRESTApiNull(pluginName));
            } else {
                logger.warn(Messages.PluginInstalledRESTApiNull(pluginName));
            }
            return false;
        }
        logger.trace("{}plugins/{}/", (Object)restUrl, (Object)pluginName);
        CloseableHttpResponse execute = null;
        try {
            execute = HttpUtils.performHTTPGet(config, restUrl + "plugins/" + pluginName + "/");
            int statusCode = execute.getStatusLine().getStatusCode();
            logger.debug("status code: {}", (Object)statusCode);
            return GerritPluginChecker.decodeStatus(statusCode, pluginName, quiet);
        }
        catch (Exception e) {
            logger.warn(Messages.PluginHttpConnectionGeneralError(pluginName, e.getMessage()), (Throwable)e);
            if (execute != null) {
                try {
                    execute.close();
                }
                catch (Exception exp) {
                    logger.trace("Error happened when close http client.", (Throwable)exp);
                }
            }
            return null;
        }
    }
}

