/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public class TriggeredItemEntity {
    private Integer buildNumber;
    private String projectId;
    private transient Job project;
    private transient Run build;

    public TriggeredItemEntity(Integer buildNumber, String projectId) {
        this.buildNumber = buildNumber;
        this.projectId = projectId;
    }

    public TriggeredItemEntity(Job project, Run build) {
        this.setProject(project);
        this.setBuild(build);
    }

    public TriggeredItemEntity(Run build) {
        this.setProject(build.getParent());
        this.setBuild(build);
    }

    public TriggeredItemEntity(Job project) {
        this.setProject(project);
        this.buildNumber = null;
    }

    public TriggeredItemEntity() {
    }

    public boolean hasBuild() {
        return this.buildNumber != null;
    }

    @WithBridgeMethods(value={AbstractBuild.class})
    public Run getBuild() {
        if (this.build == null && this.buildNumber != null) {
            this.getProject();
            if (this.project != null) {
                this.build = this.project.getBuildByNumber(this.buildNumber.intValue());
            }
        }
        return this.build;
    }

    public void setBuild(Run build) {
        this.build = build;
        this.buildNumber = build.getNumber();
    }

    @WithBridgeMethods(value={AbstractProject.class})
    public Job getProject() {
        if (this.project == null) {
            this.project = (Job)Jenkins.getInstance().getItemByFullName(this.projectId, Job.class);
        }
        return this.project;
    }

    public void setProject(Job project) {
        this.project = project;
        this.projectId = project.getFullName();
    }

    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(Integer buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TriggeredItemEntity other = (TriggeredItemEntity)obj;
        if (!(this.buildNumber == other.buildNumber || this.buildNumber != null && this.buildNumber.equals(other.buildNumber))) {
            return false;
        }
        return !(this.projectId == null ? other.projectId != null : !this.projectId.equals(other.projectId));
    }

    public boolean isSameBuild(int otherBuildNumber, String otherParentName) {
        return this.buildNumber != null && this.buildNumber == otherBuildNumber && this.projectId.equals(otherParentName);
    }

    @Deprecated
    public boolean equals(@Nonnull Run aBuild) {
        return this.isSameBuild(aBuild.getNumber(), aBuild.getParent().getFullName());
    }

    public boolean equals(String aProjectFullname) {
        return this.projectId.equals(aProjectFullname);
    }

    @Deprecated
    public boolean equals(Job other) {
        return this.equals(other.getFullName());
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.buildNumber != null ? this.buildNumber.hashCode() : 0);
        hash = 47 * hash + (this.projectId != null ? this.projectId.hashCode() : 0);
        return hash;
    }
}

