/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.lifecycle.GerritEventLifecycle;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.BadgeAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritManualCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerParameters;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritUserCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.RetriggerAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.RetriggerAllAction;
import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefUpdated;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Future;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventListener
implements GerritEventListener {
    private static final Logger logger = LoggerFactory.getLogger(EventListener.class);
    private final String job;
    private static volatile ParametersActionInspection parametersInspectionCache = null;

    EventListener(@Nonnull Job job) {
        this(job.getFullName());
    }

    EventListener(@Nonnull String fullName) {
        this.job = fullName;
    }

    public String getJob() {
        return this.job;
    }

    public void gerritEvent(GerritEvent event) {
        GerritTriggeredEvent triggeredEvent;
        logger.trace("event: {}", (Object)event);
        GerritTrigger t = this.getTrigger();
        if (t == null) {
            logger.warn("Couldn't find a configured trigger for {}", (Object)this.job);
            return;
        }
        if (event instanceof GerritTriggeredEvent && t.isInteresting(triggeredEvent = (GerritTriggeredEvent)event)) {
            logger.trace("The event is interesting.");
            this.notifyOnTriggered(t, triggeredEvent);
            this.schedule(t, new GerritCause(triggeredEvent, t.isSilentMode()), triggeredEvent);
        }
    }

    public void gerritEvent(ManualPatchsetCreated event) {
        logger.trace("event: {}", (Object)event);
        GerritTrigger t = this.getTrigger();
        if (t == null) {
            logger.warn("Couldn't find a configured trigger for {}", (Object)this.job);
            return;
        }
        if (t.isInteresting((GerritTriggeredEvent)event)) {
            logger.trace("The event is interesting.");
            this.notifyOnTriggered(t, (GerritTriggeredEvent)event);
            this.schedule(t, new GerritManualCause(event, t.isSilentMode()), (GerritTriggeredEvent)event);
        }
    }

    public void gerritEvent(CommentAdded event) {
        logger.trace("event: {}", (Object)event);
        GerritTrigger t = this.getTrigger();
        if (t == null) {
            logger.warn("Couldn't find a configured trigger for {}", (Object)this.job);
            return;
        }
        ToGerritRunListener listener = ToGerritRunListener.getInstance();
        if (listener != null && listener.isBuilding(t.getJob(), (GerritTriggeredEvent)event)) {
            logger.trace("Already building.");
            return;
        }
        if (t.isInteresting((GerritTriggeredEvent)event) && t.commentAddedMatch(event)) {
            logger.trace("The event is interesting.");
            this.notifyOnTriggered(t, (GerritTriggeredEvent)event);
            this.schedule(t, new GerritCause((GerritTriggeredEvent)event, t.isSilentMode()), (GerritTriggeredEvent)event);
        }
    }

    protected void schedule(GerritTrigger t, GerritCause cause, GerritTriggeredEvent event) {
        this.schedule(t, cause, event, t.getJob());
    }

    protected void schedule(GerritTrigger t, GerritCause cause, GerritTriggeredEvent event, Job project) {
        ParameterizedJobMixIn.ParameterizedJob abstractProject;
        BadgeAction badgeAction = new BadgeAction(event);
        int projectbuildDelay = t.getBuildScheduleDelay();
        if (cause instanceof GerritUserCause) {
            projectbuildDelay = 0;
        } else if (project instanceof ParameterizedJobMixIn.ParameterizedJob && (abstractProject = (ParameterizedJobMixIn.ParameterizedJob)project).getQuietPeriod() > projectbuildDelay) {
            projectbuildDelay = abstractProject.getQuietPeriod();
        }
        ParametersAction parameters = this.createParameters(event, project);
        if (!(project instanceof ParameterizedJobMixIn.ParameterizedJob)) {
            throw new IllegalStateException("Unexpected error. Unsupported Job type for Gerrit Trigger: " + project.getClass().getName());
        }
        Future futureBuild = this.schedule(project, projectbuildDelay, cause, badgeAction, parameters);
        IGerritHudsonTriggerConfig serverConfig = PluginImpl.getServerConfig(event);
        if (event instanceof ChangeBasedEvent) {
            ChangeBasedEvent changeBasedEvent = (ChangeBasedEvent)event;
            if (serverConfig != null && serverConfig.isGerritBuildCurrentPatchesOnly()) {
                t.getRunningJobs().scheduled(changeBasedEvent);
            }
            if (null != changeBasedEvent.getPatchSet()) {
                logger.info("Project {} Build Scheduled: {} By event: {}", new Object[]{project.getName(), futureBuild != null, changeBasedEvent.getChange().getNumber() + "/" + changeBasedEvent.getPatchSet().getNumber()});
            } else {
                logger.info("Project {} Build Scheduled: {} By event: {}", new Object[]{project.getName(), futureBuild != null, changeBasedEvent.getChange().getNumber()});
            }
        } else if (event instanceof RefUpdated) {
            RefUpdated refUpdated = (RefUpdated)event;
            logger.info("Project {} Build Scheduled: {} By event: {}", new Object[]{project.getName(), futureBuild != null, refUpdated.getRefUpdate().getRefName() + " " + refUpdated.getRefUpdate().getNewRev()});
        }
    }

    protected Future schedule(final Job theJob, int quitePeriod, GerritCause cause, BadgeAction badgeAction, ParametersAction parameters) {
        ParameterizedJobMixIn jobMixIn = new ParameterizedJobMixIn(){

            protected Job asJob() {
                return theJob;
            }
        };
        return jobMixIn.scheduleBuild2(quitePeriod, new Action[]{new CauseAction((Cause)cause), badgeAction, new RetriggerAction(cause.getContext()), new RetriggerAllAction(cause.getContext()), parameters});
    }

    protected ParametersAction createParameters(GerritTriggeredEvent event, Job project) {
        List<ParameterValue> parameters = this.getDefaultParametersValues(project);
        GerritTriggerParameters.setOrCreateParameters(event, project, parameters);
        try {
            Constructor constructor = ParametersAction.class.getConstructor(List.class, Collection.class);
            return (ParametersAction)constructor.newInstance(parameters, GerritTriggerParameters.getNamesSet());
        }
        catch (NoSuchMethodException e) {
            ParametersActionInspection inspection = EventListener.getParametersInspection();
            if (inspection.isInspectionFailure()) {
                logger.warn("Failed to inspect ParametersAction to determine if we can behave normally around SECURITY-170.\nSee https://wiki.jenkins-ci.org/display/SECURITY/Jenkins+Security+Advisory+2016-05-11 for information.");
            } else if (inspection.isHasSafeParameterConfig()) {
                StringBuilder txt = new StringBuilder("Running on a core with SECURITY-170 fixed but no direct way for Gerrit Trigger to self-specify safe parameters.");
                txt.append(" You should consider upgrading to a new Jenkins core version.\n");
                if (inspection.isKeepUndefinedParameters()) {
                    txt.append(".keepUndefinedParameters is set so the trigger should behave normally.");
                } else if (inspection.isSafeParametersSet()) {
                    txt.append("All Gerrit related parameters are set in .safeParameters");
                    txt.append(" so the trigger should behave normally.");
                } else {
                    txt.append("No overriding system properties appears to be set,");
                    txt.append(" your builds might not work as expected.\n");
                    txt.append("See https://wiki.jenkins-ci.org/display/SECURITY/Jenkins+Security+Advisory+2016-05-11");
                    txt.append(" for information.");
                }
                logger.warn(txt.toString());
            } else {
                logger.debug("Running on an old core before safe parameters, we should be safe.", (Throwable)e);
            }
        }
        catch (IllegalAccessException e) {
            logger.warn("Running on a core with safe parameters fix available, but not allowed to specify them", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Running on a core with safe parameters fix available, but failed to provide them", (Throwable)e);
        }
        return new ParametersAction(parameters);
    }

    private List<ParameterValue> getDefaultParametersValues(Job project) {
        ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
        if (paramDefProp == null) {
            return defValues;
        }
        for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
            ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
            if (defaultValue == null) continue;
            defValues.add(defaultValue);
        }
        return defValues;
    }

    private void notifyOnTriggered(GerritTrigger t, GerritTriggeredEvent event) {
        if (!t.isSilentMode()) {
            ToGerritRunListener listener = ToGerritRunListener.getInstance();
            if (listener != null) {
                listener.onTriggered(t.getJob(), event);
            }
        } else if (event instanceof GerritEventLifecycle) {
            ((GerritEventLifecycle)event).fireProjectTriggered(t.getJob());
        }
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public GerritTrigger getTrigger() {
        Job p = this.findJob();
        if (p == null) {
            return null;
        }
        return GerritTrigger.getTrigger(p);
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public Job findJob() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return null;
        }
        return (Job)jenkins.getItemByFullName(this.job, Job.class);
    }

    public int hashCode() {
        return this.job.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof EventListener && ((EventListener)obj).job.equals(this.job);
    }

    private static synchronized ParametersActionInspection getParametersInspection() {
        if (parametersInspectionCache == null) {
            parametersInspectionCache = new ParametersActionInspection();
        }
        return parametersInspectionCache;
    }

    private static class ParametersActionInspection {
        private static final Class<ParametersAction> KLASS = ParametersAction.class;
        private boolean inspectionFailure;
        private boolean safeParametersSet = false;
        private boolean keepUndefinedParameters = false;
        private boolean hasSafeParameterConfig = false;

        ParametersActionInspection() {
            try {
                for (Field field : KLASS.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !field.getName().equals("KEEP_UNDEFINED_PARAMETERS_SYSTEM_PROPERTY_NAME") && !field.getName().equals("SAFE_PARAMETERS_SYSTEM_PROPERTY_NAME")) continue;
                    this.hasSafeParameterConfig = true;
                    break;
                }
                if (this.hasSafeParameterConfig) {
                    String safeParameters;
                    if (Boolean.getBoolean(KLASS.getName() + ".keepUndefinedParameters")) {
                        this.keepUndefinedParameters = true;
                    }
                    if (!StringUtils.isBlank((String)(safeParameters = System.getProperty(KLASS.getName() + ".safeParameters")))) {
                        safeParameters = safeParameters.toUpperCase(Locale.ENGLISH);
                        boolean declared = true;
                        for (GerritTriggerParameters parameter : GerritTriggerParameters.values()) {
                            if (safeParameters.contains(parameter.name())) continue;
                            declared = false;
                            break;
                        }
                        this.safeParametersSet = declared;
                    } else {
                        this.safeParametersSet = false;
                    }
                }
                this.inspectionFailure = false;
            }
            catch (Exception e) {
                this.inspectionFailure = true;
            }
        }

        boolean isSafeParametersSet() {
            return this.safeParametersSet;
        }

        boolean isKeepUndefinedParameters() {
            return this.keepUndefinedParameters;
        }

        boolean isHasSafeParameterConfig() {
            return this.hasSafeParameterConfig;
        }

        public boolean isInspectionFailure() {
            return this.inspectionFailure;
        }
    }
}

