/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.config;

import com.sonyericsson.hudson.plugins.gerrit.trigger.replication.ReplicationCache;
import com.sonymobile.tools.gerrit.gerritevents.workers.GerritWorkersConfig;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class PluginConfig
implements GerritWorkersConfig {
    public static final int DEFAULT_NR_OF_RECEIVING_WORKER_THREADS = 3;
    public static final int DEFAULT_NR_OF_SENDING_WORKER_THREADS = 1;
    private int numberOfReceivingWorkerThreads;
    private int numberOfSendingWorkerThreads;
    private int replicationCacheExpirationInMinutes;

    public PluginConfig() {
        this(new JSONObject(false));
    }

    public PluginConfig(JSONObject formData) {
        this.setValues(formData);
    }

    public PluginConfig(PluginConfig pluginConfig) {
        this.numberOfReceivingWorkerThreads = pluginConfig.getNumberOfReceivingWorkerThreads();
        this.numberOfSendingWorkerThreads = pluginConfig.getNumberOfSendingWorkerThreads();
        this.replicationCacheExpirationInMinutes = pluginConfig.getReplicationCacheExpirationInMinutes();
    }

    public PluginConfig(JSONObject formData, StaplerRequest req) {
        this(formData);
    }

    public void setValues(JSONObject formData) {
        this.numberOfReceivingWorkerThreads = formData.optInt("numberOfReceivingWorkerThreads", 3);
        if (this.numberOfReceivingWorkerThreads <= 0) {
            this.numberOfReceivingWorkerThreads = 3;
        }
        this.numberOfSendingWorkerThreads = formData.optInt("numberOfSendingWorkerThreads", 1);
        if (this.numberOfSendingWorkerThreads <= 0) {
            this.numberOfSendingWorkerThreads = 1;
        }
        this.replicationCacheExpirationInMinutes = formData.optInt("replicationCacheExpirationInMinutes", ReplicationCache.DEFAULT_EXPIRATION_IN_MINUTES);
        if (this.replicationCacheExpirationInMinutes <= 0) {
            this.replicationCacheExpirationInMinutes = ReplicationCache.DEFAULT_EXPIRATION_IN_MINUTES;
        }
    }

    public int getNumberOfReceivingWorkerThreads() {
        if (this.numberOfReceivingWorkerThreads <= 0) {
            this.numberOfReceivingWorkerThreads = 3;
        }
        return this.numberOfReceivingWorkerThreads;
    }

    public void setNumberOfReceivingWorkerThreads(int numberOfReceivingWorkerThreads) {
        this.numberOfReceivingWorkerThreads = numberOfReceivingWorkerThreads;
    }

    public int getNumberOfSendingWorkerThreads() {
        if (this.numberOfSendingWorkerThreads <= 0) {
            this.numberOfSendingWorkerThreads = 1;
        }
        return this.numberOfSendingWorkerThreads;
    }

    public void setNumberOfSendingWorkerThreads(int numberOfSendingWorkerThreads) {
        this.numberOfSendingWorkerThreads = numberOfSendingWorkerThreads;
    }

    public int getReplicationCacheExpirationInMinutes() {
        if (this.replicationCacheExpirationInMinutes <= 0) {
            this.replicationCacheExpirationInMinutes = ReplicationCache.DEFAULT_EXPIRATION_IN_MINUTES;
        }
        return this.replicationCacheExpirationInMinutes;
    }

    public void setReplicationCacheExpirationInMinutes(int replicationCacheExpirationInMinutes) {
        this.replicationCacheExpirationInMinutes = replicationCacheExpirationInMinutes;
    }
}

