/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.Config;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.PluginConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics.Diagnostics;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritAdministrativeMonitor;
import com.sonymobile.tools.gerrit.gerritevents.GerritSendCommandQueue;
import com.sonymobile.tools.gerrit.gerritevents.workers.GerritWorkersConfig;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.AdministrativeMonitor;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.ModelObject;
import hudson.model.Saveable;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithContextMenu;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GerritManagement
extends ManagementLink
implements StaplerProxy,
Describable<GerritManagement>,
Saveable,
ModelObjectWithContextMenu {
    public static final String URL_NAME = "gerrit-trigger";
    private static final Logger logger = LoggerFactory.getLogger(GerritManagement.class);
    private static final Diagnostics DIAGNOSTICS = new Diagnostics();

    public String getIconFileName() {
        return "/plugin/gerrit-trigger/images/icon.png";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getDisplayName() {
        return Messages.DisplayName();
    }

    public String getDescription() {
        return Messages.PluginDescription();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        Jenkins jenkins = Jenkins.getInstance();
        assert (jenkins != null);
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        menu.add("newServer", Functions.joinPath((String[])new String[]{jenkins.getRootUrl(), Functions.getResourcePath(), "images", "24x24", "new-package.png"}), Messages.AddNewServer());
        for (GerritServer server : this.getServers()) {
            menu.add((Action)server);
        }
        ModelObjectWithContextMenu.MenuItem item = new ModelObjectWithContextMenu.MenuItem().withUrl("diagnostics").withDisplayName((ModelObject)DIAGNOSTICS).withStockIcon("folder.png");
        item.subMenu = DIAGNOSTICS.getContextMenu("diagnostics");
        menu.add(item);
        return menu;
    }

    public Diagnostics getDiagnostics() {
        return DIAGNOSTICS;
    }

    public List<GerritServer> getServers() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            return Collections.emptyList();
        }
        return plugin.getServers();
    }

    public GerritServer getServer(String encodedServerName) {
        String serverName;
        try {
            serverName = URLDecoder.decode(encodedServerName, "UTF-8");
        }
        catch (Exception ex) {
            serverName = URLDecoder.decode(encodedServerName);
        }
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            return null;
        }
        return plugin.getServer(serverName);
    }

    @JavaScriptMethod
    public JSONObject getServerStatuses() {
        JSONObject root = new JSONObject();
        JSONArray array = new JSONArray();
        for (GerritServer server : PluginImpl.getServers_()) {
            String status = server.isConnected() ? "up" : "down";
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)server.getName());
            obj.put("frontEndUrl", (Object)server.getConfig().getGerritFrontEndUrl());
            obj.put("serverUrl", (Object)server.getUrlName());
            obj.put("version", (Object)server.getGerritVersion());
            obj.put("status", (Object)status);
            obj.put("hasErrors", (Object)server.hasErrors());
            obj.put("hasWarnings", (Object)server.hasWarnings());
            array.add((Object)obj);
        }
        root.put("servers", (Object)array);
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GerritServer doAddNewServer(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String serverName = req.getParameter("name");
        PluginImpl plugin = PluginImpl.getInstance();
        assert (plugin != null);
        if (plugin.containsServer(serverName)) {
            throw new Failure("A server already exists with the name '" + serverName + "'");
        }
        if ("__ANY__".equals(serverName)) {
            throw new Failure("Illegal server name '" + serverName + "'");
        }
        GerritServer server = new GerritServer(serverName);
        PluginConfig pluginConfig = plugin.getPluginConfig();
        server.getConfig().setNumberOfSendingWorkerThreads(pluginConfig.getNumberOfSendingWorkerThreads());
        String mode = req.getParameter("mode");
        if (mode != null && mode.equals("copy")) {
            String from = req.getParameter("from");
            GerritServer fromServer = plugin.getServer(from);
            if (fromServer == null) throw new Failure("Server '" + from + "' does not exist!");
            server.setConfig(new Config(fromServer.getConfig()));
            plugin.addServer(server);
            server.start();
        } else {
            plugin.addServer(server);
            server.start();
        }
        plugin.save();
        rsp.sendRedirect("./server/" + URLEncoder.encode(serverName, "UTF-8"));
        return server;
    }

    public Object getTarget() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins is not alive.");
        }
        jenkins.checkPermission(Jenkins.ADMINISTER);
        return this;
    }

    public void save() throws IOException {
        logger.debug("SAVE!!!");
    }

    public static GerritManagement get() {
        return (GerritManagement)((Object)ManagementLink.all().get(GerritManagement.class));
    }

    @CheckForNull
    public static PluginConfig getPluginConfig() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            return null;
        }
        return plugin.getPluginConfig();
    }

    public static IGerritHudsonTriggerConfig getConfig(String serverName) {
        GerritServer server = PluginImpl.getServer_(serverName);
        if (server != null) {
            return server.getConfig();
        }
        logger.error("Could not find the Gerrit Server: {}", (Object)serverName);
        return null;
    }

    public GerritAdministrativeMonitor getAdministrativeMonitor() {
        for (AdministrativeMonitor monitor : AdministrativeMonitor.all()) {
            if (!(monitor instanceof GerritAdministrativeMonitor)) continue;
            return (GerritAdministrativeMonitor)monitor;
        }
        return null;
    }

    public List<String> getServerNames() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            return Collections.emptyList();
        }
        return plugin.getServerNames();
    }

    public FormValidation doNameFreeCheck(@QueryParameter(value="value") String value) {
        PluginImpl plugin = PluginImpl.getInstance();
        assert (plugin != null);
        if (plugin.containsServer(value)) {
            return FormValidation.error((String)("The server name " + value + " is already in use!"));
        }
        if ("__ANY__".equals(value)) {
            return FormValidation.error((String)("Illegal name " + value + "!"));
        }
        return FormValidation.ok();
    }

    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException {
        if (logger.isDebugEnabled()) {
            logger.debug("submit {}", (Object)req.toString());
        }
        JSONObject form = req.getSubmittedForm();
        PluginConfig pluginConfig = PluginImpl.getPluginConfig_();
        if (pluginConfig != null) {
            pluginConfig.setValues(form);
            PluginImpl.save_();
            GerritSendCommandQueue.configure((GerritWorkersConfig)pluginConfig);
        }
        rsp.sendRedirect(".");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GerritManagement> {
        public String getDisplayName() {
            return null;
        }

        public static DescriptorExtensionList<GerritServer, GerritServer.DescriptorImpl> serverDescriptorList() {
            Jenkins jenkins = Jenkins.getInstance();
            assert (jenkins != null);
            return jenkins.getDescriptorList(GerritServer.class);
        }

        public AutoCompletionCandidates doAutoCompleteCopyNewItemFrom(@QueryParameter String value) {
            AutoCompletionCandidates r = new AutoCompletionCandidates();
            PluginImpl plugin = PluginImpl.getInstance();
            if (plugin != null) {
                for (String s : plugin.getServerNames()) {
                    if (!s.startsWith(value)) continue;
                    r.add(s);
                }
            }
            return r;
        }
    }
}

