/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.utils;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.HttpUtils;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritPluginChecker {
    private static final Logger logger = LoggerFactory.getLogger(GerritPluginChecker.class);

    private GerritPluginChecker() {
    }

    private static String buildURL(IGerritHudsonTriggerConfig config) {
        String gerritFrontEndUrl;
        if (config == null) {
            throw new IllegalArgumentException("Gerrit Server Configuration cannot be null");
        }
        if (!config.isUseRestApi()) {
            logger.warn("REST API is not enabled.");
            return null;
        }
        String restUrl = gerritFrontEndUrl = config.getGerritFrontEndUrl();
        if (gerritFrontEndUrl != null && !gerritFrontEndUrl.endsWith("/")) {
            restUrl = gerritFrontEndUrl + "/";
        }
        return restUrl;
    }

    private static boolean decodeStatus(int statusCode, String pluginName) {
        switch (statusCode) {
            case 200: {
                logger.info(Messages.PluginInstalled(pluginName));
                return true;
            }
            case 404: {
                logger.info(Messages.PluginNotInstalled(pluginName));
                return false;
            }
            case 401: {
                logger.warn(Messages.PluginHttpConnectionUnauthorized(pluginName, Messages.HttpConnectionUnauthorized()));
                return false;
            }
            case 403: {
                logger.warn(Messages.PluginHttpConnectionForbidden(pluginName, Messages.HttpConnectionUnauthorized()));
                return false;
            }
        }
        logger.warn(Messages.PluginHttpConnectionGeneralError(pluginName, Messages.HttpConnectionError(statusCode)));
        return false;
    }

    public static boolean isPluginEnabled(IGerritHudsonTriggerConfig config, String pluginName) {
        String restUrl = GerritPluginChecker.buildURL(config);
        if (restUrl == null) {
            logger.warn(Messages.PluginInstalledRESTApiNull(pluginName));
            return false;
        }
        logger.trace("{}plugins/{}/", (Object)restUrl, (Object)pluginName);
        HttpResponse execute = null;
        try {
            execute = HttpUtils.performHTTPGet(config, restUrl + "plugins/" + pluginName + "/");
        }
        catch (IOException e) {
            logger.warn(Messages.PluginHttpConnectionGeneralError(pluginName, e.getMessage()), (Throwable)e);
            return false;
        }
        int statusCode = execute.getStatusLine().getStatusCode();
        logger.debug("status code: {}", (Object)statusCode);
        return GerritPluginChecker.decodeStatus(statusCode, pluginName);
    }
}

