/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.replication;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.PluginConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritSlave;
import com.sonyericsson.hudson.plugins.gerrit.trigger.replication.ReplicationCache;
import com.sonyericsson.hudson.plugins.gerrit.trigger.replication.ReplicationFailedAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.replication.WaitingForReplication;
import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import com.sonymobile.tools.gerrit.gerritevents.GerritHandler;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.RepositoryModifiedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.PatchSet;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefReplicated;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefUpdated;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class ReplicationQueueTaskDispatcher
extends QueueTaskDispatcher
implements GerritEventListener {
    private static final Logger logger = LoggerFactory.getLogger(ReplicationQueueTaskDispatcher.class);
    private final Map<Integer, BlockedItem> blockedItems = new ConcurrentHashMap<Integer, BlockedItem>();
    private final ReplicationCache replicationCache;

    public ReplicationQueueTaskDispatcher() {
        this(PluginImpl.getHandler_(), ReplicationQueueTaskDispatcher.createDefaultCache());
    }

    @Nonnull
    private static ReplicationCache createDefaultCache() {
        PluginConfig config = PluginImpl.getPluginConfig_();
        int expiration = ReplicationCache.DEFAULT_EXPIRATION_IN_MINUTES;
        if (config != null) {
            expiration = config.getReplicationCacheExpirationInMinutes();
        }
        return ReplicationCache.Factory.createCache(expiration, TimeUnit.MINUTES);
    }

    ReplicationQueueTaskDispatcher(@CheckForNull GerritHandler gerritHandler, @Nonnull ReplicationCache replicationCache) {
        this.replicationCache = replicationCache;
        if (gerritHandler != null) {
            logger.warn("No GerritHandler was specified, won't register as event listener, so no function.");
            gerritHandler.addListener((GerritEventListener)this);
        }
        this.replicationCache.setCreationTime(new Date().getTime());
        logger.debug("Registered to gerrit events");
    }

    public CauseOfBlockage canRun(Queue.Item item) {
        if (item.isBuildable()) {
            return null;
        }
        Integer itemId = item.id;
        if (this.blockedItems.containsKey(itemId)) {
            BlockedItem blockedItem = this.blockedItems.get(itemId);
            if (blockedItem.canRunWithTimeoutCheck()) {
                if (blockedItem.replicationFailedMessage != null) {
                    item.addAction((Action)new ReplicationFailedAction(blockedItem.replicationFailedMessage));
                    logger.trace("{} -> {}", (Object)blockedItem.getEventDescription(), (Object)blockedItem.replicationFailedMessage);
                } else {
                    logger.trace("{} can now run with no timeout check.", (Object)blockedItem.getEventDescription());
                }
                this.blockedItems.remove(itemId);
                return null;
            }
            logger.trace(blockedItem.getEventDescription() + " (item id {}) is still waiting replication to {} gerrit slaves (waiting " + item.getInQueueForString() + ")", (Object)itemId, (Object)blockedItem.slavesWaitingFor.size());
            return new WaitingForReplication(blockedItem.slavesWaitingFor.values());
        }
        BlockedItem blockedItem = this.getBlockedItem(item);
        if (blockedItem != null) {
            this.updateFromReplicationCache(blockedItem);
            this.blockedItems.put(itemId, blockedItem);
            return this.canRun(item);
        }
        logger.debug("blockedItem null for {}!", (Object)item.id);
        return null;
    }

    private void updateFromReplicationCache(BlockedItem blockedItem) {
        Iterator it = blockedItem.slavesWaitingFor.values().iterator();
        while (it.hasNext()) {
            RefReplicated refReplicated = this.replicationCache.getIfPresent(blockedItem.gerritServer, blockedItem.gerritProject, blockedItem.ref, ((GerritSlave)((Object)it.next())).getHost());
            if (refReplicated == null) continue;
            blockedItem.processRefReplicatedEvent(refReplicated);
            logger.trace("processed a replication event from the cache, remaining number of events waiting for: {}", (Object)blockedItem.slavesWaitingFor.size());
        }
    }

    private String getEventDescription(GerritEvent evt) {
        String eventType = evt.getEventType().name();
        String projAndRef = "";
        if (evt instanceof RepositoryModifiedEvent) {
            projAndRef = " => " + ((RepositoryModifiedEvent)evt).getModifiedProject() + " -> " + ((RepositoryModifiedEvent)evt).getModifiedRef();
        }
        return "Event " + eventType + projAndRef;
    }

    private BlockedItem getBlockedItem(Queue.Item item) {
        GerritCause gerritCause = this.getGerritCause(item);
        if (gerritCause == null) {
            logger.trace("Gerrit Cause null for item: {} !", (Object)item.id);
            return null;
        }
        if (gerritCause.getEvent() != null && gerritCause.getEvent() instanceof RepositoryModifiedEvent && item.task instanceof Job) {
            PatchSet patchset;
            GerritTrigger gerritTrigger = GerritTrigger.getTrigger((Job)item.task);
            if (gerritTrigger == null) {
                logger.trace("Gerrit Trigger null for item: {} !", (Object)item.id);
                return null;
            }
            String gerritServer = null;
            if (gerritCause.getEvent().getProvider() != null) {
                gerritServer = gerritCause.getEvent().getProvider().getName();
            }
            if (gerritServer == null) {
                logger.trace("Gerrit Server null for item: {} !", (Object)item.id);
                return null;
            }
            RepositoryModifiedEvent repositoryModifiedEvent = (RepositoryModifiedEvent)gerritCause.getEvent();
            String eventDesc = this.getEventDescription((GerritEvent)gerritCause.getEvent());
            logger.debug(eventDesc);
            Date createdOnDate = null;
            if (repositoryModifiedEvent instanceof ChangeBasedEvent && (patchset = ((ChangeBasedEvent)repositoryModifiedEvent).getPatchSet()) != null) {
                createdOnDate = patchset.getCreatedOn();
            }
            if (this.replicationCache.isExpired(gerritCause.getEvent().getReceivedOn())) {
                logger.trace(eventDesc + " has expired");
                return null;
            }
            List<GerritSlave> slaves = gerritTrigger.gerritSlavesToWaitFor(gerritServer);
            if (!slaves.isEmpty()) {
                if (repositoryModifiedEvent.getModifiedProject() == null || repositoryModifiedEvent.getModifiedRef() == null) {
                    return null;
                }
                if (createdOnDate != null && this.replicationCache.isExpired(createdOnDate.getTime())) {
                    logger.trace("{} has expired compared to createdOn date of patchset", (Object)eventDesc);
                    return null;
                }
                boolean useTimestampWhenProcessingRefReplicatedEvent = false;
                if (gerritCause.getEvent() instanceof RefUpdated) {
                    useTimestampWhenProcessingRefReplicatedEvent = true;
                }
                logger.debug(eventDesc + " is blocked");
                return new BlockedItem(repositoryModifiedEvent.getModifiedProject(), repositoryModifiedEvent.getModifiedRef(), gerritServer, slaves, gerritCause.getEvent().getReceivedOn(), eventDesc, useTimestampWhenProcessingRefReplicatedEvent);
            }
        }
        return null;
    }

    private GerritCause getGerritCause(Queue.Item item) {
        for (Cause cause : item.getCauses()) {
            if (!cause.getClass().equals(GerritCause.class)) continue;
            return (GerritCause)cause;
        }
        return null;
    }

    public void gerritEvent(GerritEvent event) {
    }

    public void gerritEvent(RefReplicated refReplicated) {
        this.replicationCache.put(refReplicated);
        boolean queueMaintenanceRequired = false;
        for (BlockedItem blockedItem : this.blockedItems.values()) {
            if (blockedItem.canRun) continue;
            blockedItem.processRefReplicatedEvent(refReplicated);
            if (!blockedItem.canRun) continue;
            queueMaintenanceRequired = true;
        }
        if (queueMaintenanceRequired) {
            Queue.getInstance().maintain();
        }
    }

    private static class BlockedItem {
        private String gerritProject;
        private String ref;
        private String gerritServer;
        private ConcurrentMap<String, GerritSlave> slavesWaitingFor;
        private boolean canRun = false;
        private long eventTimeStamp;
        private String eventDescription;
        private String replicationFailedMessage;
        private boolean useTimestampWhenProcessingRefReplicatedEvent = false;

        public BlockedItem(String gerritProject, String ref, String gerritServer, List<GerritSlave> gerritSlaves, long eventTimeStamp, String eventDescription, boolean useTimestampWhenProcessingRefReplicatedEvent) {
            this.gerritProject = gerritProject;
            this.ref = ref;
            this.gerritServer = gerritServer;
            this.slavesWaitingFor = new ConcurrentHashMap<String, GerritSlave>(gerritSlaves.size());
            for (GerritSlave gerritSlave : gerritSlaves) {
                this.slavesWaitingFor.put(gerritSlave.getHost(), gerritSlave);
            }
            this.eventTimeStamp = eventTimeStamp;
            this.eventDescription = eventDescription;
            this.useTimestampWhenProcessingRefReplicatedEvent = useTimestampWhenProcessingRefReplicatedEvent;
        }

        public String getEventDescription() {
            return this.eventDescription;
        }

        public boolean canRunWithTimeoutCheck() {
            if (this.canRun) {
                return true;
            }
            for (GerritSlave slave : this.slavesWaitingFor.values()) {
                if (slave.getTimeoutInSeconds() == 0 || TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.eventTimeStamp) <= (long)slave.getTimeoutInSeconds()) continue;
                this.replicationFailedMessage = Messages.WaitingForReplicationTimeout(this.ref, slave.getName());
                return true;
            }
            return false;
        }

        public void processRefReplicatedEvent(RefReplicated refReplicated) {
            if (this.canRun || refReplicated.getProvider() == null) {
                return;
            }
            if (this.gerritProject.equals(refReplicated.getProject()) && this.gerritServer.equals(refReplicated.getProvider().getName()) && this.ref.equals(refReplicated.getRef()) && this.slavesWaitingFor.containsKey(refReplicated.getTargetNode())) {
                if (this.useTimestampWhenProcessingRefReplicatedEvent && this.eventTimeStamp >= refReplicated.getReceivedOn()) {
                    logger.trace("Using timestamp and event tstamp is: {} and ref-event tstamp is: {}. Ignoring", (Object)this.eventTimeStamp, (Object)refReplicated.getReceivedOn());
                    return;
                }
                if (refReplicated.getStatus().equals("succeeded")) {
                    logger.debug("Received successful refReplicated event for {} for slave {}", (Object)this.getEventDescription(), (Object)refReplicated.getTargetNode());
                    this.slavesWaitingFor.remove(refReplicated.getTargetNode());
                }
                if (this.slavesWaitingFor.size() == 0) {
                    logger.debug("No more slaves to wait for ({})", (Object)this.getEventDescription());
                    this.canRun = true;
                }
            }
        }
    }
}

