/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.parameters.Base64EncodedStringParameterValue;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Account;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeAbandoned;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeRestored;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefUpdated;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import hudson.model.TextParameterValue;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GerritTriggerParameters {
    GERRIT_CHANGE_SUBJECT,
    GERRIT_CHANGE_COMMIT_MESSAGE,
    GERRIT_BRANCH,
    GERRIT_TOPIC,
    GERRIT_CHANGE_ID,
    GERRIT_CHANGE_NUMBER,
    GERRIT_CHANGE_URL,
    GERRIT_PATCHSET_NUMBER,
    GERRIT_PATCHSET_REVISION,
    GERRIT_PROJECT,
    GERRIT_REFSPEC,
    GERRIT_CHANGE_ABANDONER,
    GERRIT_CHANGE_ABANDONER_NAME,
    GERRIT_CHANGE_ABANDONER_EMAIL,
    GERRIT_CHANGE_OWNER,
    GERRIT_CHANGE_OWNER_NAME,
    GERRIT_CHANGE_OWNER_EMAIL,
    GERRIT_CHANGE_RESTORER,
    GERRIT_CHANGE_RESTORER_NAME,
    GERRIT_CHANGE_RESTORER_EMAIL,
    GERRIT_PATCHSET_UPLOADER,
    GERRIT_PATCHSET_UPLOADER_NAME,
    GERRIT_PATCHSET_UPLOADER_EMAIL,
    GERRIT_EVENT_ACCOUNT,
    GERRIT_EVENT_ACCOUNT_NAME,
    GERRIT_EVENT_ACCOUNT_EMAIL,
    GERRIT_REFNAME,
    GERRIT_OLDREV,
    GERRIT_NEWREV,
    GERRIT_SUBMITTER,
    GERRIT_SUBMITTER_NAME,
    GERRIT_SUBMITTER_EMAIL,
    GERRIT_NAME,
    GERRIT_HOST,
    GERRIT_PORT,
    GERRIT_SCHEME,
    GERRIT_VERSION,
    GERRIT_EVENT_HASH,
    GERRIT_EVENT_TYPE;

    private static final Logger logger;

    private void setOrCreateParameterValue(List<ParameterValue> parameters, String value, boolean escapeQuotes, Class<? extends StringParameterValue> clazz) {
        String stringValue;
        ParameterValue parameter = null;
        for (ParameterValue p : parameters) {
            if (!p.getName().toUpperCase().equals(this.name())) continue;
            parameter = p;
            break;
        }
        String description = null;
        if (parameter != null) {
            if (parameter instanceof StringParameterValue) {
                description = parameter.getDescription();
            }
            parameters.remove(parameter);
        }
        if ((stringValue = escapeQuotes ? StringUtil.escapeQuotes(value) : value) == null) {
            stringValue = "";
        }
        Class[] types = new Class[]{String.class, String.class, String.class};
        Object[] args = new Object[]{this.name(), stringValue, description};
        try {
            Constructor<? extends StringParameterValue> constructor = clazz.getConstructor(types);
            parameter = (ParameterValue)constructor.newInstance(args);
            parameters.add(parameter);
        }
        catch (ReflectiveOperationException ex) {
            parameter = null;
        }
    }

    public void setOrCreateStringParameterValue(List<ParameterValue> parameters, String value, boolean escapeQuotes) {
        this.setOrCreateParameterValue(parameters, value, escapeQuotes, StringParameterValue.class);
    }

    public void setOrCreateTextParameterValue(List<ParameterValue> parameters, String value, boolean escapeQuotes) {
        this.setOrCreateParameterValue(parameters, value, escapeQuotes, TextParameterValue.class);
    }

    public void setOrCreateBase64EncodedStringParameterValue(List<ParameterValue> parameters, String value, boolean escapeQuotes) {
        this.setOrCreateParameterValue(parameters, value, escapeQuotes, Base64EncodedStringParameterValue.class);
    }

    public static void setOrCreateParameters(GerritTriggeredEvent gerritEvent, List<ParameterValue> parameters) {
        GerritTriggerParameters.setOrCreateParameters(gerritEvent, null, parameters);
    }

    public static void setOrCreateParameters(GerritTriggeredEvent gerritEvent, Job project, List<ParameterValue> parameters) {
        Provider provider;
        ChangeBasedEvent event;
        GerritTrigger trigger;
        boolean noNameAndEmailParameters = false;
        boolean escapeQuotes = false;
        boolean readableMessage = false;
        if (project != null && (trigger = GerritTrigger.getTrigger(project)) != null) {
            noNameAndEmailParameters = trigger.isNoNameAndEmailParameters();
            escapeQuotes = trigger.isEscapeQuotes();
            readableMessage = trigger.isReadableMessage();
        }
        GERRIT_EVENT_TYPE.setOrCreateStringParameterValue(parameters, gerritEvent.getEventType().getTypeValue(), escapeQuotes);
        GERRIT_EVENT_HASH.setOrCreateStringParameterValue(parameters, String.valueOf(gerritEvent.hashCode()), escapeQuotes);
        if (gerritEvent instanceof ChangeBasedEvent) {
            event = (ChangeBasedEvent)gerritEvent;
            GERRIT_BRANCH.setOrCreateStringParameterValue(parameters, event.getChange().getBranch(), escapeQuotes);
            GERRIT_TOPIC.setOrCreateStringParameterValue(parameters, event.getChange().getTopic(), escapeQuotes);
            GERRIT_CHANGE_NUMBER.setOrCreateStringParameterValue(parameters, event.getChange().getNumber(), escapeQuotes);
            GERRIT_CHANGE_ID.setOrCreateStringParameterValue(parameters, event.getChange().getId(), escapeQuotes);
            String pNumber = null;
            if (null != event.getPatchSet()) {
                pNumber = event.getPatchSet().getNumber();
                GERRIT_PATCHSET_NUMBER.setOrCreateStringParameterValue(parameters, pNumber, escapeQuotes);
                GERRIT_PATCHSET_REVISION.setOrCreateStringParameterValue(parameters, event.getPatchSet().getRevision(), escapeQuotes);
                GERRIT_REFSPEC.setOrCreateStringParameterValue(parameters, StringUtil.makeRefSpec(event), escapeQuotes);
            }
            GERRIT_PROJECT.setOrCreateStringParameterValue(parameters, event.getChange().getProject(), escapeQuotes);
            if (event instanceof ChangeRestored) {
                if (!noNameAndEmailParameters) {
                    GERRIT_CHANGE_RESTORER.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getNameAndEmail(((ChangeRestored)event).getRestorer()), escapeQuotes);
                }
                GERRIT_CHANGE_RESTORER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(((ChangeRestored)event).getRestorer()), escapeQuotes);
                GERRIT_CHANGE_RESTORER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(((ChangeRestored)event).getRestorer()), escapeQuotes);
            }
            GERRIT_CHANGE_SUBJECT.setOrCreateStringParameterValue(parameters, event.getChange().getSubject(), escapeQuotes);
            String url = GerritTriggerParameters.getURL(event, project);
            String commitMessage = event.getChange().getCommitMessage();
            if (commitMessage != null) {
                if (readableMessage) {
                    GERRIT_CHANGE_COMMIT_MESSAGE.setOrCreateTextParameterValue(parameters, commitMessage, escapeQuotes);
                } else {
                    try {
                        byte[] encodedBytes = Base64.encodeBase64((byte[])commitMessage.getBytes("UTF-8"));
                        GERRIT_CHANGE_COMMIT_MESSAGE.setOrCreateBase64EncodedStringParameterValue(parameters, new String(encodedBytes, Charset.forName("UTF-8")), escapeQuotes);
                    }
                    catch (UnsupportedEncodingException uee) {
                        logger.error("Failed to encode commit message as Base64: ", (Throwable)uee);
                    }
                }
            }
            GERRIT_CHANGE_URL.setOrCreateStringParameterValue(parameters, url, escapeQuotes);
            if (event instanceof ChangeAbandoned) {
                if (!noNameAndEmailParameters) {
                    GERRIT_CHANGE_ABANDONER.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getNameAndEmail(((ChangeAbandoned)event).getAbandoner()), escapeQuotes);
                }
                GERRIT_CHANGE_ABANDONER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(((ChangeAbandoned)event).getAbandoner()), escapeQuotes);
                GERRIT_CHANGE_ABANDONER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(((ChangeAbandoned)event).getAbandoner()), escapeQuotes);
            }
            if (!noNameAndEmailParameters) {
                GERRIT_CHANGE_OWNER.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getNameAndEmail(event.getChange().getOwner()), escapeQuotes);
            }
            GERRIT_CHANGE_OWNER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(event.getChange().getOwner()), escapeQuotes);
            GERRIT_CHANGE_OWNER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(event.getChange().getOwner()), escapeQuotes);
            Account uploader = GerritTriggerParameters.findUploader(event);
            if (!noNameAndEmailParameters) {
                GERRIT_PATCHSET_UPLOADER.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getNameAndEmail(uploader), escapeQuotes);
            }
            GERRIT_PATCHSET_UPLOADER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(uploader), escapeQuotes);
            GERRIT_PATCHSET_UPLOADER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(uploader), escapeQuotes);
        } else if (gerritEvent instanceof RefUpdated) {
            event = (RefUpdated)gerritEvent;
            GERRIT_REFNAME.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getRefName(), escapeQuotes);
            GERRIT_PROJECT.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getProject(), escapeQuotes);
            GERRIT_OLDREV.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getOldRev(), escapeQuotes);
            GERRIT_NEWREV.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getNewRev(), escapeQuotes);
        }
        Account account = gerritEvent.getAccount();
        if (account != null) {
            if (!noNameAndEmailParameters) {
                GERRIT_EVENT_ACCOUNT.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getNameAndEmail(account), escapeQuotes);
            }
            GERRIT_EVENT_ACCOUNT_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(account), escapeQuotes);
            GERRIT_EVENT_ACCOUNT_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(account), escapeQuotes);
        }
        if ((provider = gerritEvent.getProvider()) != null) {
            GERRIT_NAME.setOrCreateStringParameterValue(parameters, provider.getName(), escapeQuotes);
            GERRIT_HOST.setOrCreateStringParameterValue(parameters, provider.getHost(), escapeQuotes);
            GERRIT_PORT.setOrCreateStringParameterValue(parameters, provider.getPort(), escapeQuotes);
            GERRIT_SCHEME.setOrCreateStringParameterValue(parameters, provider.getScheme(), escapeQuotes);
            GERRIT_VERSION.setOrCreateStringParameterValue(parameters, provider.getVersion(), escapeQuotes);
        }
    }

    private static String getURL(ChangeBasedEvent event, Job project) {
        String name;
        String url = "";
        String serverName = null;
        if (event.getProvider() != null) {
            serverName = event.getProvider().getName();
        } else if (project != null && !"__ANY__".equals(name = GerritTrigger.getTrigger(project).getServerName())) {
            serverName = name;
        }
        GerritServer firstServer = PluginImpl.getFirstServer_();
        if (serverName == null && firstServer != null) {
            logger.warn("No server could be determined from event or project config, defaulting to the first configured server. Event: [{}] Project: [{}]", (Object)event, (Object)project);
            serverName = firstServer.getName();
        } else if (serverName == null) {
            throw new IllegalStateException("Cannot determine a Gerrit server to link to. Have you configured one?");
        }
        GerritServer server = PluginImpl.getServer_(serverName);
        if (server != null) {
            IGerritHudsonTriggerConfig config = server.getConfig();
            if (config != null) {
                url = config.getGerritFrontEndUrlFor((GerritTriggeredEvent)event);
            } else {
                logger.error("Could not find config for Gerrit server {}", (Object)serverName);
            }
        } else {
            logger.error("Could not find Gerrit server {}", (Object)serverName);
        }
        return url;
    }

    private static Account findUploader(ChangeBasedEvent event) {
        if (event.getPatchSet() != null && event.getPatchSet().getUploader() != null) {
            return event.getPatchSet().getUploader();
        }
        return event.getAccount();
    }

    private static String getName(Account account) {
        if (account == null) {
            return "";
        }
        return account.getName();
    }

    private static String getNameAndEmail(Account account) {
        if (account == null) {
            return "";
        }
        return account.getNameAndEmail();
    }

    private static String getEmail(Account account) {
        if (account == null) {
            return "";
        }
        return account.getEmail();
    }

    static {
        logger = LoggerFactory.getLogger(GerritTriggerParameters.class);
    }
}

