/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.VerdictCategory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.Config;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.ReplicationConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.dependency.DependencyQueueTaskDispatcher;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.EventListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritDynamicUrlProcessor;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritProjectList;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerTimerTask;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritUserCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.NewPatchSetInterruption;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.GerritTriggerInformationAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.BuildCancellationPolicy;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.CompareType;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritProject;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritSlave;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.SkipVote;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginCommentAddedContainsEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginCommentAddedEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginDraftPublishedEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginPatchsetCreatedEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.GerritVersionChecker;
import com.sonymobile.tools.gerrit.gerritevents.GerritConnectionConfig2;
import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import com.sonymobile.tools.gerrit.gerritevents.GerritHandler;
import com.sonymobile.tools.gerrit.gerritevents.GerritQueryHandler;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Approval;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefUpdated;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Notify;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritTrigger
extends Trigger<Job> {
    private static final Logger logger = LoggerFactory.getLogger(GerritTrigger.class);
    public static final String JOB_ABORT = GerritTrigger.class.getName() + "_job_abort";
    private transient RunningJobs runningJobs = new RunningJobs();
    private List<GerritProject> gerritProjects;
    private List<GerritProject> dynamicGerritProjects;
    private SkipVote skipVote;
    private Integer gerritBuildStartedVerifiedValue;
    private Integer gerritBuildStartedCodeReviewValue;
    private Integer gerritBuildSuccessfulVerifiedValue;
    private Integer gerritBuildSuccessfulCodeReviewValue;
    private Integer gerritBuildFailedVerifiedValue;
    private Integer gerritBuildFailedCodeReviewValue;
    private Integer gerritBuildUnstableVerifiedValue;
    private Integer gerritBuildUnstableCodeReviewValue;
    private Integer gerritBuildNotBuiltVerifiedValue;
    private Integer gerritBuildNotBuiltCodeReviewValue;
    private boolean silentMode;
    private String notificationLevel;
    private boolean silentStartMode;
    private boolean escapeQuotes;
    private boolean noNameAndEmailParameters;
    private String dependencyJobsNames;
    private boolean readableMessage;
    private String buildStartMessage;
    private String buildFailureMessage;
    private String buildSuccessfulMessage;
    private String buildUnstableMessage;
    private String buildNotBuiltMessage;
    private String buildUnsuccessfulFilepath;
    private String customUrl;
    private String serverName;
    private String gerritSlaveId;
    private List<PluginGerritEvent> triggerOnEvents;
    @Deprecated
    private transient boolean allowTriggeringUnreviewedPatches;
    private boolean dynamicTriggerConfiguration;
    private String triggerConfigURL;
    private GerritTriggerTimerTask gerritTriggerTimerTask;
    private GerritTriggerInformationAction triggerInformationAction;

    @DataBoundConstructor
    public GerritTrigger(List<GerritProject> gerritProjects, SkipVote skipVote, Integer gerritBuildStartedVerifiedValue, Integer gerritBuildStartedCodeReviewValue, Integer gerritBuildSuccessfulVerifiedValue, Integer gerritBuildSuccessfulCodeReviewValue, Integer gerritBuildFailedVerifiedValue, Integer gerritBuildFailedCodeReviewValue, Integer gerritBuildUnstableVerifiedValue, Integer gerritBuildUnstableCodeReviewValue, Integer gerritBuildNotBuiltVerifiedValue, Integer gerritBuildNotBuiltCodeReviewValue, boolean silentMode, boolean silentStartMode, boolean escapeQuotes, boolean noNameAndEmailParameters, boolean readableMessage, String dependencyJobsNames, String buildStartMessage, String buildSuccessfulMessage, String buildUnstableMessage, String buildFailureMessage, String buildNotBuiltMessage, String buildUnsuccessfulFilepath, String customUrl, String serverName, String gerritSlaveId, List<PluginGerritEvent> triggerOnEvents, boolean dynamicTriggerConfiguration, String triggerConfigURL, String notificationLevel) {
        this.gerritProjects = gerritProjects;
        this.skipVote = skipVote;
        this.gerritBuildStartedVerifiedValue = gerritBuildStartedVerifiedValue;
        this.gerritBuildStartedCodeReviewValue = gerritBuildStartedCodeReviewValue;
        this.gerritBuildSuccessfulVerifiedValue = gerritBuildSuccessfulVerifiedValue;
        this.gerritBuildSuccessfulCodeReviewValue = gerritBuildSuccessfulCodeReviewValue;
        this.gerritBuildFailedVerifiedValue = gerritBuildFailedVerifiedValue;
        this.gerritBuildFailedCodeReviewValue = gerritBuildFailedCodeReviewValue;
        this.gerritBuildUnstableVerifiedValue = gerritBuildUnstableVerifiedValue;
        this.gerritBuildUnstableCodeReviewValue = gerritBuildUnstableCodeReviewValue;
        this.gerritBuildNotBuiltVerifiedValue = gerritBuildNotBuiltVerifiedValue;
        this.gerritBuildNotBuiltCodeReviewValue = gerritBuildNotBuiltCodeReviewValue;
        this.silentMode = silentMode;
        this.silentStartMode = silentStartMode;
        this.escapeQuotes = escapeQuotes;
        this.noNameAndEmailParameters = noNameAndEmailParameters;
        this.readableMessage = readableMessage;
        this.dependencyJobsNames = dependencyJobsNames;
        this.buildStartMessage = buildStartMessage;
        this.buildSuccessfulMessage = buildSuccessfulMessage;
        this.buildUnstableMessage = buildUnstableMessage;
        this.buildFailureMessage = buildFailureMessage;
        this.buildNotBuiltMessage = buildNotBuiltMessage;
        this.buildUnsuccessfulFilepath = buildUnsuccessfulFilepath;
        this.customUrl = customUrl;
        this.serverName = serverName;
        this.gerritSlaveId = gerritSlaveId;
        this.triggerOnEvents = triggerOnEvents;
        this.dynamicTriggerConfiguration = dynamicTriggerConfiguration;
        this.triggerConfigURL = triggerConfigURL;
        this.gerritTriggerTimerTask = null;
        this.triggerInformationAction = new GerritTriggerInformationAction();
        this.notificationLevel = notificationLevel;
    }

    Job getJob() {
        return (Job)this.job;
    }

    public Object readResolve() throws ObjectStreamException {
        this.initializeServerName();
        this.initializeTriggerOnEvents();
        return super.readResolve();
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String name) {
        this.serverName = name;
    }

    public String getGerritSlaveId() {
        return this.gerritSlaveId;
    }

    void onJobRenamed(String oldFullName, String newFullName) {
        GerritHandler handler;
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin != null && (handler = plugin.getHandler()) != null) {
            handler.removeListener((GerritEventListener)new EventListener(oldFullName));
            handler.addListener((GerritEventListener)this.createListener());
        }
    }

    public static GerritTrigger getTrigger(@Nullable Job project) {
        if (project == null) {
            return null;
        }
        if (project instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob parameterizedJob = (ParameterizedJobMixIn.ParameterizedJob)project;
            for (Trigger p : parameterizedJob.getTriggers().values()) {
                if (!GerritTrigger.class.isInstance(p)) continue;
                return (GerritTrigger)((Object)GerritTrigger.class.cast(p));
            }
        }
        return null;
    }

    public void cancelTimer() {
        if (this.gerritTriggerTimerTask != null) {
            logger.trace("GerritTrigger.cancelTimer(): {0}", (Object)((Job)this.job).getName());
            this.gerritTriggerTimerTask.cancel();
            this.gerritTriggerTimerTask = null;
        }
    }

    private void addThisTriggerAsListener(Job project) {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin != null) {
            GerritHandler handler = plugin.getHandler();
            if (handler != null) {
                handler.addListener((GerritEventListener)GerritTrigger.createListener(project));
            } else {
                logger.warn("The plugin has no handler instance (BUG)! Project {} will not be triggered!", (Object)project.getFullDisplayName());
            }
        } else {
            logger.warn("The plugin instance could not be found! Project {} will not be triggered!", (Object)project.getFullDisplayName());
        }
    }

    static EventListener createListener(Job project) {
        return new EventListener(project);
    }

    EventListener createListener() {
        return GerritTrigger.createListener((Job)this.job);
    }

    public void start(Job project, boolean newInstance) {
        logger.debug("Start project: {}", (Object)project);
        super.start((Item)project, newInstance);
        this.initializeServerName();
        this.initializeTriggerOnEvents();
        try {
            this.addThisTriggerAsListener(project);
        }
        catch (IllegalStateException e) {
            logger.error("I am too early!", (Throwable)e);
        }
        if (this.dynamicTriggerConfiguration) {
            this.gerritTriggerTimerTask = new GerritTriggerTimerTask(this);
        }
        GerritProjectList.removeTriggerFromProjectList(this);
    }

    public void stop() {
        logger.debug("Stop");
        GerritProjectList.removeTriggerFromProjectList(this);
        super.stop();
        try {
            this.removeListener();
        }
        catch (IllegalStateException e) {
            logger.error("I am too late!", (Throwable)e);
        }
        this.cancelTimer();
    }

    private void removeListener() {
        GerritHandler handler = PluginImpl.getHandler_();
        if (handler != null) {
            if (this.job != null) {
                handler.removeListener((GerritEventListener)this.createListener());
            }
        } else {
            logger.error("The Gerrit handler has not been initialized. BUG!");
        }
    }

    private Provider initializeProvider(GerritTriggeredEvent tEvent) {
        Provider provider = tEvent.getProvider();
        if (!this.isAnyServer()) {
            if (provider == null) {
                provider = new Provider();
                provider.setName(this.serverName);
            } else if (provider.getName() == null) {
                provider.setName(this.serverName);
            }
        }
        return provider;
    }

    boolean isAnyServer() {
        return this.serverName == null || this.serverName.isEmpty() || "__ANY__".equals(this.serverName);
    }

    private boolean shouldTriggerOnEventType(GerritTriggeredEvent event) {
        if (this.triggerOnEvents == null || this.triggerOnEvents.isEmpty()) {
            return false;
        }
        for (PluginGerritEvent e : this.triggerOnEvents) {
            if (!e.shouldTriggerOn(event)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected void schedule(GerritCause cause, GerritTriggeredEvent event) {
        this.createListener().schedule(this, cause, event, (Job)this.job);
    }

    @Deprecated
    protected void schedule(GerritCause cause, GerritTriggeredEvent event, Job project) {
        this.createListener().schedule(this, cause, event, project);
    }

    @Deprecated
    protected ParametersAction createParameters(GerritTriggeredEvent event, Job project) {
        return this.createListener().createParameters(event, project);
    }

    private List<VerdictCategory> getVerdictCategoriesList() {
        GerritServer server = PluginImpl.getServer_(this.serverName);
        if (server != null) {
            return server.getConfig().getCategories();
        }
        logger.error("Could not find server {}", (Object)this.serverName);
        return new LinkedList<VerdictCategory>();
    }

    public ListBoxModel doFillVerdictCategoryItems() {
        ListBoxModel m = new ListBoxModel();
        List<VerdictCategory> list = this.getVerdictCategoriesList();
        for (VerdictCategory v : list) {
            m.add(v.getVerdictDescription(), v.getVerdictValue());
        }
        return m;
    }

    synchronized RunningJobs getRunningJobs() {
        if (this.runningJobs == null) {
            this.runningJobs = new RunningJobs();
        }
        return this.runningJobs;
    }

    public void notifyBuildEnded(GerritTriggeredEvent event) {
        IGerritHudsonTriggerConfig serverConfig;
        if (event instanceof ChangeBasedEvent && (serverConfig = PluginImpl.getServerConfig(event)) != null && serverConfig.isGerritBuildCurrentPatchesOnly()) {
            this.getRunningJobs().remove((ChangeBasedEvent)event);
        }
    }

    public int getBuildScheduleDelay() {
        if (this.isAnyServer()) {
            int max = 0;
            for (GerritServer server : PluginImpl.getServers_()) {
                if (server.getConfig() == null) continue;
                max = Math.max(max, server.getConfig().getBuildScheduleDelay());
            }
            return max;
        }
        GerritServer server = PluginImpl.getServer_(this.serverName);
        if (server == null || server.getConfig() == null) {
            return 3;
        }
        int buildScheduleDelay = server.getConfig().getBuildScheduleDelay();
        return Math.max(0, buildScheduleDelay);
    }

    public void retriggerThisBuild(TriggerContext context) {
        ToGerritRunListener listener;
        if (context.getThisBuild().getProject().isBuildable() && (listener = ToGerritRunListener.getInstance()) != null && !listener.isBuilding(context.getThisBuild().getProject(), context.getEvent())) {
            Provider provider = this.initializeProvider(context.getEvent());
            if (!this.isAnyServer() && !PluginImpl.containsServer_(provider.getName())) {
                provider.setName(this.serverName);
            }
            if (!this.silentMode) {
                listener.onRetriggered(context.getThisBuild().getProject(), context.getEvent(), context.getOtherBuilds());
            }
            GerritUserCause cause = new GerritUserCause(context.getEvent(), this.silentMode);
            this.createListener().schedule(this, cause, context.getEvent(), context.getThisBuild().getProject());
        }
    }

    public void retriggerAllBuilds(TriggerContext context) {
        ToGerritRunListener listener;
        DependencyQueueTaskDispatcher dependencyQueueTaskDispatcher = DependencyQueueTaskDispatcher.getInstance();
        if (dependencyQueueTaskDispatcher != null && (listener = ToGerritRunListener.getInstance()) != null && !listener.isBuilding(context.getEvent())) {
            dependencyQueueTaskDispatcher.onTriggeringAll(context.getEvent());
            this.retrigger(context.getThisBuild().getProject(), context.getEvent());
            for (Run build : context.getOtherBuilds()) {
                GerritTrigger trigger = GerritTrigger.getTrigger(build.getParent());
                if (trigger == null) continue;
                trigger.retrigger(build.getParent(), context.getEvent());
            }
            dependencyQueueTaskDispatcher.onDoneTriggeringAll(context.getEvent());
        }
    }

    private void retrigger(Job project, GerritTriggeredEvent event) {
        if (project.isBuildable()) {
            ToGerritRunListener listener;
            this.initializeProvider(event);
            if (!this.silentMode && (listener = ToGerritRunListener.getInstance()) != null) {
                listener.onRetriggered(project, event, null);
            }
            GerritUserCause cause = new GerritUserCause(event, this.silentMode);
            this.schedule(cause, event, project);
        }
    }

    public int hashCode() {
        if (this.job == null) {
            return super.hashCode();
        }
        return ((Job)this.job).getFullName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GerritTrigger) {
            GerritTrigger that = (GerritTrigger)((Object)obj);
            if (this.job == null || that.job == null) {
                return super.equals(obj);
            }
            return ((Job)this.job).getFullName().equals(((Job)that.job).getFullName());
        }
        return false;
    }

    boolean isInteresting(GerritTriggeredEvent event) {
        if (!((Job)this.job).isBuildable()) {
            logger.trace("Disabled.");
            return false;
        }
        ToGerritRunListener listener = ToGerritRunListener.getInstance();
        if (listener != null) {
            if (listener.isProjectTriggeredAndIncomplete((Job)this.job, event)) {
                logger.trace("Already triggered and incomplete.");
                return false;
            }
            if (listener.isTriggered((Job)this.job, event)) {
                logger.trace("Already triggered.");
                return false;
            }
        }
        if (!this.shouldTriggerOnEventType(event)) {
            return false;
        }
        LinkedList<GerritProject> allGerritProjects = new LinkedList<GerritProject>();
        if (this.gerritProjects != null) {
            allGerritProjects.addAll(this.gerritProjects);
        }
        if (this.dynamicGerritProjects != null) {
            allGerritProjects.addAll(this.dynamicGerritProjects);
        }
        logger.trace("entering isInteresting projects configured: {} the event: {}", (Object)allGerritProjects.size(), (Object)event);
        for (GerritProject p : allGerritProjects) {
            try {
                if (event instanceof ChangeBasedEvent) {
                    boolean containsFilePathsOrForbiddenFilePaths;
                    ChangeBasedEvent changeBasedEvent = (ChangeBasedEvent)event;
                    if (!this.isServerInteresting(event) || !p.isInteresting(changeBasedEvent.getChange().getProject(), changeBasedEvent.getChange().getBranch(), changeBasedEvent.getChange().getTopic())) continue;
                    boolean bl = containsFilePathsOrForbiddenFilePaths = p.getFilePaths() != null && p.getFilePaths().size() > 0 || p.getForbiddenFilePaths() != null && p.getForbiddenFilePaths().size() > 0;
                    if (this.isFileTriggerEnabled() && containsFilePathsOrForbiddenFilePaths) {
                        if (!this.isServerInteresting(event) || !p.isInteresting(changeBasedEvent.getChange().getProject(), changeBasedEvent.getChange().getBranch(), changeBasedEvent.getChange().getTopic(), changeBasedEvent.getFiles(new GerritQueryHandler((GerritConnectionConfig2)PluginImpl.getServerConfig(event))))) continue;
                        logger.trace("According to {} the event is interesting.", (Object)p);
                        return true;
                    }
                    logger.trace("According to {} the event is interesting.", (Object)p);
                    return true;
                }
                if (!(event instanceof RefUpdated)) continue;
                RefUpdated refUpdated = (RefUpdated)event;
                if (!this.isServerInteresting(event) || !p.isInteresting(refUpdated.getRefUpdate().getProject(), refUpdated.getRefUpdate().getRefName(), null)) continue;
                logger.trace("According to {} the event is interesting.", (Object)p);
                return true;
            }
            catch (PatternSyntaxException pse) {
                logger.error(MessageFormat.format("Exception caught for project {0} and pattern {1}, message: {2}", ((Job)this.job).getName(), p.getPattern(), pse.getMessage()));
            }
        }
        logger.trace("Nothing interesting here, move along folks!");
        return false;
    }

    private boolean isServerInteresting(GerritTriggeredEvent event) {
        if (this.isAnyServer()) {
            return true;
        }
        Provider provider = this.initializeProvider(event);
        return provider.getName().equals(this.serverName);
    }

    boolean commentAddedMatch(CommentAdded event) {
        PluginCommentAddedEvent commentAdded = null;
        for (PluginGerritEvent e : this.triggerOnEvents) {
            if (e instanceof PluginCommentAddedEvent) {
                commentAdded = (PluginCommentAddedEvent)e;
                for (Approval approval : event.getApprovals()) {
                    if (!approval.getType().equals(commentAdded.getVerdictCategory()) || !approval.getValue().equals(commentAdded.getCommentAddedTriggerApprovalValue()) && !("+" + approval.getValue()).equals(commentAdded.getCommentAddedTriggerApprovalValue())) continue;
                    return true;
                }
            }
            if (!(e instanceof PluginCommentAddedContainsEvent) || !((PluginCommentAddedContainsEvent)e).match((GerritTriggeredEvent)event)) continue;
            return true;
        }
        return false;
    }

    public List<GerritProject> getGerritProjects() {
        return this.gerritProjects;
    }

    public List<GerritProject> getDynamicGerritProjects() {
        return this.dynamicGerritProjects;
    }

    public void setGerritProjects(List<GerritProject> gerritProjects) {
        this.gerritProjects = gerritProjects;
    }

    public Integer getGerritBuildFailedCodeReviewValue() {
        return this.gerritBuildFailedCodeReviewValue;
    }

    public void setGerritBuildFailedCodeReviewValue(Integer gerritBuildFailedCodeReviewValue) {
        this.gerritBuildFailedCodeReviewValue = gerritBuildFailedCodeReviewValue;
    }

    public Integer getGerritBuildFailedVerifiedValue() {
        return this.gerritBuildFailedVerifiedValue;
    }

    public void setGerritBuildFailedVerifiedValue(Integer gerritBuildFailedVerifiedValue) {
        this.gerritBuildFailedVerifiedValue = gerritBuildFailedVerifiedValue;
    }

    public Integer getGerritBuildStartedCodeReviewValue() {
        return this.gerritBuildStartedCodeReviewValue;
    }

    public void setGerritBuildStartedCodeReviewValue(Integer gerritBuildStartedCodeReviewValue) {
        this.gerritBuildStartedCodeReviewValue = gerritBuildStartedCodeReviewValue;
    }

    public Integer getGerritBuildStartedVerifiedValue() {
        return this.gerritBuildStartedVerifiedValue;
    }

    public void setGerritBuildStartedVerifiedValue(Integer gerritBuildStartedVerifiedValue) {
        this.gerritBuildStartedVerifiedValue = gerritBuildStartedVerifiedValue;
    }

    public Integer getGerritBuildSuccessfulCodeReviewValue() {
        return this.gerritBuildSuccessfulCodeReviewValue;
    }

    public void setGerritBuildSuccessfulCodeReviewValue(Integer gerritBuildSuccessfulCodeReviewValue) {
        this.gerritBuildSuccessfulCodeReviewValue = gerritBuildSuccessfulCodeReviewValue;
    }

    public Integer getGerritBuildSuccessfulVerifiedValue() {
        return this.gerritBuildSuccessfulVerifiedValue;
    }

    public void setGerritBuildSuccessfulVerifiedValue(Integer gerritBuildSuccessfulVerifiedValue) {
        this.gerritBuildSuccessfulVerifiedValue = gerritBuildSuccessfulVerifiedValue;
    }

    public Integer getGerritBuildUnstableCodeReviewValue() {
        return this.gerritBuildUnstableCodeReviewValue;
    }

    public void setGerritBuildUnstableCodeReviewValue(Integer gerritBuildUnstableCodeReviewValue) {
        this.gerritBuildUnstableCodeReviewValue = gerritBuildUnstableCodeReviewValue;
    }

    public Integer getGerritBuildUnstableVerifiedValue() {
        return this.gerritBuildUnstableVerifiedValue;
    }

    public void setGerritBuildUnstableVerifiedValue(Integer gerritBuildUnstableVerifiedValue) {
        this.gerritBuildUnstableVerifiedValue = gerritBuildUnstableVerifiedValue;
    }

    public Integer getGerritBuildNotBuiltCodeReviewValue() {
        return this.gerritBuildNotBuiltCodeReviewValue;
    }

    public void setGerritBuildNotBuiltCodeReviewValue(Integer gerritBuildNotBuiltCodeReviewValue) {
        this.gerritBuildNotBuiltCodeReviewValue = gerritBuildNotBuiltCodeReviewValue;
    }

    public Integer getGerritBuildNotBuiltVerifiedValue() {
        return this.gerritBuildNotBuiltVerifiedValue;
    }

    public void setGerritBuildNotBuiltVerifiedValue(Integer gerritBuildNotBuiltVerifiedValue) {
        this.gerritBuildNotBuiltVerifiedValue = gerritBuildNotBuiltVerifiedValue;
    }

    public void setBuildUnsuccessfulFilepath(String path) {
        this.buildUnsuccessfulFilepath = path;
    }

    public List<PluginGerritEvent> getTriggerOnEvents() {
        this.initializeTriggerOnEvents();
        return this.triggerOnEvents;
    }

    private void initializeTriggerOnEvents() {
        if (this.triggerOnEvents == null) {
            this.triggerOnEvents = new LinkedList<PluginGerritEvent>();
        }
        if (this.triggerOnEvents.isEmpty()) {
            this.triggerOnEvents.add(new PluginPatchsetCreatedEvent());
            if (this.isTriggerOnDraftPublishedEnabled()) {
                this.triggerOnEvents.add(new PluginDraftPublishedEvent());
            }
        }
    }

    private void initializeServerName() {
        if (this.serverName == null) {
            this.serverName = "__ANY__";
        }
    }

    public boolean isDynamicTriggerConfiguration() {
        return this.dynamicTriggerConfiguration;
    }

    public void setDynamicTriggerConfiguration(boolean dynamicTriggerConfiguration) {
        this.dynamicTriggerConfiguration = dynamicTriggerConfiguration;
    }

    public String getTriggerConfigURL() {
        return this.triggerConfigURL;
    }

    public void setTriggerConfigURL(String triggerConfigURL) {
        this.triggerConfigURL = triggerConfigURL;
    }

    public String getDependencyJobsNames() {
        return this.dependencyJobsNames;
    }

    public void setDependencyJobsNames(String dependencyJobsNames) {
        this.dependencyJobsNames = dependencyJobsNames;
    }

    public boolean isSilentMode() {
        return this.silentMode;
    }

    public boolean isSilentStartMode() {
        return this.silentStartMode;
    }

    public String getNotificationLevel() {
        return this.notificationLevel;
    }

    public boolean isEscapeQuotes() {
        return this.escapeQuotes;
    }

    public void setEscapeQuotes(boolean escapeQuotes) {
        this.escapeQuotes = escapeQuotes;
    }

    public boolean isNoNameAndEmailParameters() {
        return this.noNameAndEmailParameters;
    }

    public void setNoNameAndEmailParameters(boolean noNameAndEmailParameters) {
        this.noNameAndEmailParameters = noNameAndEmailParameters;
    }

    public boolean isReadableMessage() {
        return this.readableMessage;
    }

    public void setReadableMessage(boolean readableMessage) {
        this.readableMessage = readableMessage;
    }

    public String getBuildStartMessage() {
        return this.buildStartMessage;
    }

    public String getBuildSuccessfulMessage() {
        return this.buildSuccessfulMessage;
    }

    public String getBuildUnstableMessage() {
        return this.buildUnstableMessage;
    }

    public String getBuildFailureMessage() {
        return this.buildFailureMessage;
    }

    public String getBuildNotBuiltMessage() {
        return this.buildNotBuiltMessage;
    }

    public String getBuildUnsuccessfulFilepath() {
        return this.buildUnsuccessfulFilepath;
    }

    public void setSilentMode(boolean silentMode) {
        this.silentMode = silentMode;
    }

    public void setSilentStartMode(boolean silentStartMode) {
        this.silentStartMode = silentStartMode;
    }

    public void setNotificationLevel(String notificationLevel) {
        this.notificationLevel = notificationLevel;
    }

    public String getCustomUrl() {
        return this.customUrl;
    }

    public void setCustomUrl(String customUrl) {
        this.customUrl = customUrl;
    }

    public boolean isFileTriggerEnabled() {
        return GerritVersionChecker.isCorrectVersion(GerritVersionChecker.Feature.fileTrigger, this.serverName);
    }

    public void updateTriggerConfigURL() {
        if (this.triggerInformationAction == null) {
            this.triggerInformationAction = new GerritTriggerInformationAction();
        }
        this.triggerInformationAction.setErrorMessage("");
        try {
            if (this.isAnyServer()) {
                this.triggerInformationAction.setErrorMessage("Dynamic trigger configuration needs a specific configured server");
            } else {
                List<GerritProject> fetchedProjects = GerritDynamicUrlProcessor.fetch(this.triggerConfigURL, this.serverName);
                this.dynamicGerritProjects = fetchedProjects;
            }
        }
        catch (ParseException pe) {
            String logErrorMessage = MessageFormat.format("ParseException for project: {0} and URL: {1} Message: {2}", ((Job)this.job).getName(), this.triggerConfigURL, pe.getMessage());
            logger.error(logErrorMessage, (Throwable)pe);
            String triggerInformationMessage = MessageFormat.format("ParseException when fetching dynamic trigger url: {0}", pe.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
        catch (MalformedURLException mue) {
            String logErrorMessage = MessageFormat.format("MalformedURLException for project: {0} and URL: {1} Message: {2}", ((Job)this.job).getName(), this.triggerConfigURL, mue.getMessage());
            logger.error(logErrorMessage, (Throwable)mue);
            String triggerInformationMessage = MessageFormat.format("MalformedURLException when fetching dynamic trigger url: {0}", mue.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
        catch (SocketTimeoutException ste) {
            String logErrorMessage = MessageFormat.format("SocketTimeoutException for project: {0} and URL: {1} Message: {2}", ((Job)this.job).getName(), this.triggerConfigURL, ste.getMessage());
            logger.error(logErrorMessage, (Throwable)ste);
            String triggerInformationMessage = MessageFormat.format("SocketTimeoutException when fetching dynamic trigger url: {0}", ste.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
        catch (IOException ioe) {
            String logErrorMessage = MessageFormat.format("IOException for project: {0} and URL: {1} Message: {2}", ((Job)this.job).getName(), this.triggerConfigURL, ioe.getMessage());
            logger.error(logErrorMessage, (Throwable)ioe);
            String triggerInformationMessage = MessageFormat.format("IOException when fetching dynamic trigger url: {0}", ioe.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
    }

    public boolean isTriggerOnDraftPublishedEnabled() {
        return GerritVersionChecker.isCorrectVersion(GerritVersionChecker.Feature.triggerOnDraftPublished, this.serverName);
    }

    public List<GerritSlave> gerritSlavesToWaitFor(String gerritServerName) {
        ArrayList<GerritSlave> gerritSlaves = new ArrayList<GerritSlave>();
        GerritServer gerritServer = PluginImpl.getServer_(gerritServerName);
        if (gerritServer == null) {
            logger.warn("Could not find server: {}", (Object)this.serverName);
            return gerritSlaves;
        }
        ReplicationConfig replicationConfig = gerritServer.getConfig().getReplicationConfig();
        if (replicationConfig != null && replicationConfig.isEnableReplication()) {
            if (replicationConfig.isEnableSlaveSelectionInJobs()) {
                GerritSlave gerritSlave = replicationConfig.getGerritSlave(this.gerritSlaveId, true);
                if (gerritSlave != null) {
                    gerritSlaves.add(gerritSlave);
                }
            } else {
                List<GerritSlave> globalSlaves = replicationConfig.getGerritSlaves();
                if (globalSlaves != null) {
                    gerritSlaves.addAll(globalSlaves);
                }
            }
        }
        return gerritSlaves;
    }

    public List<Action> getProjectActions() {
        LinkedList<Action> list = new LinkedList<Action>();
        list.add(this.triggerInformationAction);
        return list;
    }

    public SkipVote getSkipVote() {
        return this.skipVote;
    }

    public class RunningJobs {
        private final HashMap<GerritTriggeredEvent, ParametersAction> runningJobs = new HashMap();

        public synchronized void scheduled(ChangeBasedEvent event, ParametersAction parameters, String projectName) {
            IGerritHudsonTriggerConfig serverConfig = PluginImpl.getServerConfig((GerritTriggeredEvent)event);
            if (serverConfig == null) {
                this.runningJobs.put((GerritTriggeredEvent)event, parameters);
                return;
            }
            BuildCancellationPolicy buildCurrentPatchesOnly = serverConfig.getBuildCurrentPatchesOnly();
            if (!buildCurrentPatchesOnly.isEnabled() || event instanceof ManualPatchsetCreated && !buildCurrentPatchesOnly.isAbortManualPatchsets()) {
                this.runningJobs.put((GerritTriggeredEvent)event, parameters);
                return;
            }
            Iterator<Map.Entry<GerritTriggeredEvent, ParametersAction>> it = this.runningJobs.entrySet().iterator();
            while (it.hasNext()) {
                boolean shouldCancelPatchsetNumber;
                boolean shouldCancelManual;
                ChangeBasedEvent runningChangeBasedEvent;
                Map.Entry<GerritTriggeredEvent, ParametersAction> pairs = it.next();
                if (!(pairs.getKey() instanceof ChangeBasedEvent) || !(runningChangeBasedEvent = (ChangeBasedEvent)pairs.getKey()).getChange().equals((Object)event.getChange()) || !(shouldCancelManual = runningChangeBasedEvent instanceof ManualPatchsetCreated && buildCurrentPatchesOnly.isAbortManualPatchsets() || !(runningChangeBasedEvent instanceof ManualPatchsetCreated))) continue;
                boolean bl = shouldCancelPatchsetNumber = buildCurrentPatchesOnly.isAbortNewPatchsets() || Integer.parseInt(runningChangeBasedEvent.getPatchSet().getNumber()) < Integer.parseInt(event.getPatchSet().getNumber());
                if (!shouldCancelPatchsetNumber) continue;
                logger.debug("Cancelling build for " + pairs.getKey());
                try {
                    this.cancelJob(pairs.getKey());
                }
                catch (Exception e) {
                    logger.error("Error canceling job", (Throwable)e);
                }
                it.remove();
            }
            this.runningJobs.put((GerritTriggeredEvent)event, parameters);
        }

        private void cancelJob(GerritTriggeredEvent event) {
            if (!(GerritTrigger.this.job instanceof Queue.Task)) {
                logger.error("Error canceling job. The job is not of type Task. Job name: " + ((Job)GerritTrigger.this.job).getName());
                return;
            }
            List itemsInQueue = Queue.getInstance().getItems((Queue.Task)GerritTrigger.this.job);
            for (Queue.Item item : itemsInQueue) {
                if (!this.checkCausedByGerrit(event, item.getCauses())) continue;
                Queue.getInstance().cancel(item);
            }
            String workaround = System.getProperty(JOB_ABORT);
            if (workaround != null && workaround.equals("false")) {
                return;
            }
            Jenkins jenkins = Jenkins.getInstance();
            assert (jenkins != null);
            for (Computer c : jenkins.getComputers()) {
                ArrayList executors = new ArrayList();
                executors.addAll(c.getOneOffExecutors());
                executors.addAll(c.getExecutors());
                for (Executor e : executors) {
                    Run run;
                    Queue.Executable currentExecutable = e.getCurrentExecutable();
                    if (currentExecutable == null || !(currentExecutable instanceof Run) || !this.checkCausedByGerrit(event, (run = (Run)currentExecutable).getCauses())) continue;
                    e.interrupt(Result.ABORTED, new CauseOfInterruption[]{new NewPatchSetInterruption()});
                }
            }
        }

        private boolean checkCausedByGerrit(GerritTriggeredEvent event, Collection<Cause> causes) {
            for (Cause c : causes) {
                GerritCause gc;
                if (!(c instanceof GerritCause) || (gc = (GerritCause)c).getEvent() != event) continue;
                return true;
            }
            return false;
        }

        public synchronized ParametersAction remove(ChangeBasedEvent event) {
            logger.debug("Removing future job " + event.getPatchSet().getNumber());
            return this.runningJobs.remove(event);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isUnsuccessfulMessageFileSupported(Job job) {
            return job instanceof AbstractProject;
        }

        public FormValidation doEmptyOrIntegerCheck(@QueryParameter(value="value") String value) {
            if (value == null || value.length() <= 0) {
                return FormValidation.ok();
            }
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)hudson.model.Messages.Hudson_NotANumber());
            }
        }

        public AutoCompletionCandidates doAutoCompleteDependencyJobsNames(@QueryParameter String value, @AncestorInPath Item self, @AncestorInPath ItemGroup container) {
            return AutoCompletionCandidates.ofJobNames(Job.class, (String)value, (Item)self, (ItemGroup)container);
        }

        public FormValidation doCheckDependencyJobsNames(@AncestorInPath Item project, @QueryParameter String value) {
            StringTokenizer tokens = new StringTokenizer(Util.fixNull((String)value), ",");
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if (projectName.equals("")) continue;
                Jenkins jenkins = Jenkins.getInstance();
                assert (jenkins != null);
                Item item = jenkins.getItem(projectName, project, Item.class);
                if (item != null && item instanceof Job) continue;
                Job nearest = (Job)Items.findNearest(Job.class, (String)projectName, (ItemGroup)project.getParent());
                String path = "<null>";
                if (nearest != null) {
                    path = nearest.getRelativeNameFrom(project);
                }
                return FormValidation.error((String)hudson.model.Messages.AbstractItem_NoSuchJobExists((Object)projectName, (Object)path));
            }
            HashSet<Job> explored = new HashSet<Job>();
            List<Job> directDependencies = DependencyQueueTaskDispatcher.getProjectsFromString(value, project);
            if (directDependencies == null) {
                return FormValidation.ok();
            }
            for (Job directDependency : directDependencies) {
                if (directDependency.getFullName().equals(project.getFullName())) {
                    return FormValidation.error((String)Messages.CannotAddSelfAsDependency());
                }
                LinkedList<Job> toExplore = new LinkedList<Job>();
                toExplore.add(directDependency);
                while (toExplore.size() > 0) {
                    String currentDependenciesString;
                    List<Job> currentDependencies;
                    Job currentlyExploring = (Job)toExplore.remove();
                    explored.add(currentlyExploring);
                    GerritTrigger currentTrigger = GerritTrigger.getTrigger(currentlyExploring);
                    if (currentTrigger == null || (currentDependencies = DependencyQueueTaskDispatcher.getProjectsFromString(currentDependenciesString = GerritTrigger.getTrigger(currentlyExploring).getDependencyJobsNames(), project)) == null) continue;
                    for (Job dependency : currentDependencies) {
                        if (dependency.getFullName().equals(project.getFullName())) {
                            return FormValidation.error((String)Messages.AddingDependentProjectWouldCreateLoop(directDependency.getFullName(), currentlyExploring.getFullName()));
                        }
                        if (explored.contains(dependency)) continue;
                        toExplore.add(dependency);
                    }
                }
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillServerNameItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(Messages.AnyServer(), "__ANY__");
            List<String> serverNames = PluginImpl.getServerNames_();
            for (String s : serverNames) {
                items.add(s);
            }
            return items;
        }

        public boolean isSlaveSelectionAllowedInJobs() {
            for (GerritServer server : PluginImpl.getServers_()) {
                ReplicationConfig replicationConfig = server.getConfig().getReplicationConfig();
                if (replicationConfig == null || !replicationConfig.isEnableSlaveSelectionInJobs()) continue;
                return true;
            }
            return false;
        }

        public ListBoxModel doFillGerritSlaveIdItems(@QueryParameter(value="serverName") String serverName) {
            ListBoxModel items = new ListBoxModel();
            if ("__ANY__".equals(serverName)) {
                items.add(Messages.SlaveSelectionNotAllowedAnyServer(Messages.AnyServer()), "");
                return items;
            }
            GerritServer server = PluginImpl.getServer_(serverName);
            if (server == null) {
                logger.warn(Messages.CouldNotFindServer(serverName));
                items.add(Messages.CouldNotFindServer(serverName), "");
                return items;
            }
            ReplicationConfig replicationConfig = server.getConfig().getReplicationConfig();
            if (replicationConfig == null) {
                items.add(Messages.ReplicationNotConfigured(), "");
                return items;
            }
            if (!replicationConfig.isEnableReplication()) {
                items.add(Messages.ReplicationNotConfigured(), "");
                return items;
            }
            if (!replicationConfig.isEnableSlaveSelectionInJobs()) {
                items.add(Messages.SlaveSelectionInJobsDisabled(), "");
                return items;
            }
            for (GerritSlave slave : replicationConfig.getGerritSlaves()) {
                if (slave.getId().equals(replicationConfig.getDefaultSlaveId())) {
                    items.add(0, (Object)new ListBoxModel.Option(slave.getName(), slave.getId()));
                    continue;
                }
                items.add(slave.getName(), slave.getId());
            }
            return items;
        }

        public FormValidation doUrlCheck(@QueryParameter(value="value") String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)Messages.EmptyError());
            }
            try {
                URL url = new URL(value);
                url.toURI();
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)Messages.BadUrlError());
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)Messages.BadUrlError());
            }
        }

        public ListBoxModel doFillNotificationLevelItems(@QueryParameter(value="serverName") String serverName) {
            Map<Notify, String> levelTextsById = GerritServer.notificationLevelTextsById();
            ListBoxModel items = new ListBoxModel(levelTextsById.size() + 1);
            items.add((Object)DescriptorImpl.getOptionForNotificationLevelDefault(serverName, levelTextsById));
            for (Map.Entry<Notify, String> level : levelTextsById.entrySet()) {
                items.add((Object)new ListBoxModel.Option(level.getValue(), level.getKey().toString()));
            }
            return items;
        }

        private static ListBoxModel.Option getOptionForNotificationLevelDefault(String serverName, Map<Notify, String> levelTextsById) {
            Notify level;
            GerritServer server;
            if ("__ANY__".equals(serverName)) {
                return new ListBoxModel.Option(Messages.NotificationLevel_DefaultValue(), "");
            }
            if (serverName != null && (server = PluginImpl.getServer_(serverName)) != null && (level = server.getConfig().getNotificationLevel()) != null) {
                String levelText = levelTextsById.get(level);
                if (levelText == null) {
                    levelText = level.toString();
                }
                return new ListBoxModel.Option(Messages.NotificationLevel_DefaultValueFromServer(levelText), "");
            }
            String defaultText = levelTextsById.get(Config.DEFAULT_NOTIFICATION_LEVEL);
            return new ListBoxModel.Option(Messages.NotificationLevel_DefaultValueFromServer(defaultText), "");
        }

        public DescriptorImpl() {
            super(GerritTrigger.class);
        }

        public boolean isApplicable(Item item) {
            return item instanceof ParameterizedJobMixIn.ParameterizedJob;
        }

        public String getDisplayName() {
            return Messages.TriggerDisplayName();
        }

        public String getHelpFile() {
            return "/plugin/gerrit-trigger/help-whatIsGerritTrigger.html";
        }

        public CompareType[] getCompareTypes() {
            return CompareType.values();
        }

        public List<PluginGerritEvent.PluginGerritEventDescriptor> getGerritEventDescriptors() {
            ExtensionList extensionList = Hudson.getInstance().getExtensionList(PluginGerritEvent.PluginGerritEventDescriptor.class);
            return extensionList;
        }
    }
}

