/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.PatchsetCreated;
import hudson.triggers.SCMTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritCause
extends SCMTrigger.SCMTriggerCause {
    private static final Logger logger = LoggerFactory.getLogger(GerritCause.class);
    private GerritTriggeredEvent tEvent;
    private boolean silentMode;
    private TriggerContext context;
    private String url;
    @Deprecated
    private transient PatchsetCreated event;

    public GerritCause(GerritTriggeredEvent event, boolean silentMode) {
        super("");
        this.tEvent = event;
        this.silentMode = silentMode;
        this.context = new TriggerContext(event);
        this.url = this.getUrlFromEvent();
    }

    public GerritCause(GerritTriggeredEvent event, boolean silentMode, TriggerContext context) {
        super("");
        this.tEvent = event;
        this.silentMode = silentMode;
        this.context = context;
        this.url = this.getUrlFromEvent();
    }

    public GerritCause() {
        super("");
    }

    public GerritTriggeredEvent getEvent() {
        return this.tEvent;
    }

    public void setEvent(GerritTriggeredEvent event) {
        this.tEvent = event;
    }

    public boolean isSilentMode() {
        return this.silentMode;
    }

    public void setSilentMode(boolean silentMode) {
        this.silentMode = silentMode;
    }

    public TriggerContext getContext() {
        return this.context;
    }

    public void setContext(TriggerContext context) {
        this.context = context;
    }

    protected String getShortGerritDescription() {
        return Messages.TriggeredShortDescription(this.getUrl());
    }

    protected String getShortGerritDescriptionSilentMode() {
        return Messages.TriggeredShortDescriptionInSilentMode(this.getUrl());
    }

    public String getShortDescription() {
        if (this.isSilentMode()) {
            return this.getShortGerritDescriptionSilentMode();
        }
        return this.getShortGerritDescription();
    }

    public String getUrl() {
        return this.url;
    }

    private String getUrlFromEvent() {
        if (this.tEvent.getProvider() != null) {
            String serverName = this.tEvent.getProvider().getName();
            GerritServer server = PluginImpl.getServer_(serverName);
            if (server != null) {
                IGerritHudsonTriggerConfig config = server.getConfig();
                if (config != null) {
                    return config.getGerritFrontEndUrlFor(this.tEvent);
                }
                logger.error("Could not get the server config for server {}", (Object)server.getName());
            } else {
                logger.error("Could not get the server {}", (Object)serverName);
            }
        } else {
            logger.error("Event provider has not been properly initialized.");
        }
        return "";
    }

    public String toString() {
        return "GerritCause: " + this.tEvent + " silent: " + this.silentMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GerritCause that = (GerritCause)((Object)o);
        if (this.silentMode != that.silentMode) {
            return false;
        }
        return this.tEvent.equals(that.tEvent);
    }

    public int hashCode() {
        int result = this.tEvent.hashCode();
        result = 31 * result + (this.silentMode ? 1 : 0);
        return result;
    }

    Object readResolve() {
        if (this.event != null) {
            this.tEvent = this.event;
            this.event = null;
        }
        return this;
    }
}

