/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.trigger.events.lifecycle.GerritEventLifecycle;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.NotificationFactory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(ordinal=10003.0)
public final class ToGerritRunListener
extends RunListener<Run> {
    public static final int ORDINAL = 10003;
    private static final Logger logger = LoggerFactory.getLogger(ToGerritRunListener.class);
    private final transient BuildMemory memory = new BuildMemory();

    public static ToGerritRunListener getInstance() {
        Jenkins jenkins = Jenkins.getInstance();
        assert (jenkins != null);
        ExtensionList listeners = jenkins.getExtensionList(ToGerritRunListener.class);
        if (listeners == null || listeners.isEmpty()) {
            logger.error("INITIALIZATION ERROR? Could not find the registered instance.");
            return null;
        }
        return (ToGerritRunListener)((Object)listeners.get(0));
    }

    public synchronized void onCompleted(@Nonnull Run r, @Nonnull TaskListener listener) {
        GerritCause cause = this.getCause(r);
        logger.debug("Completed. Build: {} Cause: {}", (Object)r, (Object)cause);
        if (cause != null) {
            this.cleanUpGerritCauses(cause, r);
            GerritTriggeredEvent event = cause.getEvent();
            GerritTrigger trigger = GerritTrigger.getTrigger(r.getParent());
            if (trigger != null) {
                trigger.notifyBuildEnded(event);
            }
            if (event instanceof GerritEventLifecycle) {
                ((GerritEventLifecycle)event).fireBuildCompleted(r);
            }
            if (!cause.isSilentMode()) {
                this.memory.completed(event, r);
                Result result = r.getResult();
                if (result != null && result.isWorseThan(Result.SUCCESS)) {
                    try {
                        String failureMessage = this.obtainFailureMessage(event, r, listener);
                        logger.info("Obtained failure message: {}", (Object)failureMessage);
                        this.memory.setEntryFailureMessage(event, r, failureMessage);
                    }
                    catch (IOException e) {
                        listener.error("[gerrit-trigger] Unable to read failure message from the workspace.");
                        logger.warn("IOException while obtaining failure message for build: " + r.getDisplayName(), (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        listener.error("[gerrit-trigger] Unable to read failure message from the workspace.");
                        logger.warn("InterruptedException while obtaining failure message for build: " + r.getDisplayName(), (Throwable)e);
                    }
                }
                this.updateTriggerContexts(r);
                this.allBuildsCompleted(event, cause, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void allBuildsCompleted(GerritTriggeredEvent event, GerritCause cause, TaskListener listener) {
        if (this.memory.isAllBuildsCompleted(event)) {
            try {
                logger.info("All Builds are completed for cause: {}", (Object)cause);
                if (event instanceof GerritEventLifecycle) {
                    ((GerritEventLifecycle)event).fireAllBuildsCompleted();
                }
                NotificationFactory.getInstance().queueBuildCompleted(this.memory.getMemoryImprint(event), listener);
            }
            finally {
                this.memory.forget(event);
            }
        } else {
            logger.info("Waiting for more builds to complete for cause [{}]. Status: \n{}", (Object)cause, (Object)this.memory.getStatusReport(event));
        }
    }

    public synchronized boolean isProjectTriggeredAndIncomplete(Job p, GerritTriggeredEvent event) {
        if (!this.memory.isTriggered(event, p)) {
            return false;
        }
        return this.memory.isBuilding(event, p);
    }

    public synchronized void onStarted(Run r, TaskListener listener) {
        GerritCause cause = this.getCause(r);
        logger.debug("Started. Build: {} Cause: {}", (Object)r, (Object)cause);
        if (cause != null) {
            this.cleanUpGerritCauses(cause, r);
            this.setThisBuild(r);
            if (cause.getEvent() != null && cause.getEvent() instanceof GerritEventLifecycle) {
                ((GerritEventLifecycle)cause.getEvent()).fireBuildStarted(r);
            }
            if (!cause.isSilentMode()) {
                this.memory.started(cause.getEvent(), r);
                this.updateTriggerContexts(r);
                GerritTrigger trigger = GerritTrigger.getTrigger(r.getParent());
                boolean silentStartMode = false;
                if (trigger != null) {
                    silentStartMode = trigger.isSilentStartMode();
                }
                if (!silentStartMode) {
                    BuildsStartedStats stats = this.memory.getBuildsStartedStats(cause.getEvent());
                    NotificationFactory.getInstance().queueBuildStarted(r, listener, cause.getEvent(), stats);
                }
            }
            logger.info("Gerrit build [{}] Started for cause: [{}].", (Object)r, (Object)cause);
            logger.info("MemoryStatus:\n{}", (Object)this.memory.getStatusReport(cause.getEvent()));
        }
    }

    protected void updateTriggerContexts(Run r) {
        List causes = r.getCauses();
        for (Cause cause : causes) {
            if (!(cause instanceof GerritCause)) continue;
            this.memory.updateTriggerContext((GerritCause)cause, r);
        }
    }

    protected void setThisBuild(Run r) {
        List causes = r.getCauses();
        for (Cause cause : causes) {
            if (!(cause instanceof GerritCause)) continue;
            ((GerritCause)cause).getContext().setThisBuild(r);
        }
    }

    protected void cleanUpGerritCauses(GerritCause firstFound, Run build) {
        List causes = ((CauseAction)build.getAction(CauseAction.class)).getCauses();
        int pos = causes.indexOf((Object)firstFound) + 1;
        while (pos < causes.size()) {
            Cause c = (Cause)causes.get(pos);
            if (c.equals((Object)firstFound)) {
                causes.remove(pos);
                continue;
            }
            ++pos;
        }
    }

    public synchronized void onTriggered(Job project, GerritTriggeredEvent event) {
        this.memory.triggered(event, project);
        if (event instanceof GerritEventLifecycle) {
            ((GerritEventLifecycle)event).fireProjectTriggered(project);
        }
        String name = null;
        if (project != null) {
            name = project.getName();
        }
        logger.info("Project [{}] triggered by Gerrit: [{}]", (Object)name, (Object)event);
    }

    public synchronized void onRetriggered(Job project, GerritTriggeredEvent event, List<Run> otherBuilds) {
        this.memory.retriggered(event, project, otherBuilds);
        if (event instanceof GerritEventLifecycle) {
            ((GerritEventLifecycle)event).fireProjectTriggered(project);
        }
        String name = null;
        if (project != null) {
            name = project.getName();
        }
        logger.info("Project [{}] re-triggered by Gerrit-User: [{}]", (Object)name, (Object)event);
    }

    public boolean isBuilding(Job project, GerritTriggeredEvent event) {
        if (project == null || event == null) {
            return false;
        }
        return this.memory.isBuilding(event, project);
    }

    public boolean isBuilding(GerritTriggeredEvent event) {
        if (event == null) {
            return false;
        }
        return this.memory.isBuilding(event);
    }

    public boolean isTriggered(Job project, GerritTriggeredEvent event) {
        if (project == null || event == null) {
            return false;
        }
        return this.memory.isTriggered(event, project);
    }

    private GerritCause getCause(Run build) {
        return (GerritCause)build.getCause(GerritCause.class);
    }

    @Nonnull
    protected FilePath[] getMatchingWorkspaceFiles(@Nullable FilePath ws, @Nonnull String filepath) throws IOException, InterruptedException {
        if (ws == null) {
            return new FilePath[0];
        }
        return ws.list(filepath);
    }

    protected String getExpandedContent(FilePath path, EnvVars envVars) throws IOException, InterruptedException {
        if (path.exists()) {
            return envVars.expand(path.readToString());
        }
        return null;
    }

    private String obtainFailureMessage(@Nullable GerritTriggeredEvent event, @Nonnull Run build, @Nullable TaskListener listener) throws IOException, InterruptedException {
        Job project = build.getParent();
        String content = null;
        GerritTrigger trigger = GerritTrigger.getTrigger(project);
        if (trigger != null) {
            String filepath = trigger.getBuildUnsuccessfulFilepath();
            logger.debug("Looking for failure message in file glob: {}", (Object)filepath);
            if (filepath != null && !filepath.isEmpty()) {
                EnvVars envVars = listener == null ? build.getEnvironment() : build.getEnvironment(listener);
                filepath = envVars.expand(filepath);
                if (build instanceof AbstractBuild) {
                    Object[] matches = this.getMatchingWorkspaceFiles(((AbstractBuild)build).getWorkspace(), filepath);
                    logger.debug("Found matching workspace files: {}", matches);
                    if (matches.length > 0) {
                        Object path = matches[0];
                        content = this.getExpandedContent((FilePath)path, envVars);
                        logger.info("Obtained failure message from file: {}", (Object)content);
                    }
                } else {
                    logger.warn("Unable to find matching workspace files for job {}, type {}", (Object)build.getDisplayName(), (Object)build.getClass().getName());
                }
            }
        }
        return content;
    }
}

