/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerContext {
    private PatchsetCreated event;
    private TriggeredItemEntity thisBuild;
    private List<TriggeredItemEntity> others;

    public TriggerContext(AbstractBuild thisBuild, PatchsetCreated event, List<TriggeredItemEntity> others) {
        this.thisBuild = new TriggeredItemEntity(thisBuild);
        this.event = event;
        this.others = others;
    }

    public TriggerContext(PatchsetCreated event) {
        this.event = event;
    }

    public TriggerContext() {
    }

    public synchronized List<TriggeredItemEntity> getOthers() {
        return this.others;
    }

    public synchronized void setOthers(List<TriggeredItemEntity> otherBuilds) {
        this.others = otherBuilds;
    }

    public TriggeredItemEntity getThisBuild() {
        return this.thisBuild;
    }

    public synchronized void setThisBuild(TriggeredItemEntity thisBuild) {
        this.thisBuild = thisBuild;
    }

    public synchronized void setThisBuild(AbstractBuild thisBuild) {
        this.thisBuild = new TriggeredItemEntity(thisBuild);
    }

    public PatchsetCreated getEvent() {
        return this.event;
    }

    public synchronized void addOtherBuild(AbstractBuild build) {
        TriggeredItemEntity other;
        if (this.others == null) {
            this.others = new LinkedList<TriggeredItemEntity>();
        }
        if ((other = this.findOtherBuild(build)) == null) {
            other = this.findOtherProject(build.getProject());
            if (other != null) {
                other.setBuild(build);
            } else {
                this.others.add(new TriggeredItemEntity(build));
            }
        }
    }

    public synchronized void addOtherProject(AbstractProject project) {
        if (this.others == null) {
            this.others = new LinkedList<TriggeredItemEntity>();
        }
        if (this.findOtherProject(project) == null) {
            this.others.add(new TriggeredItemEntity(project));
        }
    }

    public synchronized boolean hasOthers() {
        return this.others != null && !this.others.isEmpty();
    }

    private synchronized TriggeredItemEntity findOtherBuild(AbstractBuild build) {
        for (TriggeredItemEntity other : this.others) {
            if (!other.equals(build)) continue;
            return other;
        }
        return null;
    }

    private synchronized TriggeredItemEntity findOtherProject(AbstractProject project) {
        for (TriggeredItemEntity other : this.others) {
            if (!other.equals(project)) continue;
            return other;
        }
        return null;
    }

    public synchronized List<AbstractBuild> getOtherBuilds() {
        LinkedList<AbstractBuild> list = new LinkedList<AbstractBuild>();
        if (this.others != null) {
            for (TriggeredItemEntity entity : this.others) {
                if (entity.getBuild() == null) continue;
                list.add(entity.getBuild());
            }
        }
        return list;
    }

    public synchronized List<AbstractProject> getOtherProjects() {
        LinkedList<AbstractProject> list = new LinkedList<AbstractProject>();
        if (this.others != null) {
            for (TriggeredItemEntity entity : this.others) {
                if (entity.getProject() == null) continue;
                list.add(entity.getProject());
            }
        }
        return list;
    }

    public static class TriggeredItemEntity {
        private Integer buildNumber;
        private String projectId;
        private transient AbstractProject project;
        private transient AbstractBuild build;

        public TriggeredItemEntity(Integer buildNumber, String projectId) {
            this.buildNumber = buildNumber;
            this.projectId = projectId;
        }

        public TriggeredItemEntity(AbstractProject project, AbstractBuild build) {
            this.setProject(project);
            this.setBuild(build);
        }

        public TriggeredItemEntity(AbstractBuild build) {
            this.setProject(build.getProject());
            this.setBuild(build);
        }

        public TriggeredItemEntity(AbstractProject project) {
            this.setProject(project);
            this.buildNumber = null;
        }

        public TriggeredItemEntity() {
        }

        public boolean hasBuild() {
            return this.buildNumber != null;
        }

        public AbstractBuild getBuild() {
            if (this.build == null && this.buildNumber != null) {
                this.getProject();
                if (this.project != null) {
                    this.build = (AbstractBuild)this.project.getBuildByNumber(this.buildNumber.intValue());
                }
            }
            return this.build;
        }

        public void setBuild(AbstractBuild build) {
            this.build = build;
            this.buildNumber = build.getNumber();
        }

        public AbstractProject getProject() {
            if (this.project == null) {
                this.project = (AbstractProject)Hudson.getInstance().getItemByFullName(this.projectId, AbstractProject.class);
            }
            return this.project;
        }

        public void setProject(AbstractProject project) {
            this.project = project;
            this.projectId = project.getFullName();
        }

        public Integer getBuildNumber() {
            return this.buildNumber;
        }

        public void setBuildNumber(Integer buildNumber) {
            this.buildNumber = buildNumber;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TriggeredItemEntity other = (TriggeredItemEntity)obj;
            if (!(this.buildNumber == other.buildNumber || this.buildNumber != null && this.buildNumber.equals(other.buildNumber))) {
                return false;
            }
            return !(this.projectId == null ? other.projectId != null : !this.projectId.equals(other.projectId));
        }

        public boolean equals(AbstractBuild aBuild) {
            if (this.buildNumber != null) {
                return this.projectId.equals(aBuild.getProject().getFullName()) && this.buildNumber.equals(aBuild.getNumber());
            }
            return false;
        }

        public boolean equals(AbstractProject aProject) {
            return this.projectId.equals(aProject.getFullName());
        }

        public int hashCode() {
            int hash = 5;
            hash = 47 * hash + (this.buildNumber != null ? this.buildNumber.hashCode() : 0);
            hash = 47 * hash + (this.projectId != null ? this.projectId.hashCode() : 0);
            return hash;
        }
    }
}

