/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.GerritNotifier;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.GerritSSHCmdRunner;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ToGerritRunListener
extends RunListener<AbstractBuild> {
    private static final Logger logger = LoggerFactory.getLogger(ToGerritRunListener.class);
    private static ToGerritRunListener instance;
    private transient BuildMemory memory = new BuildMemory();

    public ToGerritRunListener() {
        super(AbstractBuild.class);
    }

    public static ToGerritRunListener getInstance() {
        if (instance == null) {
            for (RunListener listener : ToGerritRunListener.all()) {
                if (!(listener instanceof ToGerritRunListener)) continue;
                instance = (ToGerritRunListener)listener;
                break;
            }
        }
        return instance;
    }

    public synchronized void onCompleted(AbstractBuild r, TaskListener listener) {
        GerritCause cause = this.getCause(r);
        logger.info("Completed. Build: {} Cause: {}", (Object)r, (Object)cause);
        if (cause != null && !cause.isSilentMode()) {
            PatchsetCreated event = cause.getEvent();
            BuildMemory.PatchSetKey key = this.memory.completed(event, r);
            this.memory.updateTriggerContext(key, cause, r);
            if (this.memory.isAllBuildsCompleted(key)) {
                logger.info("All Builds are completed for cause: {}", (Object)cause);
                ToGerritRunListener.createNotifier().buildCompleted(this.memory.getMemoryImprint(key), listener);
                this.memory.forget(key);
            } else {
                logger.info("Waiting for more builds to complete for cause [{}]. Status: \n{}", (Object)cause, (Object)this.memory.getStatusReport(key));
            }
        }
    }

    public synchronized void onStarted(AbstractBuild r, TaskListener listener) {
        GerritCause cause = this.getCause(r);
        logger.debug("Started. Build: {} Cause: {}", (Object)r, (Object)cause);
        if (cause != null) {
            cause.getContext().setThisBuild(r);
            BuildMemory.PatchSetKey key = null;
            if (!cause.isSilentMode()) {
                key = this.memory.started(cause.getEvent(), r);
                this.memory.updateTriggerContext(key, cause, r);
                BuildsStartedStats stats = this.memory.getBuildsStartedStats(key);
                ToGerritRunListener.createNotifier().buildStarted(r, listener, cause.getEvent(), stats);
            }
            logger.info("Gerrit build [{}] Started for cause: [{}].", (Object)r, (Object)cause);
            if (key != null) {
                logger.info("MemoryStatus:\n{}", (Object)this.memory.getStatusReport(key));
            }
        }
    }

    public synchronized void onTriggered(AbstractProject project, PatchsetCreated event) {
        this.memory.triggered(event, project);
        String name = null;
        if (project != null) {
            name = project.getName();
        }
        logger.info("Project [{}] triggered by Gerrit: [{}]", (Object)name, (Object)event);
    }

    public synchronized void onRetriggered(AbstractProject project, PatchsetCreated event, List<AbstractBuild> otherBuilds) {
        this.memory.retriggered(event, project, otherBuilds);
        String name = null;
        if (project != null) {
            name = project.getName();
        }
        logger.info("Project [{}] re-triggered by Gerrit-User: [{}]", (Object)name, (Object)event);
    }

    public boolean isBuilding(AbstractProject project, PatchsetCreated event) {
        if (project == null || event == null) {
            return false;
        }
        return this.memory.isBuilding(event, project);
    }

    public boolean isBuilding(PatchsetCreated event) {
        if (event == null) {
            return false;
        }
        return this.memory.isBuilding(event);
    }

    private GerritCause getCause(AbstractBuild build) {
        List causes = build.getCauses();
        for (Cause c : causes) {
            if (!(c instanceof GerritCause)) continue;
            return (GerritCause)c;
        }
        return null;
    }

    private static GerritNotifier createNotifier() {
        if (PluginImpl.getInstance() == null) {
            throw new IllegalStateException("PluginImpl has not been loaded yet!");
        }
        IGerritHudsonTriggerConfig config = PluginImpl.getInstance().getConfig();
        return new GerritNotifier(config, new GerritSSHCmdRunner(config));
    }
}

