/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterExpander {
    public static final int DEFAULT_PARAMETERS_COUNT = 11;
    private static final Logger logger = LoggerFactory.getLogger(ParameterExpander.class);
    private IGerritHudsonTriggerConfig config;
    private Hudson hudson;

    public ParameterExpander(IGerritHudsonTriggerConfig config, Hudson hudson) {
        this.config = config;
        this.hudson = hudson;
    }

    public ParameterExpander(IGerritHudsonTriggerConfig config) {
        this(config, Hudson.getInstance());
    }

    public String getBuildStartedCommand(AbstractBuild r, TaskListener taskListener, PatchsetCreated event, BuildsStartedStats stats) {
        String gerritCmd = this.config.getGerritCmdBuildStarted();
        Map<String, String> parameters = this.createStandardParameters(r, event, this.getBuildStartedCodeReviewValue(r), this.getBuildStartedVerifiedValue(r));
        String startedStats = "";
        if (stats.getTotalBuildsToStart() > 1) {
            startedStats = stats.toString();
        }
        parameters.put("STARTED_STATS", startedStats);
        return this.expandParameters(gerritCmd, r, taskListener, parameters);
    }

    private int getBuildStartedVerifiedValue(AbstractBuild r) {
        GerritTrigger trigger = this.getTrigger(r.getProject());
        if (trigger == null) {
            logger.warn("Unable to get trigger config for build {} will use global value.");
            return this.config.getGerritBuildStartedVerifiedValue();
        }
        if (trigger.getGerritBuildStartedVerifiedValue() != null) {
            Integer value = trigger.getGerritBuildStartedVerifiedValue();
            logger.trace("BuildStartedVerified overridden in project config. returning {}", (Object)value);
            return value;
        }
        int value = this.config.getGerritBuildStartedVerifiedValue();
        logger.trace("BuildStartedVerified standard value used {}", (Object)value);
        return value;
    }

    private int getBuildStartedCodeReviewValue(AbstractBuild r) {
        GerritTrigger trigger = this.getTrigger(r.getProject());
        if (trigger == null) {
            logger.warn("Unable to get trigger config for build {} will use global value.");
            return this.config.getGerritBuildStartedCodeReviewValue();
        }
        if (trigger.getGerritBuildStartedCodeReviewValue() != null) {
            Integer value = trigger.getGerritBuildStartedCodeReviewValue();
            logger.trace("BuildStartedCodeReview overridden in project config. returning {}", (Object)value);
            return value;
        }
        int value = this.config.getGerritBuildStartedCodeReviewValue();
        logger.trace("BuildStartedCodeReview standard value used {}", (Object)value);
        return value;
    }

    private Map<String, String> createStandardParameters(AbstractBuild r, PatchsetCreated event, int codeReview, int verified) {
        HashMap<String, String> map = new HashMap<String, String>(11);
        map.put("GERRIT_NAME", event.getChange().getProject());
        map.put("CHANGE_ID", event.getChange().getId());
        map.put("BRANCH", event.getChange().getProject());
        map.put("CHANGE", event.getChange().getNumber());
        map.put("PATCHSET", event.getPatchSet().getNumber());
        map.put("REFSPEC", StringUtil.makeRefSpec(event));
        if (r != null) {
            map.put("BUILDURL", this.hudson.getRootUrl() + r.getUrl());
        }
        map.put("VERIFIED", String.valueOf(verified));
        map.put("CODE_REVIEW", String.valueOf(codeReview));
        return map;
    }

    private GerritTrigger getTrigger(AbstractProject project) {
        return (GerritTrigger)project.getTrigger(GerritTrigger.class);
    }

    private String expandParameters(String gerritCommand, AbstractBuild r, TaskListener taskListener, Map<String, String> parameters) {
        if (r != null && taskListener != null) {
            try {
                gerritCommand = r.getEnvironment(taskListener).expand(gerritCommand);
            }
            catch (Exception ex) {
                logger.error("Failed to expand env vars into gerrit cmd. Gerrit won't be notified!!", (Throwable)ex);
                return null;
            }
        }
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            gerritCommand = gerritCommand.replace("<" + param.getKey() + ">", param.getValue());
        }
        return gerritCommand;
    }

    protected int getCodeReviewValue(Result res, GerritTrigger trigger) {
        if (res == Result.SUCCESS) {
            if (trigger.getGerritBuildSuccessfulCodeReviewValue() != null) {
                return trigger.getGerritBuildSuccessfulCodeReviewValue();
            }
            return this.config.getGerritBuildSuccessfulCodeReviewValue();
        }
        if (res == Result.FAILURE || res == Result.ABORTED) {
            if (trigger.getGerritBuildFailedCodeReviewValue() != null) {
                return trigger.getGerritBuildFailedCodeReviewValue();
            }
            return this.config.getGerritBuildFailedCodeReviewValue();
        }
        if (res == Result.UNSTABLE) {
            if (trigger.getGerritBuildUnstableCodeReviewValue() != null) {
                return trigger.getGerritBuildUnstableCodeReviewValue();
            }
            return this.config.getGerritBuildUnstableCodeReviewValue();
        }
        if (trigger.getGerritBuildFailedCodeReviewValue() != null) {
            return trigger.getGerritBuildFailedCodeReviewValue();
        }
        return this.config.getGerritBuildFailedCodeReviewValue();
    }

    protected int getVerifiedValue(Result res, GerritTrigger trigger) {
        if (res == Result.SUCCESS) {
            if (trigger.getGerritBuildSuccessfulVerifiedValue() != null) {
                return trigger.getGerritBuildSuccessfulVerifiedValue();
            }
            return this.config.getGerritBuildSuccessfulVerifiedValue();
        }
        if (res == Result.FAILURE || res == Result.ABORTED) {
            if (trigger.getGerritBuildFailedVerifiedValue() != null) {
                return trigger.getGerritBuildFailedVerifiedValue();
            }
            return this.config.getGerritBuildFailedVerifiedValue();
        }
        if (res == Result.UNSTABLE) {
            if (trigger.getGerritBuildUnstableVerifiedValue() != null) {
                return trigger.getGerritBuildUnstableVerifiedValue();
            }
            return this.config.getGerritBuildUnstableVerifiedValue();
        }
        if (trigger.getGerritBuildFailedVerifiedValue() != null) {
            return trigger.getGerritBuildFailedVerifiedValue();
        }
        return this.config.getGerritBuildFailedVerifiedValue();
    }

    protected int getMinimumVerifiedValue(BuildMemory.MemoryImprint memoryImprint) {
        int verified = Integer.MAX_VALUE;
        for (BuildMemory.MemoryImprint.Entry entry : memoryImprint.getEntries()) {
            verified = Math.min(verified, this.getVerifiedValue(entry.getBuild().getResult(), this.getTrigger(entry.getProject())));
        }
        return verified;
    }

    protected int getMinimumCodeReviewValue(BuildMemory.MemoryImprint memoryImprint) {
        int codeReview = Integer.MAX_VALUE;
        for (BuildMemory.MemoryImprint.Entry entry : memoryImprint.getEntries()) {
            codeReview = Math.min(codeReview, this.getCodeReviewValue(entry.getBuild().getResult(), this.getTrigger(entry.getProject())));
        }
        return codeReview;
    }

    public String getBuildCompletedCommand(BuildMemory.MemoryImprint memoryImprint, TaskListener listener) {
        String command = memoryImprint.whereAllBuildsSuccessful() ? this.config.getGerritCmdBuildSuccessful() : (memoryImprint.whereAnyBuildsFailed() ? this.config.getGerritCmdBuildFailed() : (memoryImprint.whereAnyBuildsUnstable() ? this.config.getGerritCmdBuildUnstable() : this.config.getGerritCmdBuildFailed()));
        int verified = this.getMinimumVerifiedValue(memoryImprint);
        int codeReview = this.getMinimumCodeReviewValue(memoryImprint);
        Map<String, String> parameters = this.createStandardParameters(null, memoryImprint.getEvent(), codeReview, verified);
        parameters.put("BUILDS_STATS", this.createBuildsStats(memoryImprint));
        AbstractBuild build = null;
        BuildMemory.MemoryImprint.Entry[] entries = memoryImprint.getEntries();
        if (entries.length > 0 && entries[0].getBuild() != null) {
            build = entries[0].getBuild();
        }
        return this.expandParameters(command, build, listener, parameters);
    }

    private String createBuildsStats(BuildMemory.MemoryImprint memoryImprint) {
        BuildMemory.MemoryImprint.Entry[] entries;
        StringBuilder str = new StringBuilder("");
        String rootUrl = this.hudson.getRootUrl();
        for (BuildMemory.MemoryImprint.Entry entry : entries = memoryImprint.getEntries()) {
            if (entry.getBuild() == null) continue;
            if (str.length() > 0) {
                str.append("\t");
            }
            str.append(entry.getBuild().getResult().toString()).append(": ");
            str.append(rootUrl).append(entry.getBuild().getUrl());
        }
        return str.toString();
    }
}

