/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnection;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritSSHCmdRunner {
    private static final Logger logger = LoggerFactory.getLogger(GerritSSHCmdRunner.class);
    private IGerritHudsonTriggerConfig config;

    public GerritSSHCmdRunner(IGerritHudsonTriggerConfig config) {
        this.config = config;
    }

    public boolean runCmd(String cmd) {
        try {
            SshConnection ssh = new SshConnection(this.config.getGerritHostName(), this.config.getGerritSshPort(), this.config.getGerritAuthentication());
            ssh.executeCommand(cmd);
            ssh.disconnect();
            return true;
        }
        catch (Exception ex) {
            logger.error("Could not run command " + cmd, (Throwable)ex);
            return false;
        }
    }
}

