/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.GerritSSHCmdRunner;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ParameterExpander;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritNotifier {
    private static final Logger logger = LoggerFactory.getLogger(GerritNotifier.class);
    private GerritSSHCmdRunner cmdRunner;
    private ParameterExpander parameterExpander;

    public GerritNotifier(IGerritHudsonTriggerConfig config, GerritSSHCmdRunner cmdRunner) {
        this.cmdRunner = cmdRunner;
        this.parameterExpander = new ParameterExpander(config);
    }

    public GerritNotifier(IGerritHudsonTriggerConfig config, GerritSSHCmdRunner cmdRunner, Hudson hudson) {
        this.cmdRunner = cmdRunner;
        this.parameterExpander = new ParameterExpander(config, hudson);
    }

    public void buildStarted(AbstractBuild r, TaskListener taskListener, PatchsetCreated event, BuildsStartedStats stats) {
        try {
            String command = this.parameterExpander.getBuildStartedCommand(r, taskListener, event, stats);
            if (command != null) {
                logger.info("Notifying BuildStarted to gerrit: {}", (Object)command);
                this.cmdRunner.runCmd(command);
            } else {
                logger.error("Something wrong during parameter extraction. Gerrit will not be notified of BuildStarted");
            }
        }
        catch (Exception ex) {
            logger.error("Could not complete BuildStarted notification!", (Throwable)ex);
        }
    }

    public void buildCompleted(BuildMemory.MemoryImprint memoryImprint, TaskListener listener) {
        try {
            String command = this.parameterExpander.getBuildCompletedCommand(memoryImprint, listener);
            if (command != null) {
                logger.info("Notifying BuildCompleted to gerrit: {}", (Object)command);
                this.cmdRunner.runCmd(command);
            } else {
                logger.error("Something wrong during parameter extraction. Gerrit will not be notified of BuildCompleted");
            }
        }
        catch (Exception ex) {
            logger.error("Could not complete BuildCompleted notification!", (Throwable)ex);
        }
    }
}

