/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.config;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritDefaultValues;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.Authentication;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config
implements IGerritHudsonTriggerConfig {
    public static final int DEFAULT_GERRIT_BUILD_STARTED_VERIFIED_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_STARTED_CODE_REVIEW_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_UNSTABLE_VERIFIED_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_UNSTABLE_CODE_REVIEW_VALUE = -1;
    public static final int DEFAULT_GERRIT_BUILD_FAILURE_VERIFIED_VALUE = -1;
    public static final int DEFAULT_GERRIT_BUILD_FAILURE_CODE_REVIEW_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_SUCCESSFUL_CODE_REVIEW_VALUE = 0;
    public static final int DEFAULT_GERRIT_BUILD_SUCCESSFUL_VERIFIED_VALUE = 1;
    private String gerritHostName;
    private int gerritSshPort;
    private String gerritUserName;
    private File gerritAuthKeyFile;
    private String gerritAuthKeyFilePassword;
    private int numberOfWorkerThreads;
    private String gerritVerifiedCmdBuildSuccessful;
    private String gerritVerifiedCmdBuildUnstable;
    private String gerritVerifiedCmdBuildFailed;
    private String gerritVerifiedCmdBuildStarted;
    private String gerritFrontEndUrl;
    private transient List<String> gerritProjects;
    private int gerritBuildStartedVerifiedValue;
    private int gerritBuildStartedCodeReviewValue;
    private int gerritBuildSuccessfulVerifiedValue;
    private int gerritBuildSuccessfulCodeReviewValue;
    private int gerritBuildFailedVerifiedValue;
    private int gerritBuildFailedCodeReviewValue;
    private int gerritBuildUnstableVerifiedValue;
    private int gerritBuildUnstableCodeReviewValue;

    public Config(JSONObject formData) {
        this.setValues(formData);
    }

    @Override
    public void setValues(JSONObject formData) {
        this.gerritHostName = formData.optString("gerritHostName", "localhost");
        this.gerritSshPort = formData.optInt("gerritSshPort", 29418);
        this.gerritUserName = formData.optString("gerritUserName", "hudson");
        String file = formData.optString("gerritAuthKeyFile", null);
        this.gerritAuthKeyFile = file != null ? new File(file) : GerritDefaultValues.DEFAULT_GERRIT_AUTH_KEY_FILE;
        this.gerritAuthKeyFilePassword = formData.optString("gerritAuthKeyFilePassword", GerritDefaultValues.DEFAULT_GERRIT_AUTH_KEY_FILE_PASSWORD);
        if (this.gerritAuthKeyFilePassword != null && this.gerritAuthKeyFilePassword.length() <= 0) {
            this.gerritAuthKeyFilePassword = null;
        }
        this.numberOfWorkerThreads = formData.optInt("numberOfWorkerThreads", 3);
        this.gerritBuildStartedVerifiedValue = formData.optInt("gerritBuildStartedVerifiedValue", 0);
        this.gerritBuildStartedCodeReviewValue = formData.optInt("gerritBuildStartedCodeReviewValue", 0);
        this.gerritBuildSuccessfulVerifiedValue = formData.optInt("gerritBuildSuccessfulVerifiedValue", 1);
        this.gerritBuildSuccessfulCodeReviewValue = formData.optInt("gerritBuildSuccessfulCodeReviewValue", 0);
        this.gerritBuildFailedVerifiedValue = formData.optInt("gerritBuildFailedVerifiedValue", -1);
        this.gerritBuildFailedCodeReviewValue = formData.optInt("gerritBuildFailedCodeReviewValue", 0);
        this.gerritBuildUnstableVerifiedValue = formData.optInt("gerritBuildUnstableVerifiedValue", 0);
        this.gerritBuildUnstableCodeReviewValue = formData.optInt("gerritBuildUnstableCodeReviewValue", -1);
        this.gerritVerifiedCmdBuildStarted = formData.optString("gerritVerifiedCmdBuildStarted", "gerrit approve <CHANGE>,<PATCHSET> --message 'Build Started <BUILDURL> <STARTED_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW>");
        this.gerritVerifiedCmdBuildFailed = formData.optString("gerritVerifiedCmdBuildFailed", "gerrit approve <CHANGE>,<PATCHSET> --message 'Build Failed <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW>");
        this.gerritVerifiedCmdBuildSuccessful = formData.optString("gerritVerifiedCmdBuildSuccessful", "gerrit approve <CHANGE>,<PATCHSET> --message 'Build Successful <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW>");
        this.gerritVerifiedCmdBuildUnstable = formData.optString("gerritVerifiedCmdBuildUnstable", "gerrit approve <CHANGE>,<PATCHSET> --message 'Build Unstable <BUILDS_STATS>' --verified <VERIFIED> --code-review <CODE_REVIEW>");
        this.gerritFrontEndUrl = formData.optString("gerritFrontEndUrl", "http://localhost");
    }

    public Config() {
        this(new JSONObject(false));
    }

    public Config(JSONObject formData, StaplerRequest req) {
        this(formData);
    }

    @Override
    public File getGerritAuthKeyFile() {
        return this.gerritAuthKeyFile;
    }

    public void setGerritAuthKeyFile(File gerritAuthKeyFile) {
        this.gerritAuthKeyFile = gerritAuthKeyFile;
    }

    @Override
    public String getGerritAuthKeyFilePassword() {
        return this.gerritAuthKeyFilePassword;
    }

    public void setGerritAuthKeyFilePassword(String gerritAuthKeyFilePassword) {
        this.gerritAuthKeyFilePassword = gerritAuthKeyFilePassword;
    }

    @Override
    public String getGerritFrontEndUrl() {
        String url = this.gerritFrontEndUrl;
        if (!url.endsWith("/")) {
            url = url + '/';
        }
        return url;
    }

    public void setGerritFrontEndURL(String gerritFrontEndURL) {
        this.gerritFrontEndUrl = gerritFrontEndURL;
    }

    @Override
    public String getGerritHostName() {
        return this.gerritHostName;
    }

    public void setGerritHostName(String gerritHostName) {
        this.gerritHostName = gerritHostName;
    }

    @Override
    public int getGerritSshPort() {
        return this.gerritSshPort;
    }

    public void setGerritSshPort(int gerritSshPort) {
        this.gerritSshPort = gerritSshPort;
    }

    @Override
    public String getGerritUserName() {
        return this.gerritUserName;
    }

    public void setGerritUserName(String gerritUserName) {
        this.gerritUserName = gerritUserName;
    }

    @Override
    public int getNumberOfWorkerThreads() {
        return this.numberOfWorkerThreads;
    }

    public void setNumberOfWorkerThreads(int numberOfWorkerThreads) {
        this.numberOfWorkerThreads = numberOfWorkerThreads;
    }

    @Override
    public String getGerritCmdBuildSuccessful() {
        return this.gerritVerifiedCmdBuildSuccessful;
    }

    public void setGerritVerifiedCmdBuildSuccessful(String cmd) {
        this.gerritVerifiedCmdBuildSuccessful = cmd;
    }

    @Override
    public String getGerritCmdBuildUnstable() {
        return this.gerritVerifiedCmdBuildUnstable;
    }

    public void setGerritVerifiedCmdBuildUnstable(String cmd) {
        this.gerritVerifiedCmdBuildUnstable = cmd;
    }

    @Override
    public String getGerritCmdBuildFailed() {
        return this.gerritVerifiedCmdBuildFailed;
    }

    public void setGerritVerifiedCmdBuildFailed(String cmd) {
        this.gerritVerifiedCmdBuildFailed = cmd;
    }

    @Override
    public String getGerritCmdBuildStarted() {
        return this.gerritVerifiedCmdBuildStarted;
    }

    public void setGerritVerifiedCmdBuildStarted(String cmd) {
        this.gerritVerifiedCmdBuildStarted = cmd;
    }

    @Override
    public void setGerritProjects(List<String> projects) {
        this.gerritProjects = projects;
    }

    @Override
    public List<String> getGerritProjects() {
        if (this.gerritProjects == null) {
            this.gerritProjects = new ArrayList<String>();
        }
        return this.gerritProjects;
    }

    @Override
    public int getGerritBuildStartedVerifiedValue() {
        return this.gerritBuildStartedVerifiedValue;
    }

    @Override
    public int getGerritBuildStartedCodeReviewValue() {
        return this.gerritBuildStartedCodeReviewValue;
    }

    @Override
    public int getGerritBuildSuccessfulVerifiedValue() {
        return this.gerritBuildSuccessfulVerifiedValue;
    }

    @Override
    public int getGerritBuildSuccessfulCodeReviewValue() {
        return this.gerritBuildSuccessfulCodeReviewValue;
    }

    @Override
    public int getGerritBuildFailedVerifiedValue() {
        return this.gerritBuildFailedVerifiedValue;
    }

    @Override
    public int getGerritBuildFailedCodeReviewValue() {
        return this.gerritBuildFailedCodeReviewValue;
    }

    @Override
    public int getGerritBuildUnstableVerifiedValue() {
        return this.gerritBuildUnstableVerifiedValue;
    }

    @Override
    public int getGerritBuildUnstableCodeReviewValue() {
        return this.gerritBuildUnstableCodeReviewValue;
    }

    @Override
    public String getGerritFrontEndUrlFor(String changeSetNumber, String revision) {
        StringBuilder str = new StringBuilder(this.getGerritFrontEndUrl());
        str.append(changeSetNumber);
        return str.toString();
    }

    @Override
    public Authentication getGerritAuthentication() {
        return new Authentication(this.gerritAuthKeyFile, this.gerritUserName, this.gerritAuthKeyFilePassword);
    }
}

