/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ConnectionListener;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritEventListener;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritHandler;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.Config;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import hudson.Plugin;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginImpl
extends Plugin {
    public static final String DISPLAY_NAME = "Gerrit Hudson Trigger";
    private static final Logger logger = LoggerFactory.getLogger(PluginImpl.class);
    private transient GerritHandler gerritEventManager;
    private static PluginImpl instance;
    private IGerritHudsonTriggerConfig config;
    private transient List<GerritEventListener> savedEventListeners;
    private transient List<ConnectionListener> savedConnectionListeners;

    public PluginImpl() {
        instance = this;
    }

    public IGerritHudsonTriggerConfig getConfig() {
        return this.config;
    }

    public static PluginImpl getInstance() {
        return instance;
    }

    public void start() throws Exception {
        logger.info("Starting");
        this.loadConfig();
        this.startManager();
        logger.info("Started");
    }

    private void loadConfig() throws IOException {
        logger.trace("loadConfig");
        this.load();
        if (this.config == null) {
            this.config = new Config();
        }
    }

    public void stop() throws Exception {
        logger.info("Shutting down...");
        this.gerritEventManager.shutdown(false);
        this.gerritEventManager = null;
    }

    private void startManager() {
        logger.debug("starting Gerrit manager");
        this.createManager();
        this.gerritEventManager.start();
    }

    private void createManager() {
        this.gerritEventManager = new GerritHandler(this.config.getGerritHostName(), this.config.getGerritSshPort(), this.config.getGerritAuthentication(), this.config.getNumberOfWorkerThreads());
    }

    public void addListener(GerritEventListener listener) {
        if (this.gerritEventManager == null) {
            throw new IllegalStateException("Manager not started!");
        }
        this.gerritEventManager.addListener(listener);
    }

    public void removeListener(GerritEventListener listener) {
        if (this.gerritEventManager == null) {
            throw new IllegalStateException("Manager not started!");
        }
        this.gerritEventManager.removeListener(listener);
    }

    public synchronized void startConnection() throws Exception {
        if (this.gerritEventManager == null) {
            this.createManager();
            if (this.savedEventListeners != null) {
                this.gerritEventManager.addEventListeners(this.savedEventListeners);
                this.savedEventListeners = null;
            }
            if (this.savedConnectionListeners != null) {
                this.gerritEventManager.addConnectionListeners(this.savedConnectionListeners);
                this.savedConnectionListeners = null;
            }
            this.gerritEventManager.start();
        } else {
            logger.warn("Already started!");
        }
    }

    public synchronized void stopConnection() throws Exception {
        this.savedEventListeners = null;
        this.savedConnectionListeners = null;
        if (this.gerritEventManager != null) {
            this.gerritEventManager.shutdown(true);
            this.savedEventListeners = this.gerritEventManager.removeAllEventListeners();
            this.savedConnectionListeners = this.gerritEventManager.removeAllConnectionListeners();
            this.gerritEventManager = null;
        } else {
            logger.warn("Was told to shutdown again!?");
        }
    }

    public void restartConnection() throws Exception {
        this.stopConnection();
        this.startConnection();
    }

    public void addListener(ConnectionListener listener) {
        if (this.gerritEventManager == null) {
            throw new IllegalStateException("Manager not started!");
        }
        this.gerritEventManager.addListener(listener);
    }
}

