/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.Authentication;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshAuthenticationException;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnectException;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnection;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshUtil;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class GerritManagement
extends ManagementLink
implements StaplerProxy,
Describable<GerritManagement>,
Saveable {
    private static final Logger logger = LoggerFactory.getLogger(GerritManagement.class);

    public String getIconFileName() {
        return "/plugin/gerrit-trigger/images/icon.png";
    }

    public String getUrlName() {
        return "gerrit-trigger";
    }

    public String getDisplayName() {
        return Messages.DisplayName();
    }

    public String getDescription() {
        return Messages.PluginDescription();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException {
        if (logger.isDebugEnabled()) {
            logger.debug("submit {}", (Object)req.toString());
        }
        JSONObject form = req.getSubmittedForm();
        try {
            GerritManagement.getConfig().setValues(form);
            PluginImpl.getInstance().save();
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        rsp.sendRedirect(".");
    }

    public FormValidation doPositiveIntegerCheck(@QueryParameter(value="value") String value) {
        return FormValidation.validatePositiveInteger((String)value);
    }

    public FormValidation doIntegerCheck(@QueryParameter(value="value") String value) {
        try {
            Integer.parseInt(value);
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)hudson.model.Messages.Hudson_NotANumber());
        }
    }

    public FormValidation doEmptyOrIntegerCheck(@QueryParameter(value="value") String value) {
        if (value == null || value.length() <= 0) {
            return FormValidation.ok();
        }
        try {
            Integer.parseInt(value);
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)hudson.model.Messages.Hudson_NotANumber());
        }
    }

    public FormValidation doUrlCheck(@QueryParameter(value="value") String value) {
        if (value == null || value.length() <= 0) {
            return FormValidation.error((String)Messages.EmptyError());
        }
        try {
            new URL(value);
            return FormValidation.ok();
        }
        catch (MalformedURLException ex) {
            return FormValidation.error((String)Messages.BadUrlError());
        }
    }

    public FormValidation doValidKeyFileCheck(@QueryParameter(value="value") String value) {
        File f = new File(value);
        if (!f.exists()) {
            return FormValidation.error((String)Messages.FileNotFoundError(value));
        }
        if (!f.isFile()) {
            return FormValidation.error((String)Messages.NotFileError(value));
        }
        if (SshUtil.isPrivateKeyFileValid((File)f)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.InvalidKeyFileError(value));
    }

    public Object getTarget() {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        return this;
    }

    public void save() throws IOException {
        logger.debug("SAVE!!!");
    }

    public static GerritManagement get() {
        return (GerritManagement)((Object)ManagementLink.all().get(GerritManagement.class));
    }

    public static IGerritHudsonTriggerConfig getConfig() {
        if (PluginImpl.getInstance() != null) {
            return PluginImpl.getInstance().getConfig();
        }
        return null;
    }

    private static void readProjects(Reader commandReader) throws IOException {
        ArrayList<String> projects = new ArrayList<String>();
        BufferedReader br = new BufferedReader(commandReader);
        String line = br.readLine();
        while (line != null) {
            projects.add(line);
            line = br.readLine();
        }
        if (PluginImpl.getInstance() != null && PluginImpl.getInstance().getConfig() != null) {
            PluginImpl.getInstance().getConfig().setGerritProjects(projects);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GerritManagement> {
        public String getDisplayName() {
            return null;
        }

        public FormValidation doStartConnection() {
            try {
                PluginImpl.getInstance().startConnection();
                return FormValidation.ok();
            }
            catch (Exception ex) {
                logger.error("Could not start connection. ", (Throwable)ex);
                return FormValidation.error((String)ex.getMessage());
            }
        }

        public FormValidation doStopConnection() {
            try {
                PluginImpl.getInstance().stopConnection();
                return FormValidation.ok();
            }
            catch (Exception ex) {
                logger.error("Could not stop connection. ", (Throwable)ex);
                return FormValidation.error((String)ex.getMessage());
            }
        }

        public FormValidation doRestartConnection() {
            try {
                PluginImpl.getInstance().restartConnection();
                return FormValidation.ok();
            }
            catch (Exception ex) {
                logger.error("Could not restart connection. ", (Throwable)ex);
                return FormValidation.error((String)ex.getMessage());
            }
        }

        public FormValidation doTestConnection(@QueryParameter(value="gerritHostName") String gerritHostName, @QueryParameter(value="gerritSshPort") int gerritSshPort, @QueryParameter(value="gerritUserName") String gerritUserName, @QueryParameter(value="gerritAuthKeyFile") String gerritAuthKeyFile, @QueryParameter(value="gerritAuthKeyFilePassword") String gerritAuthKeyFilePassword) {
            if (logger.isDebugEnabled()) {
                logger.debug("gerritHostName = {}\ngerritSshPort = {}\ngerritUserName = {}\ngerritAuthKeyFile = {}\ngerritAuthKeyFilePassword = {}", new Object[]{gerritHostName, gerritSshPort, gerritUserName, gerritAuthKeyFile, gerritAuthKeyFilePassword});
            }
            File file = new File(gerritAuthKeyFile);
            String password = null;
            if (gerritAuthKeyFilePassword != null && gerritAuthKeyFilePassword.length() > 0) {
                password = gerritAuthKeyFilePassword;
            }
            if (SshUtil.checkPassPhrase((File)file, password)) {
                if (file.exists() && file.isFile()) {
                    try {
                        SshConnection sshConnection = new SshConnection(gerritHostName, gerritSshPort, new Authentication(file, gerritUserName, password));
                        sshConnection.disconnect();
                        return FormValidation.ok((String)Messages.Success());
                    }
                    catch (SshConnectException ex) {
                        return FormValidation.error((String)Messages.SshConnectException());
                    }
                    catch (SshAuthenticationException ex) {
                        return FormValidation.error((String)Messages.SshAuthenticationException(ex.getMessage()));
                    }
                    catch (Exception e) {
                        return FormValidation.error((String)Messages.ConnectionError(e.getMessage()));
                    }
                }
                return FormValidation.error((String)Messages.SshKeyFileNotFoundError(gerritAuthKeyFile));
            }
            return FormValidation.error((String)Messages.BadSshkeyOrPasswordError());
        }
    }
}

