/*
 * Decompiled with CFR 0.152.
 */
package com.sonu.demo.materialstepper;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.support.v4.util.SparseArrayCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.sonu.demo.materialstepper.CircularTextView;
import com.sonu.demo.materialstepper.DataTransferCallbacks;
import com.sonu.demo.materialstepper.MaterialStepperViewPager;
import com.sonu.demo.materialstepper.NavigationCallbacks;
import com.sonu.demo.materialstepper.OnLastStepNextListener;
import com.sonu.demo.materialstepper.R;
import com.sonu.demo.materialstepper.StatusBarCallbacks;
import com.sonu.demo.materialstepper.StepFragment;
import com.sonu.demo.materialstepper.StepsAdapter;
import com.sonu.demo.materialstepper.ViewPagerCallbacks;
import java.util.ArrayList;

public class MaterialStepper
extends RelativeLayout
implements DataTransferCallbacks,
ViewPagerCallbacks,
StatusBarCallbacks {
    private static final String TAG = MaterialStepper.class.getSimpleName();
    private MaterialStepperViewPager stepsViewpager;
    private CardView navigationBar;
    private CardView statusBar;
    private LinearLayout navigationBarViewHolder;
    private LinearLayout statusBarViewHolder;
    private HorizontalScrollView statusBarScrollView;
    private Button rightButton;
    private Button leftButton;
    private Button skipButton;
    private OnLastStepNextListener onLastStepNextListener;
    private int defaultTabCircleColor = -7829368;
    private int defaultTabTextColor = -7829368;
    private int currentTabCircleColor = -16777216;
    private int currentTabTextColor = -16777216;
    private int completedTabCircleColor = Color.parseColor((String)"#8bc34a");
    private int completedTabTextColor = Color.parseColor((String)"#8bc34a");
    private int skippedTabCircleColor = Color.parseColor((String)"#ff9800");
    private int skippedTabTextColor = Color.parseColor((String)"#ff9800");
    private int completedTabDrawable = R.drawable.ic_done_white_24dp;
    private int skippedTabDrawable = R.drawable.ic_skip_next_white_24dp;
    private Context mContext;
    private NavigationCallbacks navigationCallbacks;
    private StepFragment currentFragment;
    private SparseArrayCompat<Bundle> dataArray;
    private StepsAdapter stepsAdapter;
    private int currentPosition;
    private FragmentManager fragmentManager;

    public MaterialStepper(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public MaterialStepper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    public MaterialStepper(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.init();
    }

    public OnLastStepNextListener getOnLastStepNextListener() {
        return this.onLastStepNextListener;
    }

    public void setOnLastStepNextListener(OnLastStepNextListener onLastStepNextListener) {
        this.onLastStepNextListener = onLastStepNextListener;
    }

    public int getDefaultTabCircleColor() {
        return this.defaultTabCircleColor;
    }

    public void setDefaultTabCircleColor(int defaultTabCircleColor) {
        this.defaultTabCircleColor = defaultTabCircleColor;
    }

    public int getDefaultTabTextColor() {
        return this.defaultTabTextColor;
    }

    public void setDefaultTabTextColor(int defaultTabTextColor) {
        this.defaultTabTextColor = defaultTabTextColor;
    }

    public int getCurrentTabCircleColor() {
        return this.currentTabCircleColor;
    }

    public void setCurrentTabCircleColor(int currentTabCircleColor) {
        this.currentTabCircleColor = currentTabCircleColor;
    }

    public int getCurrentTabTextColor() {
        return this.currentTabTextColor;
    }

    public void setCurrentTabTextColor(int currentTabTextColor) {
        this.currentTabTextColor = currentTabTextColor;
    }

    public int getCompletedTabCircleColor() {
        return this.completedTabCircleColor;
    }

    public void setCompletedTabCircleColor(int completeTabCircleColor) {
        this.completedTabCircleColor = completeTabCircleColor;
    }

    public int getCompletedTabTextColor() {
        return this.completedTabTextColor;
    }

    public void setCompletedTabTextColor(int completeTabTextColor) {
        this.completedTabTextColor = completeTabTextColor;
    }

    public int getSkippedTabCircleColor() {
        return this.skippedTabCircleColor;
    }

    public void setSkippedTabCircleColor(int skippedTabCircleColor) {
        this.skippedTabCircleColor = skippedTabCircleColor;
    }

    public int getSkippedTabTextColor() {
        return this.skippedTabTextColor;
    }

    public void setSkippedTabTextColor(int skippedTabTextColor) {
        this.skippedTabTextColor = skippedTabTextColor;
    }

    private void init() {
        this.dataArray = new SparseArrayCompat();
        this.onLastStepNextListener = new OnLastStepNextListener(){

            @Override
            public void onLastStepNext() {
                Toast.makeText((Context)MaterialStepper.this.mContext, (CharSequence)"Last Step Next Clicked", (int)0).show();
            }
        };
        View v = MaterialStepper.inflate((Context)this.getContext(), (int)R.layout.material_stepper, (ViewGroup)this);
        this.stepsViewpager = (MaterialStepperViewPager)v.findViewById(R.id.stepsViewpager);
        this.navigationBar = (CardView)v.findViewById(R.id.navigationBar);
        this.statusBar = (CardView)v.findViewById(R.id.statusBar);
        this.navigationBarViewHolder = (LinearLayout)v.findViewById(R.id.navigationBarViewHolder);
        this.statusBarViewHolder = (LinearLayout)v.findViewById(R.id.statusBarViewHolder);
        this.statusBarScrollView = (HorizontalScrollView)v.findViewById(R.id.statusBarScrollView);
        this.statusBarScrollView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.rightButton = (Button)v.findViewById(R.id.rightButton);
        this.leftButton = (Button)v.findViewById(R.id.leftButton);
        this.skipButton = (Button)v.findViewById(R.id.skipButton);
        this.currentPosition = 0;
        this.stepsViewpager.setPagingEnabled(false);
        this.stepsViewpager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                MaterialStepper.this.currentPosition = position;
                if (MaterialStepper.this.fragmentManager == null) {
                    Log.e((String)TAG, (String)"onPageSelected():Fragment manager not set");
                } else {
                    MaterialStepper.this.currentFragment = MaterialStepper.this.stepsAdapter.getItem(MaterialStepper.this.currentPosition);
                    MaterialStepper.this.navigationCallbacks = MaterialStepper.this.currentFragment;
                    MaterialStepper.this.navigationCallbacks.initButtons(MaterialStepper.this.leftButton, MaterialStepper.this.rightButton, MaterialStepper.this.skipButton);
                    MaterialStepper.this.setCurrentTab(MaterialStepper.this.currentFragment);
                    MaterialStepper.this.currentFragment.setStatus(0);
                    MaterialStepper.this.scrollStatusBar(MaterialStepper.this.currentFragment.getStepIndex());
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void setDefaultTab(StepFragment stepFragment) {
        View v = this.statusBarViewHolder.getChildAt(stepFragment.getStepIndex());
        v.findViewById(R.id.tab_icon_circleimageview).setVisibility(8);
        CircularTextView icon_textview = (CircularTextView)v.findViewById(R.id.tab_icon_circulartextview);
        icon_textview.setSolidColor(this.defaultTabCircleColor);
        TextView title_textview = (TextView)v.findViewById(R.id.tab_title_textview);
        title_textview.setTextColor(this.defaultTabTextColor);
        title_textview.setTypeface(Typeface.DEFAULT);
        this.setStatusBarTabIconVisibility(stepFragment.getStepIndex(), 8);
    }

    private void setCurrentTab(StepFragment stepFragment) {
        View v = this.statusBarViewHolder.getChildAt(stepFragment.getStepIndex());
        v.findViewById(R.id.tab_icon_circleimageview).setVisibility(8);
        CircularTextView icon_textview = (CircularTextView)v.findViewById(R.id.tab_icon_circulartextview);
        icon_textview.setSolidColor(this.currentTabCircleColor);
        TextView title_textview = (TextView)v.findViewById(R.id.tab_title_textview);
        title_textview.setTextColor(this.currentTabTextColor);
        title_textview.setTypeface(Typeface.DEFAULT_BOLD);
        this.setStatusBarTabIconVisibility(stepFragment.getStepIndex(), 8);
    }

    private void setSkippedTab(StepFragment stepFragment) {
        View v = this.statusBarViewHolder.getChildAt(stepFragment.getStepIndex());
        v.findViewById(R.id.tab_icon_circleimageview).setVisibility(8);
        CircularTextView icon_textview = (CircularTextView)v.findViewById(R.id.tab_icon_circulartextview);
        icon_textview.setSolidColor(this.skippedTabCircleColor);
        TextView title_textview = (TextView)v.findViewById(R.id.tab_title_textview);
        title_textview.setTextColor(this.skippedTabTextColor);
        title_textview.setTypeface(Typeface.DEFAULT);
        this.setStatusBarTabIconVisibility(stepFragment.getStepIndex(), 0);
        this.setStatusBarTabIconDrawable(stepFragment.getStepIndex(), this.skippedTabDrawable);
    }

    private void setCompletedTab(StepFragment stepFragment) {
        View v = this.statusBarViewHolder.getChildAt(stepFragment.getStepIndex());
        v.findViewById(R.id.tab_icon_circleimageview).setVisibility(8);
        CircularTextView icon_textview = (CircularTextView)v.findViewById(R.id.tab_icon_circulartextview);
        icon_textview.setSolidColor(this.completedTabCircleColor);
        TextView title_textview = (TextView)v.findViewById(R.id.tab_title_textview);
        title_textview.setTextColor(this.completedTabTextColor);
        title_textview.setTypeface(Typeface.DEFAULT);
        this.setStatusBarTabIconVisibility(stepFragment.getStepIndex(), 0);
        this.setStatusBarTabIconDrawable(stepFragment.getStepIndex(), this.completedTabDrawable);
    }

    private void scrollStatusBar(int position) {
        int length = 0;
        for (int i = 0; i < position; ++i) {
            length += this.statusBarViewHolder.getChildAt(i).getMeasuredWidth();
        }
        this.statusBarScrollView.smoothScrollTo(length, 0);
    }

    private void initAdapter() {
        this.stepsAdapter = new StepsAdapter(this.fragmentManager, new ArrayList<StepFragment>());
        this.stepsViewpager.setAdapter((PagerAdapter)this.stepsAdapter);
    }

    public final FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    public final void setFragmentManager(FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
        this.initAdapter();
    }

    public int onBackPressed() {
        if (this.stepsAdapter.getItem(this.currentPosition).canGoBack()) {
            this.leftButton.performClick();
        }
        return this.currentPosition;
    }

    public final void addStep(StepFragment stepFragment) {
        if (this.fragmentManager == null) {
            Log.e((String)TAG, (String)"addStep():Fragment manager not set");
        } else {
            stepFragment.setParent(this);
            this.stepsAdapter.addPage(stepFragment);
            this.populateTabs();
            if (this.currentFragment == null) {
                this.currentFragment = stepFragment;
                this.navigationCallbacks = stepFragment;
                this.navigationCallbacks.initButtons(this.leftButton, this.rightButton, this.skipButton);
                this.initNavigationButtons();
                switch (this.currentFragment.getStatus()) {
                    case 1: {
                        break;
                    }
                    case 0: 
                    case 2: {
                        this.setCurrentTab(this.currentFragment);
                        break;
                    }
                    default: {
                        Log.wtf((String)TAG, (String)"onPageSelected():invalid status");
                        break;
                    }
                }
            } else {
                switch (this.currentFragment.getStatus()) {
                    case 1: {
                        break;
                    }
                    case 0: 
                    case 2: {
                        this.setCurrentTab(this.currentFragment);
                        break;
                    }
                    default: {
                        Log.wtf((String)TAG, (String)"onPageSelected():invalid status");
                    }
                }
            }
        }
    }

    private void initNavigationButtons() {
        if (this.fragmentManager == null) {
            Log.e((String)TAG, (String)"initNavigationButtons():Fragment manager not set");
        } else {
            this.rightButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MaterialStepper.this.currentFragment.getStepIndex() == MaterialStepper.this.stepsAdapter.getCount() - 1) {
                        MaterialStepper.this.navigationCallbacks.onRightCLicked();
                        MaterialStepper.this.onLastStepNextListener.onLastStepNext();
                    } else {
                        MaterialStepper.this.navigationCallbacks.onRightCLicked();
                    }
                }
            });
            this.leftButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MaterialStepper.this.navigationCallbacks.onLeftClicked();
                }
            });
            this.skipButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MaterialStepper.this.currentFragment.getStepIndex() == MaterialStepper.this.stepsAdapter.getCount() - 1) {
                        MaterialStepper.this.navigationCallbacks.onSkipClicked();
                        MaterialStepper.this.onLastStepNextListener.onLastStepNext();
                    } else {
                        MaterialStepper.this.navigationCallbacks.onSkipClicked();
                    }
                }
            });
        }
    }

    private void handleStatusOnNext(StepFragment stepFragment) {
        int status = stepFragment.getStatus();
        switch (status) {
            case 0: {
                this.setDefaultTab(stepFragment);
                break;
            }
            case 2: {
                this.setSkippedTab(stepFragment);
                break;
            }
            case 1: {
                this.setCompletedTab(stepFragment);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"handleStatus():invalid status");
            }
        }
    }

    private void populateTabs() {
        this.statusBarViewHolder.removeAllViews();
        for (int i = 0; i <= this.stepsAdapter.getCount() + 1; ++i) {
            View v;
            if (i >= this.stepsAdapter.getCount()) {
                v = this.getTabItem(null);
                v.setVisibility(4);
            } else if (i == this.stepsAdapter.getCount() - 1) {
                v = this.getTabItem(this.stepsAdapter.getItem(i));
                v.findViewById(R.id.dash).setVisibility(8);
            } else {
                v = this.getTabItem(this.stepsAdapter.getItem(i));
            }
            this.statusBarViewHolder.addView(v);
        }
    }

    private View getTabItem(StepFragment stepFragment) {
        View v = MaterialStepper.inflate((Context)this.mContext, (int)R.layout.material_stepper_tab, null);
        if (stepFragment == null) {
            return v;
        }
        CircularTextView icon_textview = (CircularTextView)v.findViewById(R.id.tab_icon_circulartextview);
        icon_textview.setSolidColor(this.defaultTabCircleColor);
        TextView title_textview = (TextView)v.findViewById(R.id.tab_title_textview);
        icon_textview.setText(String.valueOf(stepFragment.getStepIndex() + 1));
        title_textview.setText((CharSequence)stepFragment.getStepTitle());
        title_textview.setTextColor(this.defaultTabTextColor);
        return v;
    }

    @Override
    public void sendData(Bundle bundle, int stepIndex) {
        this.dataArray.put(stepIndex, (Object)bundle);
    }

    @Override
    public Bundle getData(int stepIndex) {
        return (Bundle)this.dataArray.get(stepIndex);
    }

    @Override
    public void swipeToPage(StepFragment currentFragment, int index) {
        this.handleStatusOnNext(currentFragment);
        this.stepsViewpager.setCurrentItem(index);
    }

    @Override
    public void setStatusBarTabIconVisibility(int position, int visibility) {
        if (visibility == 8 || visibility == 4) {
            ((CircularTextView)this.statusBarViewHolder.getChildAt(position).findViewById(R.id.tab_icon_circulartextview)).setText(position + 1 + "");
        } else {
            ((CircularTextView)this.statusBarViewHolder.getChildAt(position).findViewById(R.id.tab_icon_circulartextview)).setText(" ");
        }
        this.statusBarViewHolder.getChildAt(position).findViewById(R.id.tab_icon_circleimageview).setVisibility(visibility);
    }

    @Override
    public void setStatusBarTabIconDrawable(int position, int drawable2) {
        if (Build.VERSION.SDK_INT >= 21) {
            ((ImageView)this.statusBarViewHolder.getChildAt(position).findViewById(R.id.tab_icon_circleimageview)).setImageDrawable(this.getResources().getDrawable(drawable2, null));
        } else {
            ((ImageView)this.statusBarViewHolder.getChildAt(position).findViewById(R.id.tab_icon_circleimageview)).setImageDrawable(this.getResources().getDrawable(drawable2));
        }
    }
}

