/*
 * Decompiled with CFR 0.152.
 */
package com.somospnt.test.server;

import com.somospnt.test.server.AbstractMockRestOperation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class MockRestServiceServerBuilder {
    private final MockRestServiceServer mockServer;
    private final List<AbstractMockRestOperation> mockRestOperationList;

    private MockRestServiceServerBuilder(RestTemplate restTemplate) {
        this.mockServer = MockRestServiceServer.createServer((RestTemplate)restTemplate);
        this.mockRestOperationList = new ArrayList<AbstractMockRestOperation>();
    }

    public static MockRestServiceServerBuilder withRestTemplate(RestTemplate restTemplate) {
        return new MockRestServiceServerBuilder(restTemplate);
    }

    public MockRestServiceServerBuilder withMockOperation(AbstractMockRestOperation mockRestOperation) {
        Assert.notNull((Object)mockRestOperation, (String)"mockRestOperation must not be null.");
        this.mockRestOperationList.add(mockRestOperation);
        return this;
    }

    public MockRestServiceServer build() {
        if (this.mockRestOperationList.isEmpty()) {
            throw new IllegalStateException("mockRestOperationList must not be empty.");
        }
        this.mockRestOperationList.forEach(mockOperation -> mockOperation.mock(this.mockServer));
        return this.mockServer;
    }
}

