/*
 * Decompiled with CFR 0.152.
 */
package com.somospnt.loaderlib.service;

import com.somospnt.loaderlib.exception.LoaderException;
import com.somospnt.loaderlib.factory.LineMapperFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LoaderService<T> {
    private final JpaRepository<T, Long> jpaRepository;
    private final LineMapper<T> lineMapper;
    private final Logger log = LoggerFactory.getLogger(LoaderService.class);
    @Value(value="${loader.charset.encoding:windows-1252}")
    private Charset charsetEncoding;

    public LoaderService(JpaRepository<T, Long> jpaRepository, Class<T> clase, String ... nombresCampos) {
        this.jpaRepository = jpaRepository;
        this.lineMapper = LineMapperFactory.crear(clase, nombresCampos);
    }

    @PreAuthorize(value="hasAuthority('EJECUTAR_LOADER')")
    public void cargar(InputStream inputStream) {
        this.log.info("*********** COMIENZO LOADER ******************");
        this.jpaRepository.deleteAllInBatch();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream, this.charsetEncoding));
        reader.lines().forEach(linea -> this.cargarLinea((String)linea, reader.getLineNumber()));
        this.log.info(" Cantidad de lineas insertadas: {}", (Object)reader.getLineNumber());
        this.log.info("*********** FIN LOADER ***********************\n");
    }

    private void cargarLinea(String linea, int numeroLinea) {
        try {
            this.jpaRepository.save(this.lineMapper.mapLine(linea, 0));
        }
        catch (Exception ex) {
            throw new LoaderException(ex, numeroLinea);
        }
    }
}

