/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ExpandedProductParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.util.HashMap;

public final class ExpandedProductResultParser
extends ResultParser {
    @Override
    public ExpandedProductParsedResult parse(Result result) {
        String value;
        BarcodeFormat format = result.getBarcodeFormat();
        if (format != BarcodeFormat.RSS_EXPANDED) {
            return null;
        }
        String rawText = ExpandedProductResultParser.getMassagedText(result);
        String productID = null;
        String sscc = null;
        String lotNumber = null;
        String productionDate = null;
        String packagingDate = null;
        String bestBeforeDate = null;
        String expirationDate = null;
        String weight = null;
        String weightType = null;
        String weightIncrement = null;
        String price = null;
        String priceIncrement = null;
        String priceCurrency = null;
        HashMap<String, String> uncommonAIs = new HashMap<String, String>();
        for (int i = 0; i < rawText.length(); i += value.length()) {
            String ai = ExpandedProductResultParser.findAIvalue(i, rawText);
            if (ai == null) {
                return null;
            }
            value = ExpandedProductResultParser.findValue(i += ai.length() + 2, rawText);
            if (ai == "00") {
                sscc = value;
                continue;
            }
            if (ai == "01") {
                productID = value;
                continue;
            }
            if (ai == "10") {
                lotNumber = value;
                continue;
            }
            if (ai == "11") {
                productionDate = value;
                continue;
            }
            if (ai == "13") {
                packagingDate = value;
                continue;
            }
            if (ai == "15") {
                bestBeforeDate = value;
                continue;
            }
            if (ai == "17") {
                expirationDate = value;
                continue;
            }
            if (ai == "3100" || ai == "3101" || ai == "3102" || ai == "3103" || ai == "3104" || ai == "3105" || ai == "3106" || ai == "3107" || ai == "3108" || ai == "3109") {
                weight = value;
                weightType = "KG";
                weightIncrement = ai.substring(3);
                continue;
            }
            if (ai == "3200" || ai == "3201" || ai == "3202" || ai == "3203" || ai == "3204" || ai == "3205" || ai == "3206" || ai == "3207" || ai == "3208" || ai == "3209") {
                weight = value;
                weightType = "LB";
                weightIncrement = ai.substring(3);
                continue;
            }
            if (ai == "3920" || ai == "3921" || ai == "3922" || ai == "3923") {
                price = value;
                priceIncrement = ai.substring(3);
                continue;
            }
            if (ai == "3930" || ai == "3931" || ai == "3932" || ai == "3933") {
                if (value.length() < 4) {
                    return null;
                }
                price = value.substring(3);
                priceCurrency = value.substring(0, 3);
                priceIncrement = ai.substring(3);
                continue;
            }
            uncommonAIs.put(ai, value);
        }
        return new ExpandedProductParsedResult(rawText, productID, sscc, lotNumber, productionDate, packagingDate, bestBeforeDate, expirationDate, weight, weightType, weightIncrement, price, priceIncrement, priceCurrency, uncommonAIs);
    }

    private static String findAIvalue(int i, String rawText) {
        char c = rawText.charAt(i);
        if (c != '(') {
            return null;
        }
        String rawTextAux = rawText.substring(i + 1);
        StringBuilder buf = new StringBuilder();
        for (int index = 0; index < rawTextAux.length(); ++index) {
            char currentChar = rawTextAux.charAt(index);
            if (currentChar == ')') {
                return buf.toString();
            }
            if (currentChar < '0' || currentChar > '9') {
                return null;
            }
            buf.append(currentChar);
        }
        return buf.toString();
    }

    private static String findValue(int i, String rawText) {
        StringBuilder buf = new StringBuilder();
        String rawTextAux = rawText.substring(i);
        for (int index = 0; index < rawTextAux.length(); ++index) {
            char c = rawTextAux.charAt(index);
            if (c == '(') {
                if (ExpandedProductResultParser.findAIvalue(index, rawTextAux) != null) break;
                buf.append('(');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

